/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import sun.awt.font.StandardGlyphVector;
import sun.awt.font.TextLabel;
import sun.awt.font.TextSource;

public class TextSourceLabel
extends TextLabel {
    TextSource source;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    GlyphVector gv;

    public TextSourceLabel(TextSource textSource) {
        this(textSource, null, null, null);
    }

    public TextSourceLabel(TextSource textSource, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, GlyphVector glyphVector) {
        this.source = textSource;
        this.lb = rectangle2D;
        this.ab = rectangle2D2;
        this.gv = glyphVector;
    }

    public TextSource getSource() {
        return this.source;
    }

    public final Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public final Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    public final Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    public Shape getOutline(float f, float f2) {
        return this.getGV().getOutline(f, f2);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawGlyphVector(this.getGV(), f, f2);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    protected Rectangle2D createVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    protected Rectangle2D createAlignBounds() {
        return this.createLogicalBounds();
    }

    private final GlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    protected GlyphVector createGV() {
        Font font = this.source.getFont();
        FontRenderContext fontRenderContext = this.source.getFRC();
        int n = this.source.getLayoutFlags();
        char[] cArray = this.source.getChars();
        int n2 = this.source.getStart();
        int n3 = this.source.getLength();
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(font, cArray, n2, n3, n, fontRenderContext);
        return standardGlyphVector;
    }
}

