/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.loops.FontInfo;

public final class GlyphList {
    private static final int MINGRAYLENGTH = 1024;
    private static final int MAXGRAYLENGTH = 8192;
    long pData;
    int glyphindex;
    int[] metrics;
    byte[] graybits;
    private static GlyphList saved;

    private static native void initIDs();

    private GlyphList() {
    }

    public long getPeer() {
        return this.pData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphList getInstance() {
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            GlyphList glyphList = saved;
            if (glyphList == null) {
                glyphList = new GlyphList();
            } else {
                saved = null;
            }
            return glyphList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromString(FontInfo fontInfo, String string, float f, float f2) {
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.setupStringData(string, fontInfo.font, f, f2, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromChars(FontInfo fontInfo, char[] cArray, int n, int n2, float f, float f2) {
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.setupCharData(cArray, n, n2, fontInfo.font, f, f2, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromBytes(FontInfo fontInfo, byte[] byArray, int n, int n2, float f, float f2) {
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.setupByteData(byArray, n, n2, fontInfo.font, f, f2, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromGlyphVector(FontInfo fontInfo, GlyphVector glyphVector, float f, float f2) {
        Object object;
        double[] dArray = null;
        FontRenderContext fontRenderContext = glyphVector.getFontRenderContext();
        boolean bl = fontRenderContext.isAntiAliased();
        boolean bl2 = fontRenderContext.usesFractionalMetrics();
        try {
            object = (StandardGlyphVector)glyphVector;
            dArray = ((StandardGlyphVector)object).fontTX;
        }
        catch (ClassCastException classCastException) {
            dArray = new double[6];
            double d = fontInfo.font.getSize2D();
            if (fontInfo.font.isTransformed()) {
                fontInfo.font.getTransform().getMatrix(dArray);
                int n = 0;
                while (n < dArray.length) {
                    int n2 = n++;
                    dArray[n2] = dArray[n2] * d;
                }
            }
            dArray[0] = dArray[3] = d;
        }
        object = NativeFontWrapper.class;
        synchronized (object) {
            this.setupGlyphData(glyphVector, fontInfo.font, f, f2, dArray, fontInfo.devTx, bl, bl2);
            this.glyphindex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBounds() {
        if (this.glyphindex >= 0) {
            throw new InternalError("calling getBounds after setGlyphIndex");
        }
        if (this.metrics == null) {
            this.metrics = new int[4];
        }
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.fillBounds(this.metrics);
        }
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlyphIndex(int n) {
        this.glyphindex = n;
        if (this.metrics == null) {
            this.metrics = new int[4];
        }
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.fillMetrics(n, this.metrics);
        }
    }

    public int[] getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGrayBits() {
        int n = this.metrics[2] * this.metrics[3];
        if (this.graybits == null) {
            this.graybits = new byte[Math.max(n, 1024)];
        } else if (n > this.graybits.length) {
            this.graybits = new byte[n];
        }
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.fillGrayBits(this.glyphindex, this.graybits);
        }
        return this.graybits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class clazz = NativeFontWrapper.class;
        synchronized (clazz) {
            this.discardData();
            if (this.graybits != null && this.graybits.length > 8192) {
                this.graybits = null;
            }
            saved = this;
        }
    }

    private native void setupStringData(String var1, Font var2, float var3, float var4, double[] var5, boolean var6, boolean var7);

    private native void setupCharData(char[] var1, int var2, int var3, Font var4, float var5, float var6, double[] var7, boolean var8, boolean var9);

    private native void setupByteData(byte[] var1, int var2, int var3, Font var4, float var5, float var6, double[] var7, boolean var8, boolean var9);

    private native void setupGlyphData(GlyphVector var1, Font var2, float var3, float var4, double[] var5, double[] var6, boolean var7, boolean var8);

    public native int getNumGlyphs();

    private native void fillBounds(int[] var1);

    private native void fillMetrics(int var1, int[] var2);

    private native void fillGrayBits(int var1, byte[] var2);

    private native void discardData();

    static {
        GlyphList.initIDs();
    }
}

