/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11PMBlitBgLoops;
import sun.awt.X11PMBlitLoops;
import sun.awt.X11Renderer;
import sun.awt.font.X11TextRenderer;
import sun.awt.image.PixelConverter;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11OffScreenImage;
import sun.awt.motif.X11VolatileImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.TextPipe;
import sun.security.action.GetPropertyAction;

public abstract class X11SurfaceData
extends SurfaceData {
    MComponentPeer peer;
    private X11GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_INT_BGR_X11 = "Integer BGR Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_BYTE_IND_OPQ_X11 = "Byte Indexed Opaque Pixmap";
    public static final String DESC_INT_BGR_X11_BM = "Integer BGR Pixmap with 1-bit transp";
    public static final String DESC_INT_RGB_X11_BM = "Integer RGB Pixmap with 1-bit transp";
    public static final String DESC_BYTE_IND_X11_BM = "Byte Indexed Pixmap with 1-bit transp";
    public static final String DESC_BYTE_GRAY_X11 = "Byte Gray Opaque Pixmap";
    public static final String DESC_INDEX8_GRAY_X11 = "Index8 Gray Opaque Pixmap";
    public static final String DESC_BYTE_GRAY_X11_BM = "Byte Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_INDEX8_GRAY_X11_BM = "Index8 Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_RGB_X11 = "3 Byte RGB Pixmap";
    public static final String DESC_3BYTE_BGR_X11 = "3 Byte BGR Pixmap";
    public static final String DESC_3BYTE_RGB_X11_BM = "3 Byte RGB Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_BGR_X11_BM = "3 Byte BGR Pixmap with 1-bit transp";
    public static final String DESC_USHORT_555_RGB_X11 = "Ushort 555 RGB Pixmap";
    public static final String DESC_USHORT_565_RGB_X11 = "Ushort 565 RGB Pixmap";
    public static final String DESC_USHORT_555_RGB_X11_BM = "Ushort 555 RGB Pixmap with 1-bit transp";
    public static final String DESC_USHORT_565_RGB_X11_BM = "Ushort 565 RGB Pixmap with 1-bit transp";
    public static final SurfaceType IntBgrX11 = SurfaceType.IntBgr.deriveSubType("Integer BGR Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType ThreeByteRgbX11 = SurfaceType.ThreeByteRgb.deriveSubType("3 Byte RGB Pixmap");
    public static final SurfaceType ThreeByteBgrX11 = SurfaceType.ThreeByteBgr.deriveSubType("3 Byte BGR Pixmap");
    public static final SurfaceType UShort555RgbX11 = SurfaceType.Ushort555Rgb.deriveSubType("Ushort 555 RGB Pixmap");
    public static final SurfaceType UShort565RgbX11 = SurfaceType.Ushort565Rgb.deriveSubType("Ushort 565 RGB Pixmap");
    public static final SurfaceType ByteIndexedOpaqueX11 = SurfaceType.ByteIndexedOpaque.deriveSubType("Byte Indexed Opaque Pixmap");
    public static final SurfaceType ByteGrayX11 = SurfaceType.ByteGray.deriveSubType("Byte Gray Opaque Pixmap");
    public static final SurfaceType Index8GrayX11 = SurfaceType.Index8Gray.deriveSubType("Index8 Gray Opaque Pixmap");
    public static final SurfaceType IntBgrX11_BM = SurfaceType.Custom.deriveSubType("Integer BGR Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType IntRgbX11_BM = SurfaceType.Custom.deriveSubType("Integer RGB Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType ThreeByteRgbX11_BM = SurfaceType.Custom.deriveSubType("3 Byte RGB Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType ThreeByteBgrX11_BM = SurfaceType.Custom.deriveSubType("3 Byte BGR Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType UShort555RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 555 RGB Pixmap with 1-bit transp", PixelConverter.Ushort555Rgb.instance);
    public static final SurfaceType UShort565RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 565 RGB Pixmap with 1-bit transp", PixelConverter.Ushort565Rgb.instance);
    public static final SurfaceType ByteIndexedX11_BM = SurfaceType.Custom.deriveSubType("Byte Indexed Pixmap with 1-bit transp");
    public static final SurfaceType ByteGrayX11_BM = SurfaceType.Custom.deriveSubType("Byte Gray Opaque Pixmap with 1-bit transp");
    public static final SurfaceType Index8GrayX11_BM = SurfaceType.Custom.deriveSubType("Index8 Gray Opaque Pixmap with 1-bit transp");
    private static Boolean accelerationEnabled = null;
    protected static X11Renderer x11pipe;
    protected static PixelToShapeConverter x11txpipe;
    protected static TextPipe x11textpipe;

    private static native void initIDs(Class var0);

    protected native void initSurface(int var1, int var2, int var3, long var4, int var6);

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public static native boolean isDgaAvailable();

    public static boolean isAccelerationEnabled() {
        if (accelerationEnabled == null) {
            String string;
            accelerationEnabled = GraphicsEnvironment.isHeadless() ? Boolean.FALSE : ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.pmoffscreen"))) != null ? new Boolean(string) : new Boolean(!X11SurfaceData.isDgaAvailable()));
        }
        return accelerationEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        block8: {
            block9: {
                if (sunGraphics2D.antialiasHint == 2) break block8;
                if (sunGraphics2D.paintState != 0) break block8;
                if (sunGraphics2D.compositeState == 0) break block9;
                if (sunGraphics2D.compositeState != 2) break block8;
            }
            if (sunGraphics2D.clipState != 2) {
                sunGraphics2D.imagepipe = imagepipe;
                if (sunGraphics2D.transformState > 1) {
                    sunGraphics2D.drawpipe = x11txpipe;
                    sunGraphics2D.fillpipe = x11txpipe;
                } else if (sunGraphics2D.strokeState != 0) {
                    sunGraphics2D.drawpipe = x11txpipe;
                    sunGraphics2D.fillpipe = x11pipe;
                } else {
                    sunGraphics2D.drawpipe = x11pipe;
                    sunGraphics2D.fillpipe = x11pipe;
                }
                sunGraphics2D.shapepipe = x11pipe;
                sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint != 2 ? (sunGraphics2D.compositeState == 0 ? x11textpipe : solidTextRenderer) : aaTextRenderer;
                sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
                return;
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static X11WindowSurfaceData createData(MComponentPeer mComponentPeer) {
        X11GraphicsConfig x11GraphicsConfig = X11SurfaceData.getGC(mComponentPeer);
        return new X11WindowSurfaceData(mComponentPeer, x11GraphicsConfig, x11GraphicsConfig.getSurfaceType());
    }

    public static X11PixmapSurfaceData createData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, ColorModel colorModel, Image image) {
        return X11SurfaceData.createData(x11GraphicsConfig, n, n2, colorModel, image, 0L, 0);
    }

    public static X11PixmapSurfaceData createData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, ColorModel colorModel, Image image, long l, int n3) {
        return new X11PixmapSurfaceData(x11GraphicsConfig, n, n2, image, X11SurfaceData.getSurfaceType(x11GraphicsConfig, n3 != 0), colorModel, l, n3);
    }

    private native void initOps(MComponentPeer var1, X11GraphicsConfig var2, int var3);

    protected X11SurfaceData(MComponentPeer mComponentPeer, X11GraphicsConfig x11GraphicsConfig, SurfaceType surfaceType, ColorModel colorModel) {
        super(surfaceType, colorModel);
        this.peer = mComponentPeer;
        this.graphicsConfig = x11GraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.depth = colorModel.getPixelSize();
        this.initOps(mComponentPeer, this.graphicsConfig, this.depth);
    }

    public static X11GraphicsConfig getGC(MComponentPeer mComponentPeer) {
        if (mComponentPeer != null) {
            return (X11GraphicsConfig)mComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (X11GraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 2) {
            if (sunGraphics2D.clipState != 2 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
                int n7 = (n += sunGraphics2D.transX) + n5;
                int n8 = (n2 += sunGraphics2D.transY) + n6;
                int n9 = n7 + n3;
                int n10 = n8 + n4;
                Region region = sunGraphics2D.getCompClip();
                if (n7 < region.getLoX()) {
                    n7 = region.getLoX();
                }
                if (n8 < region.getLoY()) {
                    n8 = region.getLoY();
                }
                if (n9 > region.getHiX()) {
                    n9 = region.getHiX();
                }
                if (n10 > region.getHiY()) {
                    n10 = region.getHiY();
                }
                if (n7 < n9 && n8 < n10) {
                    x11pipe.devCopyArea(this, n7 - n5, n8 - n6, n7, n8, n9 - n7, n10 - n8);
                }
                return true;
            }
        }
        return false;
    }

    protected static SurfaceType getSurfaceType(X11GraphicsConfig x11GraphicsConfig, boolean bl) {
        SurfaceType surfaceType;
        ColorModel colorModel = x11GraphicsConfig.getColorModel();
        switch (colorModel.getPixelSize()) {
            case 24: {
                if (x11GraphicsConfig.getBitsPerPixel() == 24) {
                    if (colorModel instanceof DirectColorModel) {
                        surfaceType = bl ? ThreeByteBgrX11_BM : ThreeByteBgrX11;
                        break;
                    }
                    throw new InvalidPipeException("Unsupported bit depth/cm combo: " + colorModel.getPixelSize() + ", " + colorModel);
                }
            }
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        surfaceType = bl ? IntRgbX11_BM : IntRgbX11;
                        break;
                    }
                    surfaceType = bl ? IntBgrX11_BM : IntBgrX11;
                    break;
                }
                throw new InvalidPipeException("Unsupported bit depth/cm combo: " + colorModel.getPixelSize() + ", " + colorModel);
            }
            case 15: {
                surfaceType = bl ? UShort555RgbX11_BM : UShort555RgbX11;
                break;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getGreenMask() == 992) {
                    surfaceType = bl ? UShort555RgbX11_BM : UShort555RgbX11;
                    break;
                }
                surfaceType = bl ? UShort565RgbX11_BM : UShort565RgbX11;
                break;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    surfaceType = bl ? ByteGrayX11_BM : ByteGrayX11;
                    break;
                }
                if (colorModel instanceof IndexColorModel && X11SurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    surfaceType = bl ? Index8GrayX11_BM : Index8GrayX11;
                    break;
                }
                surfaceType = bl ? ByteIndexedX11_BM : ByteIndexedOpaqueX11;
                break;
            }
            default: {
                throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
            }
        }
        return surfaceType;
    }

    public native void setInvalid();

    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11SurfaceData.initIDs(XORComposite.class);
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.xtextpipe"));
            if (string == null || "true".startsWith(string)) {
                if ("true".equals(string)) {
                    System.out.println("using X11 text renderer");
                }
                x11textpipe = new X11TextRenderer();
            } else {
                if ("false".equals(string)) {
                    System.out.println("using DGA text renderer");
                }
                x11textpipe = solidTextRenderer;
            }
            if (X11SurfaceData.isAccelerationEnabled()) {
                X11PMBlitLoops.register();
                X11PMBlitBgLoops.register();
            }
            x11pipe = new X11Renderer();
            if (GraphicsPrimitive.tracingEnabled()) {
                x11pipe = x11pipe.traceWrap();
                if (x11textpipe instanceof X11TextRenderer) {
                    x11textpipe = ((X11TextRenderer)x11textpipe).traceWrap();
                }
            }
            x11txpipe = new PixelToShapeConverter(x11pipe);
        }
    }

    public static class X11PixmapSurfaceData
    extends X11SurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;

        public X11PixmapSurfaceData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, Image image, SurfaceType surfaceType, ColorModel colorModel, long l, int n3) {
            super(null, x11GraphicsConfig, surfaceType, colorModel);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = n3 != 0 ? 2 : 1;
            this.initSurface(this.depth, n, n2, l, n3);
        }

        public SurfaceData getReplacement() {
            if (this.offscreenImage instanceof X11OffScreenImage) {
                return ((X11OffScreenImage)this.offscreenImage).restoreContents();
            }
            return ((X11VolatileImage)this.offscreenImage).restoreContents();
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }
    }

    public static class X11WindowSurfaceData
    extends X11SurfaceData {
        public X11WindowSurfaceData(MComponentPeer mComponentPeer, X11GraphicsConfig x11GraphicsConfig, SurfaceType surfaceType) {
            super(mComponentPeer, x11GraphicsConfig, surfaceType, mComponentPeer.getColorModel());
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }
    }
}

