/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.HashSet;
import sun.awt.X11GraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    private static DisplayMode displayMode;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int n) {
        this.screen = n;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    public native long getDisplay();

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ":0." + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n = 0;
            int n2 = this.getNumConfigs(this.screen);
            graphicsConfigurationArray = new GraphicsConfiguration[n2];
            if (this.defaultConfig != null) {
                graphicsConfigurationArray[0] = this.defaultConfig;
                ++n;
            }
            if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (n < n2) {
                long l = this.getConfigVisualId(n, this.screen);
                boolean bl = X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals.contains(new Long(l));
                graphicsConfigurationArray[n] = X11GraphicsConfig.getConfig(this, l, bl);
                ++n;
            }
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public native int getNumConfigs(int var1);

    public native long getConfigVisualId(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(long l) {
        this.doubleBufferVisuals.add(new Long(l));
    }

    private native void getDoubleBufferVisuals(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            long l = this.getConfigVisualId(0, this.screen);
            boolean bl = false;
            if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
                bl = this.doubleBufferVisuals.contains(new Long(l));
            }
            this.defaultConfig = X11GraphicsConfig.getConfig(this, l, bl);
        }
        return this.defaultConfig;
    }

    public DisplayMode getDisplayMode() {
        if (displayMode == null) {
            GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            displayMode = new DisplayMode(rectangle.width, rectangle.height, -1, 0);
        }
        return displayMode;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

