/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.peer.FontPeer;
import java.util.Hashtable;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.FontProperties;
import sun.awt.NativeLibLoader;
import sun.awt.font.NativeFontWrapper;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.java2d.FontSupport;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected FontProperties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String familyName;
    protected String styleString;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;
    protected static FontProperties fprops;

    public PlatformFont(String string, int n) {
        int n2;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            this.props = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
        if (this.props == null && (this.props = fprops) == null) {
            return;
        }
        this.props = fprops;
        this.familyName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.familyName == null) {
            this.familyName = string.toLowerCase();
        }
        if (this.props.getProperty(this.familyName + ".0") == null && this.props.getProperty(this.familyName + ".plain.0") == null) {
            if (NativeFontWrapper.isKnown(string)) {
                this.props = null;
                return;
            }
            this.familyName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector<FontDescriptor> vector = new Vector<FontDescriptor>(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(this.familyName + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(this.familyName + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.familyName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.familyName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.familyName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.familyName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    String string6;
                    String string7;
                    int n6 = 0;
                    int n7 = 0;
                    try {
                        string7 = string5.substring(i * 10, i * 10 + 4);
                        string6 = string5.substring(i * 10 + 5, i * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n6 = Integer.parseInt(string7, 16);
                        n7 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[i] = n6 << 16 | n7;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.componentFonts[n2] = (FontDescriptor)vector.elementAt(n2);
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        for (int i = 0; i < this.componentFonts.length; ++i) {
            if (this.componentFonts[i].isExcluded((char)n2) || !this.componentFonts[i].fontCharset.canConvert((char)n2)) continue;
            this.defaultFont = this.componentFonts[i];
            this.defaultChar = (char)n2;
            break;
        }
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), true);
    }

    public CharsetString[] makeMultiCharsetString(String string, boolean bl) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), bl);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        return this.makeMultiCharsetString(cArray, n, n2, true);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2, boolean bl) {
        CharsetString[] charsetStringArray;
        int n3;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector<CharsetString> vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        FontDescriptor fontDescriptor = this.defaultFont;
        for (n3 = 0; n3 < this.componentFonts.length; ++n3) {
            if (this.componentFonts[n3].isExcluded(cArray[n]) || !this.componentFonts[n3].fontCharset.canConvert(cArray[n])) continue;
            fontDescriptor = this.componentFonts[n3];
            c = cArray[n];
            break;
        }
        if (!bl && c == this.defaultChar) {
            return null;
        }
        cArray2[0] = c;
        n3 = 0;
        for (int i = 1; i < n2; ++i) {
            char c2 = cArray[n + i];
            FontDescriptor fontDescriptor2 = this.defaultFont;
            c = this.defaultChar;
            for (int j = 0; j < this.componentFonts.length; ++j) {
                if (this.componentFonts[j].isExcluded(c2) || !this.componentFonts[j].fontCharset.canConvert(c2)) continue;
                fontDescriptor2 = this.componentFonts[j];
                c = c2;
                break;
            }
            if (!bl && c == this.defaultChar) {
                return null;
            }
            cArray2[i] = c;
            if (fontDescriptor == fontDescriptor2) continue;
            if (vector == null) {
                vector = new Vector<CharsetString>(3);
            }
            vector.addElement(new CharsetString(cArray2, n3, i - n3, fontDescriptor));
            fontDescriptor = fontDescriptor2;
            fontDescriptor2 = this.defaultFont;
            n3 = i;
        }
        CharsetString charsetString = new CharsetString(cArray2, n3, n2 - n3, fontDescriptor);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{charsetString};
        } else {
            vector.addElement(charsetString);
            charsetStringArray = new CharsetString[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                charsetStringArray[i] = (CharsetString)vector.elementAt(i);
            }
        }
        return charsetStringArray;
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    public Object[] makeConvertedMultiFontString(String string) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    public Object[] makeConvertedMultiFontString(String string, Font font) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length(), font);
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(cArray, n, n2, null);
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n, int n2, Font font) throws MalformedInputException, ConversionBufferFullException {
        int n3;
        Object[] objectArray = new Object[2];
        byte[] byArray = null;
        int n4 = 0;
        int n5 = 0;
        FontDescriptor fontDescriptor = null;
        FontDescriptor fontDescriptor2 = null;
        int n6 = n + n2;
        if (n < 0 || n6 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 >= n6) {
            return null;
        }
        for (n3 = n; n3 < n6; ++n3) {
            char c = cArray[n3];
            int n7 = c & FONTCACHEMASK;
            PlatformFontCache platformFontCache = (PlatformFontCache)this.getFontCache()[n7];
            if (platformFontCache == null || platformFontCache.uniChar != c) {
                fontDescriptor = this.defaultFont;
                c = this.defaultChar;
                char c2 = cArray[n3];
                int n8 = this.componentFonts.length;
                for (int i = 0; i < n8; ++i) {
                    FontDescriptor fontDescriptor3 = this.componentFonts[i];
                    fontDescriptor3.fontCharset.reset();
                    fontDescriptor3.fontCharset.setSubstitutionMode(false);
                    if (fontDescriptor3.isExcluded(c2) || !fontDescriptor3.fontCharset.canConvert(c2) || font != null && !NativeFontWrapper.canDisplaySlot(font, i, c2)) continue;
                    fontDescriptor = fontDescriptor3;
                    c = c2;
                    break;
                }
                try {
                    char[] cArray2 = new char[]{c};
                    platformFontCache = new PlatformFontCache();
                    platformFontCache.encodingSize = fontDescriptor.useUnicode() ? (byte)fontDescriptor.unicodeCharset.convert(cArray2, 0, 1, platformFontCache.encoding, 0, 4) : (byte)fontDescriptor.fontCharset.convert(cArray2, 0, 1, platformFontCache.encoding, 0, 4);
                    platformFontCache.fontDescriptor = fontDescriptor;
                    platformFontCache.uniChar = cArray[n3];
                    this.getFontCache()[n7] = platformFontCache;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    exception.printStackTrace();
                    return null;
                }
            }
            if (fontDescriptor2 != platformFontCache.fontDescriptor) {
                if (fontDescriptor2 != null) {
                    objectArray[n5++] = fontDescriptor2;
                    objectArray[n5++] = byArray;
                    if (byArray != null) {
                        byArray[0] = (byte)((n4 -= 4) >> 24);
                        byArray[1] = (byte)(n4 >> 16);
                        byArray[2] = (byte)(n4 >> 8);
                        byArray[3] = (byte)n4;
                    }
                    if (n5 >= objectArray.length) {
                        Object[] objectArray2 = new Object[objectArray.length * 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray = objectArray2;
                    }
                }
                byArray = platformFontCache.fontDescriptor.useUnicode() ? new byte[(n6 - n3 + 1) * platformFontCache.fontDescriptor.unicodeCharset.getMaxBytesPerChar() + 4] : new byte[(n6 - n3 + 1) * platformFontCache.fontDescriptor.fontCharset.getMaxBytesPerChar() + 4];
                n4 = 4;
                fontDescriptor2 = platformFontCache.fontDescriptor;
            }
            if (platformFontCache.encodingSize == 1) {
                byArray[n4++] = platformFontCache.encoding[0];
                continue;
            }
            if (platformFontCache.encodingSize == 2) {
                byArray[n4++] = platformFontCache.encoding[0];
                byArray[n4++] = platformFontCache.encoding[1];
                continue;
            }
            if (platformFontCache.encodingSize == 3) {
                byArray[n4++] = platformFontCache.encoding[0];
                byArray[n4++] = platformFontCache.encoding[1];
                byArray[n4++] = platformFontCache.encoding[2];
                continue;
            }
            if (platformFontCache.encodingSize != 4) continue;
            byArray[n4++] = platformFontCache.encoding[0];
            byArray[n4++] = platformFontCache.encoding[1];
            byArray[n4++] = platformFontCache.encoding[2];
            byArray[n4++] = platformFontCache.encoding[3];
        }
        objectArray[n5++] = fontDescriptor2;
        objectArray[n5++] = byArray;
        if (byArray != null) {
            byArray[0] = (byte)((n4 -= 4) >> 24);
            byArray[1] = (byte)(n4 >> 16);
            byArray[2] = (byte)(n4 >> 8);
            byArray[3] = (byte)n4;
        }
        return objectArray;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        charsetRegistry = new Hashtable(5);
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            fprops = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
    }

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        byte encodingSize;
        byte[] encoding = new byte[4];

        PlatformFontCache() {
        }
    }
}

