/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import sun.awt.NativeLibLoader;
import sun.io.CharToByteConverter;
import sun.io.CharToByteUnicode;

public class FontDescriptor
implements Cloneable {
    String nativeName;
    public CharToByteConverter fontCharset;
    int[] exclusionRanges;
    public CharToByteConverter unicodeCharset;
    boolean useUnicode;

    public FontDescriptor(String string, CharToByteConverter charToByteConverter, int[] nArray) {
        this.nativeName = string;
        this.fontCharset = charToByteConverter;
        this.exclusionRanges = nArray;
        this.useUnicode = false;
    }

    public boolean isExcluded(char c) {
        for (int i = 0; i < this.exclusionRanges.length; ++i) {
            int n = this.exclusionRanges[i] >> 16 & 0xFFFF;
            int n2 = this.exclusionRanges[i] & 0xFFFF;
            if (c < n || c > n2) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " [" + this.nativeName + "|" + this.fontCharset + "]";
    }

    private static native void initIDs();

    public boolean useUnicode() {
        if (this.useUnicode && this.unicodeCharset == null) {
            this.unicodeCharset = new CharToByteUnicode(false);
        }
        return this.useUnicode;
    }

    static {
        NativeLibLoader.loadLibraries();
        FontDescriptor.initIDs();
    }
}

