/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.awt.ClassDebugHelperImpl;
import sun.awt.DebugHelper;
import sun.awt.DebugSettings;
import sun.awt.GlobalDebugHelperImpl;
import sun.awt.NativeLibLoader;

abstract class DebugHelperImpl
extends DebugHelper {
    protected static DebugSettings settings;
    protected static DebugHelperImpl globalDebugHelperImpl;
    private static boolean initialized;
    private static final String PROP_ON = "on";
    private static final String PROP_TRACE = "trace";
    private static final String PROP_ASSERT = "assert";
    private DebugHelperImpl parent = null;
    private boolean tracingOn = false;
    private boolean assertionsOn = false;

    static final void initGlobals() {
        if (!initialized) {
            NativeLibLoader.loadLibraries();
            initialized = true;
            settings = DebugSettings.getInstance();
            globalDebugHelperImpl = GlobalDebugHelperImpl.getInstance();
        }
    }

    static final DebugHelper factoryCreate(Class clazz) {
        DebugHelperImpl.initGlobals();
        return new ClassDebugHelperImpl(clazz);
    }

    protected DebugHelperImpl(DebugHelperImpl debugHelperImpl) {
        this.parent = debugHelperImpl;
    }

    public final synchronized void setAssertOn(boolean bl) {
        this.assertionsOn = bl;
    }

    public final synchronized void setTraceOn(boolean bl) {
        this.tracingOn = bl;
    }

    public final synchronized void setDebugOn(boolean bl) {
        try {
            Class clazz = DebugHelper.class;
            Field field = clazz.getDeclaredField(PROP_ON);
            if (!Modifier.isFinal(field.getModifiers())) {
                field.setBoolean(this, bl);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public final synchronized void println(Object object) {
        if (this.tracingOn) {
            DebugHelperImpl.printlnImpl(object.toString());
        }
    }

    public final synchronized void print(Object object) {
        if (this.tracingOn) {
            DebugHelperImpl.printImpl(object.toString());
        }
    }

    public final synchronized String toString() {
        String string = "Debug {\ton=false, \ttrace=" + this.tracingOn + ", " + "\tassert=" + this.assertionsOn + "}";
        return string;
    }

    static synchronized native void printlnImpl(String var0);

    static synchronized native void printImpl(String var0);

    protected synchronized native void setCTracingOn(boolean var1);

    protected synchronized native void setCTracingOn(boolean var1, String var2);

    protected synchronized native void setCTracingOn(boolean var1, String var2, int var3);

    public final synchronized void printStackTrace() {
        if (this.tracingOn) {
            Thread.dumpStack();
        }
    }

    public final synchronized void assertion(boolean bl) {
        this.assertion(bl, "");
    }

    public final synchronized void assertion(boolean bl, String string) {
        if (this.assertionsOn && !bl) {
            throw new AssertionFailure(string);
        }
    }

    protected void setParent(DebugHelperImpl debugHelperImpl) {
        this.parent = debugHelperImpl;
    }

    protected DebugHelperImpl getParent() {
        return this.parent;
    }

    protected void loadSettings() {
        boolean bl = this.getBoolean(PROP_ON, this.parent == null);
        boolean bl2 = this.getBoolean(PROP_ASSERT, this.parent != null ? this.parent.assertionsOn : true);
        boolean bl3 = this.getBoolean(PROP_TRACE, this.parent != null ? this.parent.tracingOn : false);
        this.setDebugOn(bl);
        this.setAssertOn(bl2);
        this.setTraceOn(bl3);
    }

    protected synchronized boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string, String.valueOf(bl));
        return string2.equalsIgnoreCase("true");
    }

    protected synchronized int getInt(String string, int n) {
        String string2 = this.getString(string, String.valueOf(n));
        return Integer.parseInt(string2);
    }

    protected synchronized String getString(String string, String string2) {
        String string3 = settings.getString(string, string2);
        return string3;
    }

    static {
        initialized = false;
    }

    class AssertionFailure
    extends Error {
        AssertionFailure(String string) {
            super(string);
        }
    }
}

