/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(element);
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(element);
    }

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getColumnSpan(int n) {
        return this.columnSpans[n];
    }

    int getRowCount() {
        return this.rows.size();
    }

    int getRowSpan(int n) {
        TableRow tableRow = this.getRow(n);
        if (tableRow != null) {
            return (int)((View)tableRow).getPreferredSpan(1);
        }
        return 0;
    }

    TableRow getRow(int n) {
        if (n < this.rows.size()) {
            return (TableRow)this.rows.elementAt(n);
        }
        return null;
    }

    int getColumnsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    void invalidateGrid() {
        this.gridValid = false;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.invalidateGrid();
    }

    void updateGrid() {
        if (!this.gridValid) {
            int n;
            int n2;
            this.rows.removeAllElements();
            int n3 = this.getViewCount();
            for (n2 = 0; n2 < n3; ++n2) {
                View view = this.getView(n2);
                if (!(view instanceof TableRow)) continue;
                this.rows.addElement(view);
                TableRow tableRow = (TableRow)view;
                tableRow.clearFilledColumns();
                tableRow.setRow(n2);
            }
            n2 = 0;
            int n4 = this.rows.size();
            for (n = 0; n < n4; ++n) {
                TableRow tableRow = this.getRow(n);
                int n5 = 0;
                int n6 = 0;
                while (n6 < tableRow.getViewCount()) {
                    View view = tableRow.getView(n6);
                    while (tableRow.isFilled(n5)) {
                        ++n5;
                    }
                    int n7 = this.getRowsOccupied(view);
                    int n8 = this.getColumnsOccupied(view);
                    if (n8 > 1 || n7 > 1) {
                        int n9 = n + n7;
                        int n10 = n5 + n8;
                        for (int i = n; i < n9; ++i) {
                            for (int j = n5; j < n10; ++j) {
                                if (i == n && j == n5) continue;
                                this.addFill(i, j);
                            }
                        }
                        if (n8 > 1) {
                            n5 += n8 - 1;
                        }
                    }
                    ++n6;
                    ++n5;
                }
                n2 = Math.max(n2, n5);
            }
            this.columnSpans = new int[n2];
            this.columnOffsets = new int[n2];
            this.columnRequirements = new SizeRequirements[n2];
            for (n = 0; n < n2; ++n) {
                this.columnRequirements[n] = new SizeRequirements();
            }
            this.gridValid = true;
        }
    }

    void addFill(int n, int n2) {
        TableRow tableRow = this.getRow(n);
        if (tableRow != null) {
            tableRow.fillColumn(n2);
        }
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements.calculateTiledPositions(n, null, sizeRequirementsArray, nArray, nArray2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n3 = this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            TableRow tableRow = this.getRow(i);
            tableRow.layoutChanged(n2);
        }
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        this.updateGrid();
        this.calculateColumnRequirements(n);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < this.columnRequirements.length; ++i) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[i];
            l += (long)sizeRequirements2.minimum;
            l2 += (long)sizeRequirements2.preferred;
            l3 += (long)sizeRequirements2.maximum;
        }
        sizeRequirements.minimum = (int)l;
        sizeRequirements.preferred = (int)l2;
        sizeRequirements.maximum = (int)l3;
        sizeRequirements.alignment = 0.0f;
        return sizeRequirements;
    }

    void calculateColumnRequirements(int n) {
        int n2;
        View view;
        int n3;
        int n4;
        int n5;
        TableRow tableRow;
        int n6;
        boolean bl = false;
        int n7 = this.getRowCount();
        for (n6 = 0; n6 < n7; ++n6) {
            tableRow = this.getRow(n6);
            n5 = 0;
            n4 = tableRow.getViewCount();
            n3 = 0;
            while (n3 < n4) {
                view = tableRow.getView(n3);
                while (tableRow.isFilled(n5)) {
                    ++n5;
                }
                n2 = this.getRowsOccupied(view);
                int n8 = this.getColumnsOccupied(view);
                if (n8 == 1) {
                    this.checkSingleColumnCell(n, n5, view);
                } else {
                    bl = true;
                    n5 += n8 - 1;
                }
                ++n3;
                ++n5;
            }
        }
        if (bl) {
            for (n6 = 0; n6 < n7; ++n6) {
                tableRow = this.getRow(n6);
                n5 = 0;
                n4 = tableRow.getViewCount();
                n3 = 0;
                while (n3 < n4) {
                    view = tableRow.getView(n3);
                    while (tableRow.isFilled(n5)) {
                        ++n5;
                    }
                    n2 = this.getColumnsOccupied(view);
                    if (n2 > 1) {
                        this.checkMultiColumnCell(n, n5, n2, view);
                        n5 += n2 - 1;
                    }
                    ++n3;
                    ++n5;
                }
            }
        }
    }

    void checkSingleColumnCell(int n, int n2, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n2];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max((int)view.getMaximumSpan(n), sizeRequirements.maximum);
    }

    void checkMultiColumnCell(int n, int n2, int n3, View view) {
        int n4;
        Object[] objectArray;
        SizeRequirements[] sizeRequirementsArray;
        int n5;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (n5 = 0; n5 < n3; ++n5) {
            sizeRequirementsArray = this.columnRequirements[n2 + n5];
            l += (long)sizeRequirementsArray.minimum;
            l2 += (long)sizeRequirementsArray.preferred;
            l3 += (long)sizeRequirementsArray.maximum;
        }
        n5 = (int)view.getMinimumSpan(n);
        if ((long)n5 > l) {
            Object object;
            sizeRequirementsArray = new SizeRequirements[n3];
            for (int i = 0; i < n3; ++i) {
                sizeRequirementsArray[i] = this.columnRequirements[n2 + i];
                object = sizeRequirementsArray[i];
                object.maximum = Math.max(object.maximum, (int)view.getMaximumSpan(n));
            }
            objectArray = new int[n3];
            object = new int[n3];
            SizeRequirements.calculateTiledPositions(n5, null, sizeRequirementsArray, object, objectArray);
            for (int i = 0; i < n3; ++i) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                sizeRequirements.minimum = Math.max(objectArray[i], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
            }
        }
        if ((long)(n4 = (int)view.getPreferredSpan(n)) > l2) {
            objectArray = new SizeRequirements[n3];
            for (int i = 0; i < n3; ++i) {
                objectArray[i] = (int)this.columnRequirements[n2 + i];
            }
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            SizeRequirements.calculateTiledPositions(n4, null, (SizeRequirements[])objectArray, nArray2, nArray);
            for (int i = 0; i < n3; ++i) {
                int n6 = objectArray[i];
                n6.preferred = Math.max(nArray[i], n6.preferred);
                n6.maximum = Math.max(n6.preferred, n6.maximum);
            }
        }
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n3 = view.getStartOffset();
            int n4 = view.getEndOffset();
            if (n < n3 || n >= n4) continue;
            if (rectangle != null) {
                this.childAllocation(i, rectangle);
            }
            return view;
        }
        if (n == this.getEndOffset()) {
            View view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    static interface GridCell {
        public void setGridLocation(int var1, int var2);

        public int getGridRow();

        public int getGridColumn();

        public int getColumnCount();

        public int getRowCount();
    }

    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;

        public TableCell(Element element) {
            super(element, 1);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.col = n2;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getGridColumn() {
            return this.col;
        }
    }

    public class TableRow
    extends BoxView {
        BitSet fillColumns;
        int row;

        public TableRow(Element element) {
            super(element, 0);
            this.fillColumns = new BitSet();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n) {
            this.fillColumns.set(n);
        }

        boolean isFilled(int n) {
            return this.fillColumns.get(n);
        }

        int getRow() {
            return this.row;
        }

        void setRow(int n) {
            this.row = n;
        }

        int getColumnCount() {
            int n = 0;
            int n2 = this.fillColumns.size();
            for (int i = 0; i < n2; ++i) {
                if (!this.fillColumns.get(i)) continue;
                ++n;
            }
            return this.getViewCount() + n;
        }

        public void replace(int n, int n2, View[] viewArray) {
            super.replace(n, n2, viewArray);
            TableView.this.invalidateGrid();
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                nArray2[n5] = TableView.this.columnSpans[n3];
                nArray[n5] = TableView.this.columnOffsets[n3];
                if (n6 > 1) {
                    int n7 = TableView.this.columnSpans.length;
                    for (int i = 1; i < n6; ++i) {
                        if (n3 + i >= n7) continue;
                        int n8 = n5;
                        nArray2[n8] = nArray2[n8] + TableView.this.columnSpans[n3 + i];
                    }
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                int n7 = TableView.this.getRowsOccupied(view);
                if (n7 > 1) {
                    for (int i = 1; i < n7; ++i) {
                        int n8 = this.getRow() + i;
                        if (n8 >= TableView.this.getViewCount()) continue;
                        int n9 = TableView.this.getSpan(1, this.getRow() + i);
                        int n10 = n5;
                        nArray2[n10] = nArray2[n10] + n9;
                    }
                }
                if (n6 > 1) {
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        public int getResizeWeight(int n) {
            return 1;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                int n3 = view.getStartOffset();
                int n4 = view.getEndOffset();
                if (n < n3 || n >= n4) continue;
                if (rectangle != null) {
                    this.childAllocation(i, rectangle);
                }
                return view;
            }
            if (n == this.getEndOffset()) {
                View view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }
    }
}

