/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public final class SwingPropertyChangeSupport
extends PropertyChangeSupport {
    private transient EventListenerList listeners;
    private Hashtable children;
    private Object source;
    static final long serialVersionUID = 7162625831330845068L;

    public SwingPropertyChangeSupport(Object object) {
        super(object);
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        if (this.listeners != null) {
            arrayList.addAll(Arrays.asList(this.listeners.getListeners(PropertyChangeListener.class)));
        }
        if (this.children != null) {
            Iterator iterator = this.children.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SwingPropertyChangeSupport swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
                PropertyChangeListener[] propertyChangeListenerArray = swingPropertyChangeSupport.getPropertyChangeListeners();
                for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                    arrayList.add(new PropertyChangeListenerProxy(string, propertyChangeListenerArray[i]));
                }
            }
        }
        return arrayList.toArray(new PropertyChangeListener[arrayList.size()]);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) == null) {
            swingPropertyChangeSupport = new SwingPropertyChangeSupport(this.source);
            this.children.put(string, swingPropertyChangeSupport);
        }
        swingPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
        if (swingPropertyChangeSupport == null) {
            return;
        }
        swingPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>();
        if (this.children != null && (swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) != null) {
            arrayList.addAll(Arrays.asList(swingPropertyChangeSupport.getPropertyChangeListeners()));
        }
        return arrayList.toArray(new PropertyChangeListener[0]);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray;
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = null;
        if (this.children != null) {
            objectArray = this;
            // MONITORENTER : this
            if (this.children != null && string != null) {
                swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
            }
            // MONITOREXIT : objectArray
        }
        if (this.listeners != null) {
            objectArray = this.listeners.getListenerList();
            for (int i = 0; i <= objectArray.length - 2; i += 2) {
                if (objectArray[i] != (class$java$beans$PropertyChangeListener == null ? SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
            }
        }
        if (swingPropertyChangeSupport == null) return;
        swingPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    public synchronized boolean hasListeners(String string) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.listeners != null && this.listeners.getListenerCount(PropertyChangeListener.class) > 0) {
            return true;
        }
        if (this.children != null && (swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) != null) {
            return swingPropertyChangeSupport.hasListeners(string);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.listeners != null) {
            Object[] objectArray = this.listeners.getListenerList();
            for (int i = 0; i <= objectArray.length - 2; i += 2) {
                if (objectArray[i] != (class$java$beans$PropertyChangeListener == null ? SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener) || !((PropertyChangeListener)objectArray[i + 1] instanceof Serializable)) continue;
                objectOutputStream.writeObject((PropertyChangeListener)objectArray[i + 1]);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

