/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final String uiClassID = "DesktopPaneUI";
    transient DesktopManager desktopManager;
    private transient JInternalFrame selectedFrame = null;
    public static int LIVE_DRAG_MODE = 0;
    public static int OUTLINE_DRAG_MODE = 1;
    private int dragMode = LIVE_DRAG_MODE;

    public JDesktopPane() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                JInternalFrame[] jInternalFrameArray = JDesktopPane.this.getAllFrames();
                Component component = null;
                for (int i = 0; i < jInternalFrameArray.length && (component = jInternalFrameArray[i].getFocusTraversalPolicy().getDefaultComponent(jInternalFrameArray[i])) == null; ++i) {
                }
                return component;
            }
        });
        this.updateUI();
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI desktopPaneUI) {
        super.setUI(desktopPaneUI);
    }

    public void setDragMode(int n) {
        this.firePropertyChange("dragMode", this.dragMode, n);
        this.dragMode = n;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public JInternalFrame[] getAllFrames() {
        Vector<Component> vector = new Vector<Component>(10);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(i);
            if (component instanceof JInternalFrame) {
                vector.addElement(component);
                continue;
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) == null) continue;
            vector.addElement(jInternalFrame);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        this.selectedFrame = jInternalFrame;
    }

    public JInternalFrame[] getAllFramesInLayer(int n) {
        Vector<Component> vector = new Vector<Component>(10);
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(i);
            if (component instanceof JInternalFrame) {
                if (((JInternalFrame)component).getLayer() != n) continue;
                vector.addElement(component);
                continue;
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) == null || jInternalFrame.getLayer() != n) continue;
            vector.addElement(jInternalFrame);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isOpaque() {
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.desktopManager != null ? this.desktopManager.toString() : "";
        return super.paramString() + ",desktopManager=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJDesktopPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }
}

