/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{String.class};
    private static final boolean DEBUG = false;

    private AudioSystem() {
    }

    public static Mixer.Info[] getMixerInfo() {
        int n;
        Vector vector = AudioSystem.getMixerProviders();
        Vector<Mixer.Info> vector2 = new Vector<Mixer.Info>();
        for (n = vector.size() - 1; n >= 0; --n) {
            Mixer.Info[] infoArray = ((MixerProvider)vector.elementAt(n)).getMixerInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                vector2.addElement(infoArray[i]);
            }
        }
        Mixer.Info[] infoArray = new Mixer.Info[vector2.size()];
        for (n = 0; n < infoArray.length; ++n) {
            infoArray[n] = (Mixer.Info)vector2.elementAt(n);
        }
        return infoArray;
    }

    public static Mixer getMixer(Mixer.Info info) {
        int n;
        Object var1_1 = null;
        Vector vector = AudioSystem.getMixerProviders();
        for (n = vector.size() - 1; n >= 0; --n) {
            try {
                return ((MixerProvider)vector.elementAt(n)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (info == null) {
            for (n = vector.size() - 1; n >= 0; --n) {
                try {
                    MixerProvider mixerProvider = (MixerProvider)vector.elementAt(n);
                    Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
                    for (int i = 0; i < infoArray.length; ++i) {
                        try {
                            return mixerProvider.getMixer(infoArray[i]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            for (n = 0; n < infoArray2.length; ++n) {
                vector.addElement(infoArray2[n]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n = 0; n < infoArray3.length; ++n) {
            infoArray3[n] = (Line.Info)vector.elementAt(n);
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            for (n = 0; n < infoArray2.length; ++n) {
                vector.addElement(infoArray2[n]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n = 0; n < infoArray3.length; ++n) {
            infoArray3[n] = (Line.Info)vector.elementAt(n);
        }
        return infoArray3;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer;
            if (infoArray[i] == null || !(mixer = AudioSystem.getMixer(infoArray[i])).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        LineUnavailableException lineUnavailableException = null;
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (!mixer.isLineSupported(info)) continue;
            try {
                return mixer.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException2) {
                lineUnavailableException = lineUnavailableException2;
            }
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            if (!formatConversionProviderArray[i].isSourceEncodingSupported(encoding)) continue;
            encodingArray = formatConversionProviderArray[i].getTargetEncodings();
            n += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n];
        for (int i = 0; i < vector.size(); ++i) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(i);
            for (int j = 0; j < encodingArray.length; ++j) {
                encodingArray2[n2++] = encodingArray[j];
            }
        }
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            encodingArray = formatConversionProviderArray[i].getTargetEncodings(audioFormat);
            n += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n];
        for (int i = 0; i < vector.size(); ++i) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(i);
            for (int j = 0; j < encodingArray.length; ++j) {
                encodingArray2[n2++] = encodingArray[j];
            }
        }
        return encodingArray2;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            if (!formatConversionProviderArray[i].isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i = formatConversionProviderArray.length - 1; i >= 0; --i) {
            if (!formatConversionProviderArray[i].isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProviderArray[i].getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> vector = new Vector<AudioFormat[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat[] audioFormatArray = null;
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            audioFormatArray = formatConversionProviderArray[i].getTargetFormats(encoding, audioFormat);
            n += audioFormatArray.length;
            vector.addElement(audioFormatArray);
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n];
        for (int i = 0; i < vector.size(); ++i) {
            audioFormatArray = (AudioFormat[])vector.elementAt(i);
            for (int j = 0; j < audioFormatArray.length; ++j) {
                audioFormatArray2[n2++] = audioFormatArray[j];
            }
        }
        return audioFormatArray2;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            if (!formatConversionProviderArray[i].isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i = formatConversionProviderArray.length - 1; i >= 0; --i) {
            if (!formatConversionProviderArray[i].isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProviderArray[i].getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioFileFormat = audioFileReaderArray[i].getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioFileFormat = audioFileReaderArray[i].getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioFileFormat = audioFileReaderArray[i].getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioInputStream = audioFileReaderArray[i].getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioInputStream = audioFileReaderArray[i].getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = audioFileReaderArray.length - 1; i >= 0; --i) {
            try {
                audioInputStream = audioFileReaderArray[i].getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioInputStream;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        int n;
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < audioFileWriterArray.length; ++n) {
            typeArrayArray[n] = audioFileWriterArray[n].getAudioFileTypes();
            n2 += typeArrayArray[n].length;
        }
        typeArray = new AudioFileFormat.Type[n2];
        for (n = 0; n < audioFileWriterArray.length; ++n) {
            for (int i = 0; i < typeArrayArray[n].length; ++i) {
                typeArray[n3] = typeArrayArray[n][i];
                ++n3;
            }
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl = false;
        for (int i = 0; i < audioFileWriterArray.length; ++i) {
            bl = audioFileWriterArray[i].isFileTypeSupported(type);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        int n;
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < audioFileWriterArray.length; ++n) {
            typeArrayArray[n] = audioFileWriterArray[n].getAudioFileTypes(audioInputStream);
            n2 += typeArrayArray[n].length;
        }
        typeArray = new AudioFileFormat.Type[n2];
        for (n = 0; n < audioFileWriterArray.length; ++n) {
            for (int i = 0; i < typeArrayArray[n].length; ++i) {
                typeArray[n3] = typeArrayArray[n][i];
                ++n3;
            }
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl = false;
        for (int i = 0; i < audioFileWriterArray.length; ++i) {
            bl = audioFileWriterArray[i].isFileTypeSupported(type, audioInputStream);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        for (int i = audioFileWriterArray.length - 1; i >= 0; --i) {
            try {
                n = audioFileWriterArray[i].write(audioInputStream, type, outputStream);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        for (int i = audioFileWriterArray.length - 1; i >= 0; --i) {
            try {
                n = audioFileWriterArray[i].write(audioInputStream, type, file);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    private static Vector getMixerProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.MixerProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.MixerProvider");
        }
        return vector;
    }

    private static FormatConversionProvider[] getFormatConversionProviders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.FormatConversionProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.FormatConversionProvider");
        }
        FormatConversionProvider[] formatConversionProviderArray = new FormatConversionProvider[vector.size()];
        for (int i = 0; i < formatConversionProviderArray.length; ++i) {
            formatConversionProviderArray[i] = (FormatConversionProvider)vector.elementAt(i);
        }
        return formatConversionProviderArray;
    }

    private static AudioFileReader[] getAudioFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileReader");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileReader");
        }
        AudioFileReader[] audioFileReaderArray = new AudioFileReader[vector.size()];
        for (int i = 0; i < audioFileReaderArray.length; ++i) {
            audioFileReaderArray[i] = (AudioFileReader)vector.elementAt(i);
        }
        return audioFileReaderArray;
    }

    private static AudioFileWriter[] getAudioFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileWriter");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileWriter");
        }
        AudioFileWriter[] audioFileWriterArray = new AudioFileWriter[vector.size()];
        for (int i = 0; i < audioFileWriterArray.length; ++i) {
            audioFileWriterArray[i] = (AudioFileWriter)vector.elementAt(i);
        }
        return audioFileWriterArray;
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }
}

