/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

public class ParameterBlock
implements Cloneable,
Serializable {
    protected Vector sources = new Vector();
    protected Vector parameters = new Vector();

    public ParameterBlock() {
    }

    public ParameterBlock(Vector vector) {
        this.setSources(vector);
    }

    public ParameterBlock(Vector vector, Vector vector2) {
        this.setSources(vector);
        this.setParameters(vector2);
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object clone() {
        ParameterBlock parameterBlock;
        try {
            parameterBlock = (ParameterBlock)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
        if (this.sources != null) {
            parameterBlock.setSources((Vector)this.sources.clone());
        }
        if (this.parameters != null) {
            parameterBlock.setParameters((Vector)this.parameters.clone());
        }
        return parameterBlock;
    }

    public ParameterBlock addSource(Object object) {
        this.sources.addElement(object);
        return this;
    }

    public Object getSource(int n) {
        return this.sources.elementAt(n);
    }

    public ParameterBlock setSource(Object object, int n) {
        int n2;
        int n3 = this.sources.size();
        if (n3 < (n2 = n + 1)) {
            this.sources.setSize(n2);
        }
        this.sources.setElementAt(object, n);
        return this;
    }

    public RenderedImage getRenderedSource(int n) {
        return (RenderedImage)this.sources.elementAt(n);
    }

    public RenderableImage getRenderableSource(int n) {
        return (RenderableImage)this.sources.elementAt(n);
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public Vector getSources() {
        return this.sources;
    }

    public void setSources(Vector vector) {
        this.sources = vector;
    }

    public void removeSources() {
        this.sources = new Vector();
    }

    public int getNumParameters() {
        return this.parameters.size();
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector vector) {
        this.parameters = vector;
    }

    public void removeParameters() {
        this.parameters = new Vector();
    }

    public ParameterBlock add(Object object) {
        this.parameters.addElement(object);
        return this;
    }

    public ParameterBlock add(byte by) {
        return this.add(new Byte(by));
    }

    public ParameterBlock add(char c) {
        return this.add(new Character(c));
    }

    public ParameterBlock add(short s) {
        return this.add(new Short(s));
    }

    public ParameterBlock add(int n) {
        return this.add(new Integer(n));
    }

    public ParameterBlock add(long l) {
        return this.add(new Long(l));
    }

    public ParameterBlock add(float f) {
        return this.add(new Float(f));
    }

    public ParameterBlock add(double d) {
        return this.add(new Double(d));
    }

    public ParameterBlock set(Object object, int n) {
        int n2;
        int n3 = this.parameters.size();
        if (n3 < (n2 = n + 1)) {
            this.parameters.setSize(n2);
        }
        this.parameters.setElementAt(object, n);
        return this;
    }

    public ParameterBlock set(byte by, int n) {
        return this.set(new Byte(by), n);
    }

    public ParameterBlock set(char c, int n) {
        return this.set(new Character(c), n);
    }

    public ParameterBlock set(short s, int n) {
        return this.set(new Short(s), n);
    }

    public ParameterBlock set(int n, int n2) {
        return this.set(new Integer(n), n2);
    }

    public ParameterBlock set(long l, int n) {
        return this.set(new Long(l), n);
    }

    public ParameterBlock set(float f, int n) {
        return this.set(new Float(f), n);
    }

    public ParameterBlock set(double d, int n) {
        return this.set(new Double(d), n);
    }

    public Object getObjectParameter(int n) {
        return this.parameters.elementAt(n);
    }

    public byte getByteParameter(int n) {
        return (Byte)this.parameters.elementAt(n);
    }

    public char getCharParameter(int n) {
        return ((Character)this.parameters.elementAt(n)).charValue();
    }

    public short getShortParameter(int n) {
        return (Short)this.parameters.elementAt(n);
    }

    public int getIntParameter(int n) {
        return (Integer)this.parameters.elementAt(n);
    }

    public long getLongParameter(int n) {
        return (Long)this.parameters.elementAt(n);
    }

    public float getFloatParameter(int n) {
        return ((Float)this.parameters.elementAt(n)).floatValue();
    }

    public double getDoubleParameter(int n) {
        return (Double)this.parameters.elementAt(n);
    }

    public Class[] getParamClasses() {
        int n = this.getNumParameters();
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Object object = this.getObjectParameter(i);
            classArray[i] = object instanceof Byte ? Byte.TYPE : (object instanceof Character ? Character.TYPE : (object instanceof Short ? Short.TYPE : (object instanceof Integer ? Integer.TYPE : (object instanceof Long ? Long.TYPE : (object instanceof Float ? Float.TYPE : (object instanceof Double ? Double.TYPE : object.getClass()))))));
        }
        return classArray;
    }
}

