/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class MotifGraphicsUtils
implements SwingConstants {
    private static final String MAX_ACC_WIDTH = "maxAccWidth";

    static void drawPoint(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2, n, n2);
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.translate(-n, -n2);
        graphics.setColor(color3);
    }

    public static void drawStringInRect(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (graphics.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        if (n5 == 0) {
            int n7 = fontMetrics.stringWidth(string);
            if (n7 > n3) {
                n7 = n3;
            }
            n6 = n + (n3 - n7) / 2;
        } else if (n5 == 4) {
            int n8 = fontMetrics.stringWidth(string);
            if (n8 > n3) {
                n8 = n3;
            }
            n6 = n + n3 - n8;
        } else {
            n6 = n;
        }
        int n9 = (n4 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (n9 < 0) {
            n9 = 0;
        }
        int n10 = n2 + n4 - n9 - fontMetrics.getDescent();
        graphics.drawString(string, n6, n10);
    }

    public static void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Dimension dimension = jMenuItem.getSize();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(UIManager.getFont("MenuItem.acceleratorFont"));
        if (jComponent.isOpaque()) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
            } else {
                graphics.setColor(jComponent.getBackground());
            }
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string = KeyEvent.getKeyModifiersText(n2);
                string = string + "+";
            }
            string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string2 = MotifGraphicsUtils.layoutMenuItem(jComponent, fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6, jMenuItem.getText() == null ? 0 : n, n);
        Color color3 = graphics.getColor();
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            icon.paintIcon(jComponent, graphics, rectangle5.x, rectangle5.y);
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            if (!buttonModel.isEnabled()) {
                object = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                object = jMenuItem.getPressedIcon();
                if (object == null) {
                    object = jMenuItem.getIcon();
                }
            } else {
                object = jMenuItem.getIcon();
            }
            if (object != null) {
                object.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            }
        }
        if (string2 != null && !string2.equals("")) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, rectangle3);
            } else {
                int n3 = jMenuItem.getDisplayedMnemonicIndex();
                if (!buttonModel.isEnabled()) {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string2, n3, rectangle3.x, rectangle3.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string2, n3, rectangle3.x - 1, rectangle3.y + fontMetrics2.getAscent() - 1);
                } else {
                    if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(color2);
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                    BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string2, n3, rectangle3.x, rectangle3.y + fontMetrics.getAscent());
                }
            }
        }
        if (string != null && !string.equals("")) {
            int n4 = 0;
            Container container = jMenuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n5 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n6 = n5 != null ? n5 : rectangle4.width;
                n4 = n6 - rectangle4.width;
            }
            graphics.setFont(UIManager.getFont("MenuItem.acceleratorFont"));
            if (!buttonModel.isEnabled()) {
                graphics.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawString(graphics, string, 0, rectangle4.x - n4, rectangle4.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawString(graphics, string, 0, rectangle4.x - n4 - 1, rectangle4.y + fontMetrics.getAscent() - 1);
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, rectangle4.x - n4, rectangle4.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!(jMenuItem.getParent() instanceof JMenuBar)) {
                icon2.paintIcon(jComponent, graphics, rectangle6.x, rectangle6.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private static String layoutMenuItem(JComponent jComponent, FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (icon2 != null) {
            rectangle5.width = icon2.getIconWidth();
            rectangle5.height = icon2.getIconHeight();
        } else {
            rectangle5.height = 0;
            rectangle5.width = 0;
        }
        if (icon3 != null) {
            rectangle6.width = icon3.getIconWidth();
            rectangle6.height = icon3.getIconHeight();
        } else {
            rectangle6.height = 0;
            rectangle6.width = 0;
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (MotifGraphicsUtils.isLeftToRight(jComponent)) {
            rectangle3.x += rectangle5.width + n6;
            rectangle2.x += rectangle5.width + n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            rectangle5.x = rectangle.x;
            rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
        } else {
            rectangle3.x -= rectangle5.width + n6;
            rectangle2.x -= rectangle5.width + n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            rectangle5.x = rectangle.x + rectangle.width - rectangle5.width;
            rectangle6.x = rectangle.x + n6;
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
        rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        return string;
    }

    private static void drawMenuBezel(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color.brighter().brighter());
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 1);
        graphics.setColor(color.darker().darker());
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }
}

