/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

class DefaultSynthStyle
extends SynthStyle
implements Cloneable {
    private boolean opaque;
    private Insets insets;
    StateInfo[] states;
    Map data;

    protected DefaultSynthStyle() {
    }

    public DefaultSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        this.opaque = defaultSynthStyle.opaque;
        if (defaultSynthStyle.insets != null) {
            this.insets = new Insets(defaultSynthStyle.insets.top, defaultSynthStyle.insets.left, defaultSynthStyle.insets.bottom, defaultSynthStyle.insets.right);
        }
        if (defaultSynthStyle.states != null) {
            this.states = new StateInfo[defaultSynthStyle.states.length];
            for (int i = defaultSynthStyle.states.length - 1; i >= 0; --i) {
                this.states[i] = (StateInfo)defaultSynthStyle.states[i].clone();
            }
        }
        if (defaultSynthStyle.data != null) {
            this.data = new HashMap();
            this.data.putAll(defaultSynthStyle.data);
        }
    }

    public DefaultSynthStyle(Insets insets, boolean bl, StateInfo[] stateInfoArray, Map map) {
        this.insets = insets;
        this.opaque = bl;
        this.states = stateInfoArray;
        this.data = map;
    }

    protected Color _getColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        StateInfo stateInfo = this.getStateInfo(n);
        if (stateInfo != null) {
            return stateInfo.getColor(colorType);
        }
        return null;
    }

    protected Font _getFont(JComponent jComponent, Region region, int n) {
        StateInfo stateInfo = this.getStateInfo(n);
        if (stateInfo != null) {
            return stateInfo.getFont();
        }
        return null;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.insets != null) {
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        return insets;
    }

    public SynthPainter getBorderPainter(SynthContext synthContext) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null) {
            return stateInfo.getBorderPainter();
        }
        return null;
    }

    public SynthPainter getBackgroundPainter(SynthContext synthContext) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null) {
            return stateInfo.getBackgroundPainter();
        }
        return null;
    }

    public boolean isOpaque(SynthContext synthContext) {
        return this.opaque;
    }

    public Object get(SynthContext synthContext, Object object) {
        if (this.data != null) {
            return this.data.get(object);
        }
        return null;
    }

    public Object clone() {
        DefaultSynthStyle defaultSynthStyle;
        try {
            defaultSynthStyle = (DefaultSynthStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.states != null) {
            defaultSynthStyle.states = new StateInfo[this.states.length];
            for (int i = this.states.length - 1; i >= 0; --i) {
                defaultSynthStyle.states[i] = (StateInfo)this.states[i].clone();
            }
        }
        if (this.data != null) {
            defaultSynthStyle.data = new HashMap();
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (this.insets != null) {
            defaultSynthStyle.insets = this.insets;
        }
        defaultSynthStyle.opaque = this.opaque;
        if (this.states != null) {
            if (defaultSynthStyle.states == null) {
                defaultSynthStyle.states = new StateInfo[this.states.length];
                for (int i = this.states.length - 1; i >= 0; --i) {
                    if (this.states[i] == null) continue;
                    defaultSynthStyle.states[i] = (StateInfo)this.states[i].clone();
                }
            } else {
                int n;
                int n2;
                int n3;
                int n4 = 0;
                for (int i = this.states.length - 1; i >= 0; --i) {
                    n3 = this.states[i].getComponentState();
                    n2 = 0;
                    for (n = defaultSynthStyle.states.length - 1; n >= 0; --n) {
                        if (n3 != defaultSynthStyle.states[n].getComponentState()) continue;
                        this.states[i].addTo(defaultSynthStyle.states[n]);
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) continue;
                    ++n4;
                }
                if (n4 != 0) {
                    StateInfo[] stateInfoArray = new StateInfo[n4 + defaultSynthStyle.states.length];
                    n3 = defaultSynthStyle.states.length;
                    System.arraycopy(defaultSynthStyle.states, 0, stateInfoArray, 0, defaultSynthStyle.states.length);
                    for (n2 = this.states.length - 1; n2 >= 0; --n2) {
                        n = this.states[n2].getComponentState();
                        boolean bl = false;
                        for (int i = defaultSynthStyle.states.length - 1; i >= 0; --i) {
                            if (n != defaultSynthStyle.states[i].getComponentState()) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        stateInfoArray[n3++] = (StateInfo)this.states[n2].clone();
                    }
                    defaultSynthStyle.states = stateInfoArray;
                }
            }
        }
        if (this.data != null) {
            if (defaultSynthStyle.data == null) {
                defaultSynthStyle.data = new HashMap();
            }
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    StateInfo getStateInfo(int n) {
        if (this.states != null) {
            int n2 = 0;
            int n3 = -1;
            for (int i = this.states.length - 1; i >= 0; --i) {
                int n4 = this.states[i].getMatchCount(n);
                if (n4 <= n2) continue;
                n3 = i;
                n2 = n4;
            }
            if (n3 != -1) {
                return this.states[n3];
            }
        }
        return null;
    }

    public static class StateInfo {
        private SynthPainter borderPainter;
        private SynthPainter backgroundPainter;
        private Font font;
        Color[] colors;
        private int state;

        public StateInfo(int n, SynthPainter synthPainter, SynthPainter synthPainter2, Font font, Color[] colorArray) {
            this.state = n;
            this.borderPainter = synthPainter;
            this.backgroundPainter = synthPainter2;
            this.font = font;
            this.colors = colorArray;
        }

        public StateInfo(StateInfo stateInfo) {
            this.state = stateInfo.state;
            this.borderPainter = stateInfo.borderPainter;
            this.backgroundPainter = stateInfo.backgroundPainter;
            this.font = stateInfo.font;
            if (stateInfo.colors != null) {
                this.colors = new Color[stateInfo.colors.length];
                System.arraycopy(stateInfo.colors, 0, this.colors, 0, stateInfo.colors.length);
            }
        }

        public SynthPainter getBorderPainter() {
            return this.borderPainter;
        }

        public SynthPainter getBackgroundPainter() {
            return this.backgroundPainter;
        }

        public Font getFont() {
            return this.font;
        }

        protected Color[] getColors() {
            return this.colors;
        }

        public Color getColor(ColorType colorType) {
            int n;
            if (this.colors != null && (n = colorType.getID()) < this.colors.length) {
                return this.colors[n];
            }
            return null;
        }

        public StateInfo addTo(StateInfo stateInfo) {
            stateInfo.borderPainter = this.borderPainter;
            stateInfo.backgroundPainter = this.backgroundPainter;
            if (this.font != null) {
                stateInfo.font = this.font;
            }
            if (this.colors != null) {
                if (stateInfo.colors == null) {
                    stateInfo.colors = new Color[this.colors.length];
                    System.arraycopy(this.colors, 0, stateInfo.colors, 0, this.colors.length);
                } else {
                    if (stateInfo.colors.length < this.colors.length) {
                        Color[] colorArray = stateInfo.colors;
                        stateInfo.colors = new Color[this.colors.length];
                        System.arraycopy(colorArray, 0, stateInfo.colors, 0, colorArray.length);
                    }
                    for (int i = this.colors.length - 1; i >= 0; --i) {
                        if (this.colors[i] == null) continue;
                        stateInfo.colors[i] = this.colors[i];
                    }
                }
            }
            return stateInfo;
        }

        public int getComponentState() {
            return this.state;
        }

        private final int getMatchCount(int n) {
            n &= this.state;
            n -= (0xAAAAAAAA & n) >>> 1;
            n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
            n = n + (n >>> 4) & 0xF0F0F0F;
            n += n >>> 8;
            n += n >>> 16;
            return n & 0xFF;
        }

        public Object clone() {
            return new StateInfo(this);
        }
    }
}

