/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DHTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    DHTMarkerSegment(boolean bl) {
        super(196);
        this.tables.add(new Htable(JPEGHuffmanTable.StdDCLuminance, true, 0));
        if (bl) {
            this.tables.add(new Htable(JPEGHuffmanTable.StdDCChrominance, true, 1));
        }
        this.tables.add(new Htable(JPEGHuffmanTable.StdACLuminance, false, 0));
        if (bl) {
            this.tables.add(new Htable(JPEGHuffmanTable.StdACChrominance, false, 1));
        }
    }

    DHTMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        Htable htable;
        for (int i = this.length; i > 0; i -= 17 + htable.values.length) {
            htable = new Htable(jPEGBuffer);
            this.tables.add(htable);
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    DHTMarkerSegment(JPEGHuffmanTable[] jPEGHuffmanTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray2) {
        super(196);
        int n;
        for (n = 0; n < jPEGHuffmanTableArray.length; ++n) {
            this.tables.add(new Htable(jPEGHuffmanTableArray[n], true, n));
        }
        for (n = 0; n < jPEGHuffmanTableArray2.length; ++n) {
            this.tables.add(new Htable(jPEGHuffmanTableArray2[n], false, n));
        }
    }

    DHTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(196);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n < 1 || n > 4) {
            throw new IIOInvalidTreeException("Invalid DHT node", node);
        }
        for (int i = 0; i < n; ++i) {
            this.tables.add(new Htable(nodeList.item(i)));
        }
    }

    protected Object clone() {
        DHTMarkerSegment dHTMarkerSegment = (DHTMarkerSegment)super.clone();
        dHTMarkerSegment.tables = new ArrayList(this.tables.size());
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            Htable htable = (Htable)iterator.next();
            dHTMarkerSegment.tables.add(htable.clone());
        }
        return dHTMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dht");
        for (int i = 0; i < this.tables.size(); ++i) {
            Htable htable = (Htable)this.tables.get(i);
            iIOMetadataNode.appendChild(htable.getNativeNode());
        }
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("DHT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        for (int i = 0; i < this.tables.size(); ++i) {
            Htable htable = (Htable)this.tables.get(i);
            htable.print();
        }
        System.out.println();
    }

    Htable getHtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Htable(node);
    }

    void addHtable(JPEGHuffmanTable jPEGHuffmanTable, boolean bl, int n) {
        this.tables.add(new Htable(jPEGHuffmanTable, bl, n));
    }

    class Htable
    implements Cloneable {
        int tableClass;
        int tableID;
        private static final int NUM_LENGTHS = 16;
        short[] numCodes = new short[16];
        short[] values;

        Htable(JPEGBuffer jPEGBuffer) {
            int n;
            int n2;
            this.tableClass = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.tableID = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            for (n2 = 0; n2 < 16; ++n2) {
                this.numCodes[n2] = (short)(jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF);
            }
            n2 = 0;
            for (n = 0; n < 16; ++n) {
                n2 += this.numCodes[n];
            }
            this.values = new short[n2];
            for (n = 0; n < n2; ++n) {
                this.values[n] = (short)(jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF);
            }
        }

        Htable(JPEGHuffmanTable jPEGHuffmanTable, boolean bl, int n) {
            this.tableClass = bl ? 0 : 1;
            this.tableID = n;
            this.numCodes = jPEGHuffmanTable.getLengths();
            this.values = jPEGHuffmanTable.getValues();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Htable(Node node) throws IIOInvalidTreeException {
            if (!node.getNodeName().equals("dhtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            if (n != 2) {
                throw new IIOInvalidTreeException("dhtable node must have 2 attributes", node);
            }
            this.tableClass = MarkerSegment.getAttributeValue(node, namedNodeMap, "class", 0, 1, true);
            this.tableID = MarkerSegment.getAttributeValue(node, namedNodeMap, "htableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dhtable node must have user object", node);
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            JPEGHuffmanTable jPEGHuffmanTable = (JPEGHuffmanTable)iIOMetadataNode.getUserObject();
            if (jPEGHuffmanTable == null) {
                throw new IIOInvalidTreeException("dhtable node must have user object", node);
            }
            this.numCodes = jPEGHuffmanTable.getLengths();
            this.values = jPEGHuffmanTable.getValues();
        }

        protected Object clone() {
            Htable htable = null;
            try {
                htable = (Htable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.numCodes != null) {
                htable.numCodes = (short[])this.numCodes.clone();
            }
            if (this.values != null) {
                htable.values = (short[])this.values.clone();
            }
            return htable;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dhtable");
            iIOMetadataNode.setAttribute("class", Integer.toString(this.tableClass));
            iIOMetadataNode.setAttribute("htableId", Integer.toString(this.tableID));
            iIOMetadataNode.setUserObject(new JPEGHuffmanTable(this.numCodes, this.values));
            return iIOMetadataNode;
        }

        void print() {
            System.out.println("Huffman Table");
            System.out.println("table class: " + (this.tableClass == 0 ? "DC" : "AC"));
            System.out.println("table id: " + Integer.toString(this.tableID));
            new JPEGHuffmanTable(this.numCodes, this.values).toString();
        }
    }
}

