/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.service;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.component.binder.ResourceBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.config.ResourceLocator;
import com.ibm.ws.runtime.service.CacheResourceMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.server.services.NameSpaceBindStatus;
import com.ibm.ws.server.services.NameSpaceBindStatusHelper;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.CORBA.Object;

public class CacheResourceMgrImpl
extends ContainerImpl
implements CacheResourceMgr {
    private static final TraceComponent tc = Tr.register((Class)CacheResourceMgrImpl.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    private boolean initialized = false;
    private ResourceBinder[] resourceBinders;
    private Context localContext;
    private ExtClassLoader publicClassLoader;
    private boolean throwWarnings = true;
    private ResourceLocator[] locators;
    private long lastAccessTime = 0L;
    private NameSpaceBindStatus nsbs_obj = null;
    private boolean doBind = true;
    private boolean doUnBind = false;
    static final int NUM_OF_RESOURCE_DOC_SCOPES = 4;

    protected void startBinders(Map map) {
        if (this.resourceBinders != null) {
            for (int i = 0; i < this.resourceBinders.length; ++i) {
                ResourceBinder resourceBinder = this.resourceBinders[i];
                resourceBinder.setCache(map);
                try {
                    if (!(resourceBinder instanceof ComponentImpl)) continue;
                    ((ComponentImpl)resourceBinder).start();
                    continue;
                }
                catch (RuntimeWarning runtimeWarning) {
                    FFDCFilter.processException(runtimeWarning, "com.ibm.ws.runtime.component.CacheResourceMgrImpl", "220");
                    continue;
                }
                catch (RuntimeError runtimeError) {
                    FFDCFilter.processException(runtimeError, "com.ibm.ws.runtime.component.CacheResourceMgrImpl", "222");
                }
            }
        }
    }

    protected void stopBinders() {
        for (int i = 0; i < this.resourceBinders.length; ++i) {
            ResourceBinder resourceBinder = this.resourceBinders[i];
            if (resourceBinder instanceof ComponentImpl) {
                ((ComponentImpl)resourceBinder).stop();
            }
            resourceBinder.setCache(null);
        }
    }

    public void bind(J2EEResourceFactory j2EEResourceFactory, ResourceBinder resourceBinder, boolean bl) throws NamingException, ResourceBindingException {
        java.lang.Object object = resourceBinder.getBindingObject(j2EEResourceFactory);
        String string = j2EEResourceFactory.getJndiName();
        if (string == null || string.trim().length() == 0) {
            Tr.warning((TraceComponent)tc, (String)"WSVR0048W", (java.lang.Object)j2EEResourceFactory.getName());
            return;
        }
        boolean bl2 = true;
        if (bl2) {
            Tr.info((TraceComponent)tc, (String)"WSVR0049I", (java.lang.Object)new java.lang.Object[]{j2EEResourceFactory.getName(), string});
            this.bind(this.getLocalContext(), object, string);
        }
    }

    protected void bind(Context context, java.lang.Object object, String string) throws NamingException {
        if (this.doBind) {
            JndiHelper.recursiveRebind((Context)context, (String)string, (java.lang.Object)object);
        }
    }

    private ResourceBinder getResourceBinder(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        for (int i = 0; i < this.resourceBinders.length; ++i) {
            if (!this.resourceBinders[i].isUsedFor(j2EEResourceFactory)) continue;
            return this.resourceBinders[i];
        }
        return null;
    }

    private Context getLocalContext() throws NamingException {
        if (this.localContext == null) {
            this.localContext = new InitialContext();
        }
        return this.localContext;
    }

    public void initialize(java.lang.Object object) throws ConfigurationWarning, ConfigurationError {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService.getServerType();
        if (!string.equals("PROXY_SERVER") && !string.equals("ONDEMAND_ROUTER")) {
            this.initialized = false;
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializing the Cache Resource Manager");
        }
        this.initialized = true;
        this.resourceBinders = new ResourceBinder[0];
        this.getOuterBCS().addService(CacheResourceMgr.class, (BeanContextServiceProvider)((java.lang.Object)this));
        try {
            StreamHandlerUtils.createStreamHandler();
        }
        catch (Throwable throwable) {
            throw new ConfigurationError(throwable.toString());
        }
        Server server = (Server)this.getService(Server.class);
        this.publicClassLoader = (ExtClassLoader)server.getRuntimeClassLoader();
        this.releaseService(server);
    }

    public void destroy() {
        if (this.resourceBinders != null) {
            for (int i = 0; i < this.resourceBinders.length; ++i) {
                ResourceBinder resourceBinder = this.resourceBinders[i];
                if (!(resourceBinder instanceof ComponentImpl)) continue;
                ((ComponentImpl)resourceBinder).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws RuntimeError, RuntimeWarning {
        block24: {
            block25: {
                block23: {
                    block27: {
                        if (!this.initialized) {
                            return;
                        }
                        try {
                            JndiHelper.recursiveBind((Context)this.getLocalContext(), (String)"services:websphere/Resources/CacheResourceManager", (java.lang.Object)this);
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException(namingException, "com.ibm.ws.runtime.component.CacheResourceMgrImpl", "336");
                        }
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        String string = adminService.getProcessType();
                        if ("DeploymentManager".equals(string) || "NodeAgent".equals(string)) {
                            this.throwWarnings = true;
                        }
                        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) break block27;
                        ORB oRB = null;
                        if (this.nsbs_obj == null) {
                            try {
                                com.ibm.CORBA.iiop.ORB oRB2 = null;
                                oRB = (ORB)this.getService(ORB.class);
                                if (oRB != null && (oRB2 = oRB.getORB()) != null) {
                                    String string2 = "WSNameSpaceBindStatus";
                                    this.nsbs_obj = NameSpaceBindStatusHelper.narrow((Object)oRB2.resolve_initial_references(string2));
                                }
                            }
                            catch (Throwable throwable) {
                                this.releaseService(oRB);
                                break block23;
                                catch (Throwable throwable2) {
                                    this.releaseService(oRB);
                                    throw throwable2;
                                }
                            }
                            this.releaseService(oRB);
                        }
                        break block23;
                    }
                    this.nsbs_obj = null;
                }
                if (this.nsbs_obj != null) {
                    boolean bl = false;
                    boolean bl2 = this.nsbs_obj.resourceBindComplete();
                    if (!bl2) {
                        bl = this.nsbs_obj.resourceBindInProgress();
                    }
                    if (bl || bl2) {
                        this.doBind = false;
                    } else {
                        this.nsbs_obj.resourceBindInProgress(true);
                    }
                }
                RuntimeWarning runtimeWarning = null;
                RuntimeError runtimeError = null;
                try {
                    try {
                        this.loadResources(false);
                    }
                    catch (RuntimeWarning runtimeWarning2) {
                        runtimeWarning = runtimeWarning2;
                        throw runtimeWarning;
                    }
                    catch (RuntimeError runtimeError2) {
                        runtimeError = runtimeError2;
                        throw runtimeError;
                    }
                    java.lang.Object var8_15 = null;
                    if (!this.doBind || this.nsbs_obj == null) break block24;
                    if (runtimeWarning != null || runtimeError != null) break block25;
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_16 = null;
                    if (this.doBind && this.nsbs_obj != null) {
                        if (runtimeWarning == null && runtimeError == null) {
                            this.nsbs_obj.resourceBindComplete(true);
                        } else {
                            this.nsbs_obj.resourceBindInProgress(false);
                        }
                    }
                    this.doBind = true;
                    throw throwable;
                }
                this.nsbs_obj.resourceBindComplete(true);
                break block24;
            }
            this.nsbs_obj.resourceBindInProgress(false);
        }
        this.doBind = true;
    }

    public void reload() throws RuntimeError, RuntimeWarning {
        this.loadResources(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResources(boolean bl) throws RuntimeError, RuntimeWarning {
        ResourceLocator[] resourceLocatorArray = this.getResourceLocators();
        if (resourceLocatorArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No resource locators !!");
            }
            return;
        }
        Repository repository = (Repository)this.getService(Repository.class);
        ConfigRoot configRoot = repository.getConfigRoot();
        boolean bl2 = false;
        boolean[] blArray = new boolean[4 * resourceLocatorArray.length];
        Resource[] resourceArray = this;
        synchronized (this) {
            long l = this.lastAccessTime;
            this.lastAccessTime = System.currentTimeMillis();
            int n = resourceLocatorArray.length;
            for (int i = 0; i < n; ++i) {
                blArray[i] = bl ? resourceLocatorArray[i].isResourceUpdated(l, configRoot, 0) : true;
                bl2 |= blArray[i];
                blArray[n + i] = bl ? resourceLocatorArray[i].isResourceUpdated(l, configRoot, 3) : true;
                bl2 |= blArray[n + i];
                blArray[n * 2 + i] = bl ? resourceLocatorArray[i].isResourceUpdated(l, configRoot, 2) : true;
                bl2 |= blArray[n * 2 + i];
                blArray[n * 3 + i] = bl ? resourceLocatorArray[i].isResourceUpdated(l, configRoot, 4) : true;
                bl2 |= blArray[n * 3 + i];
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Nothing to reload");
                }
                return;
            }
            resourceArray = new Resource[4 * resourceLocatorArray.length];
            int n2 = resourceLocatorArray.length;
            for (int i = 0; i < n2; ++i) {
                resourceArray[i] = resourceLocatorArray[i].getResource(configRoot, 0);
                if (bl && blArray[i] && resourceArray[i] != null) {
                    resourceArray[i].unload();
                    resourceArray[i] = resourceLocatorArray[i].getResource(configRoot, 0);
                }
                resourceArray[n2 + i] = resourceLocatorArray[i].getResource(configRoot, 3);
                if (bl && blArray[n2 + i] && resourceArray[n2 + i] != null) {
                    resourceArray[n2 + i].unload();
                    resourceArray[n2 + i] = resourceLocatorArray[i].getResource(configRoot, 3);
                }
                resourceArray[n2 * 2 + i] = resourceLocatorArray[i].getResource(configRoot, 2);
                if (bl && blArray[n2 * 2 + i] && resourceArray[n2 * 2 + i] != null) {
                    resourceArray[n2 * 2 + i].unload();
                    resourceArray[n2 * 2 + i] = resourceLocatorArray[i].getResource(configRoot, 2);
                }
                resourceArray[n2 * 3 + i] = resourceLocatorArray[i].getResource(configRoot, 4);
                if (!bl || !blArray[n2 * 3 + i] || resourceArray[n2 * 3 + i] == null) continue;
                resourceArray[n2 * 3 + i].unload();
                resourceArray[n2 * 3 + i] = resourceLocatorArray[i].getResource(configRoot, 4);
            }
            this.releaseService((java.lang.Object)repository);
            RuntimeWarning runtimeWarning = null;
            RuntimeError runtimeError = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Loaded the resources - now install");
            }
            try {
                this.installResources(resourceArray, blArray, bl);
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
            catch (RuntimeError runtimeError2) {
                runtimeError = runtimeError2;
            }
            if (runtimeError != null) {
                throw runtimeError;
            }
            if (runtimeWarning != null) {
                throw runtimeWarning;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ResourceLocator[] getResourceLocators() {
        if (this.locators == null) {
            ArrayList<ResourceLocator> arrayList = new ArrayList<ResourceLocator>(3);
            Enumeration<URL> enumeration = null;
            try {
                enumeration = Thread.currentThread().getContextClassLoader().getResources("META-INF/ws-cache-resourcemgr.config");
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"WSVR0100W", (java.lang.Object)new java.lang.Object[]{"CacheResourceMgr", iOException});
                return null;
            }
            while (enumeration.hasMoreElements()) {
                String string;
                URL uRL = enumeration.nextElement();
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    try {
                        ResourceLocator resourceLocator = (ResourceLocator)ImplFactory.loadImplFromClass((String)string);
                        arrayList.add(resourceLocator);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Added a locator");
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"WSVR0100W", (java.lang.Object)new java.lang.Object[]{string, throwable});
                    }
                }
                java.lang.Object var8_10 = null;
                if (bufferedReader == null) continue;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {}
                continue;
                {
                    catch (IOException iOException) {
                        Tr.service((TraceComponent)tc, (String)"WSVR0100W", (java.lang.Object)new java.lang.Object[]{uRL.toString(), iOException});
                        var8_10 = null;
                        if (bufferedReader == null) continue;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var8_10 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.locators = new ResourceLocator[arrayList.size()];
            arrayList.toArray(this.locators);
        }
        return this.locators;
    }

    protected Map collectJndiNames(Resource[] resourceArray) {
        HashMap hashMap = new HashMap(13);
        for (int i = 0; i < resourceArray.length; ++i) {
            this.collectJndiNames(resourceArray[i], hashMap);
        }
        return hashMap;
    }

    protected Map collectJndiNames(Resource resource, Map map) {
        if (resource != null) {
            EList eList = resource.getContents();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                J2EEResourceProvider j2EEResourceProvider = (J2EEResourceProvider)eList.get(i);
                this.collectJndiNames(j2EEResourceProvider, map);
            }
        }
        return map;
    }

    protected Map collectJndiNames(J2EEResourceProvider j2EEResourceProvider, Map map) {
        EList eList = j2EEResourceProvider.getFactories();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)eList.get(i);
            String string = j2EEResourceFactory.getJndiName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Collected JNDI name " + string));
            }
            try {
                string = this.expandVariable(string);
                j2EEResourceFactory.setJndiName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (string == null) continue;
            map.put(string, j2EEResourceFactory);
        }
        return map;
    }

    protected void installResources(Resource[] resourceArray, boolean[] blArray, boolean bl) throws RuntimeWarning, RuntimeError {
        RuntimeWarning runtimeWarning = null;
        RuntimeError runtimeError = null;
        Map map = this.collectJndiNames(resourceArray);
        HashMap hashMap = new HashMap(5);
        this.startBinders(hashMap);
        for (int i = 0; i < resourceArray.length; ++i) {
            if (!blArray[i]) continue;
            try {
                this.installResource(resourceArray[i], map, hashMap, bl);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
                continue;
            }
            catch (RuntimeError runtimeError2) {
                runtimeError = runtimeError2;
                continue;
            }
            catch (Throwable throwable) {
                String string = "???";
                if (resourceArray[i] != null) {
                    string = resourceArray[i].getURI().toString();
                }
                Tr.error((TraceComponent)tc, (String)"WSVR0120E", (java.lang.Object)new java.lang.Object[]{string, throwable});
                if (this.throwWarnings) {
                    runtimeWarning = new RuntimeWarning(throwable);
                    continue;
                }
                runtimeError = new RuntimeError(throwable);
            }
        }
        this.stopBinders();
        this.flushCache(hashMap, true);
        if (runtimeError != null) {
            throw runtimeError;
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    protected void installResource(Resource resource, Map map, Map map2, boolean bl) throws RuntimeWarning, RuntimeError {
        if (resource == null) {
            return;
        }
        RuntimeWarning runtimeWarning = null;
        EList eList = resource.getContents();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            J2EEResourceProvider j2EEResourceProvider = (J2EEResourceProvider)eList.get(i);
            try {
                this.installResourceProvider(j2EEResourceProvider, map, map2, bl, null);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
                continue;
            }
            catch (RuntimeError runtimeError) {
                throw runtimeError;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void installResourceProvider(J2EEResourceProvider j2EEResourceProvider, Map map, boolean bl, String string) throws RuntimeWarning, RuntimeError {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"installResourceProvider()");
        }
        if (j2EEResourceProvider == null) {
            return;
        }
        java.lang.Object var5_5 = null;
        HashMap hashMap = new HashMap();
        this.collectJndiNames(j2EEResourceProvider, hashMap);
        this.startBinders(map);
        this.installResourceProvider(j2EEResourceProvider, hashMap, map, bl, string);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"installResourceProvider()");
        }
    }

    protected void installResourceProvider(J2EEResourceProvider j2EEResourceProvider, Map map, Map map2, boolean bl, String string) throws RuntimeWarning, RuntimeError {
        EList eList = j2EEResourceProvider.getFactories();
        if (eList.size() == 0) {
            return;
        }
        RuntimeError runtimeError = null;
        RuntimeWarning runtimeWarning = null;
        ResourceBinder resourceBinder = null;
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)eList.get(i);
            if (map.get(j2EEResourceFactory.getJndiName()) != j2EEResourceFactory) continue;
            try {
                resourceBinder = this.getResourceBinder(j2EEResourceFactory);
                if (resourceBinder != null) {
                    this.bind(j2EEResourceFactory, resourceBinder, bl);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.error((TraceComponent)tc, (String)"WSVR0017E", (java.lang.Object)new java.lang.Object[]{j2EEResourceFactory.getName(), j2EEResourceFactory.getJndiName(), j2EEResourceFactory.eResource().getURI(), "no resource binder found"});
                continue;
            }
            catch (ResourceBindingException resourceBindingException) {
                Tr.error((TraceComponent)tc, (String)"WSVR0017E", (java.lang.Object)new java.lang.Object[]{j2EEResourceFactory.getName(), j2EEResourceFactory.getJndiName(), j2EEResourceFactory.eResource().getURI(), resourceBindingException});
                if (this.throwWarnings) {
                    runtimeWarning = new RuntimeWarning((Throwable)resourceBindingException);
                    continue;
                }
                runtimeError = new RuntimeError((Throwable)resourceBindingException);
                continue;
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"WSVR0017E", (java.lang.Object)new java.lang.Object[]{j2EEResourceFactory.getName(), j2EEResourceFactory.getJndiName(), j2EEResourceFactory.eResource().getURI(), throwable});
                if (this.throwWarnings) {
                    runtimeWarning = new RuntimeWarning(throwable);
                    continue;
                }
                runtimeError = new RuntimeError(throwable);
            }
        }
        if (runtimeError != null) {
            throw runtimeError;
        }
        if (resourceBinder != null) {
            Server server = (Server)this.getService(Server.class);
            String string2 = server.getName();
            this.releaseService(server);
            resourceBinder.activateProviderMBean(j2EEResourceProvider, string2);
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    private void flushCache(Map map, boolean bl) {
        if (bl) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                java.lang.Object v = iterator.next();
                if (!(v instanceof Archive)) continue;
                ((Archive)v).close();
            }
        }
        map.clear();
    }

    public synchronized void addResourceBinder(ResourceBinder resourceBinder) {
        ResourceBinder[] resourceBinderArray = new ResourceBinder[this.resourceBinders.length + 1];
        System.arraycopy(this.resourceBinders, 0, resourceBinderArray, 0, this.resourceBinders.length);
        resourceBinderArray[resourceBinderArray.length - 1] = resourceBinder;
        this.resourceBinders = resourceBinderArray;
    }

    public synchronized void removeResourceBinder(ResourceBinder resourceBinder) {
        for (int i = 0; i < this.resourceBinders.length; ++i) {
            if (this.resourceBinders[i] != resourceBinder) continue;
            ResourceBinder[] resourceBinderArray = new ResourceBinder[this.resourceBinders.length - 1];
            System.arraycopy(this.resourceBinders, 0, resourceBinderArray, 0, i);
            System.arraycopy(this.resourceBinders, i + 1, resourceBinderArray, i, this.resourceBinders.length - i);
            this.resourceBinders = resourceBinderArray;
        }
    }

    public synchronized void registerURLHandler(String string, String string2, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    string3 = this.expandVariable(string3);
                    this.publicClassLoader.addPath(string3);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Tr.warning((TraceComponent)tc, (String)"WSVR0016W", (java.lang.Object)new java.lang.Object[]{string3, string, string2});
                }
            }
        }
        try {
            StreamHandlerUtils.addProvider((String)string, (String)string2);
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)("addProvider failed with exception: " + throwable.toString()));
        }
    }
}

