/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.util;

import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializationUtility {
    public static final byte[] serialize(Serializable serializable) throws IOException {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        return byteArrayOutputStream.toByteArray();
    }

    public static final Serializable deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        return SerializationUtility.deserialize(byArray, 0, byArray.length);
    }

    public static final Serializable deserialize(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        WsObjectInputStream wsObjectInputStream = null;
        try {
            byteArrayInputStream.mark(byArray.length);
            wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream);
            return (Serializable)wsObjectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = ServerCache.getClassLoader();
            if (classLoader != null) {
                byteArrayInputStream.reset();
                wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream, classLoader);
                return (Serializable)wsObjectInputStream.readObject();
            }
            throw classNotFoundException;
        }
    }

    public static final Serializable deserialize_1(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        WsObjectInputStream wsObjectInputStream = null;
        try {
            byteArrayInputStream.mark(byArray.length);
            ClassLoader classLoader = ServerCache.getClassLoader();
            if (classLoader != null) {
                byteArrayInputStream.reset();
                wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream, classLoader);
                Object object = wsObjectInputStream.readObject();
                return (Serializable)object;
            }
            byteArrayInputStream.reset();
            wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream);
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Object object = wsObjectInputStream.readObject();
            return (Serializable)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
    }
}

