/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.CacheableServlet;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentCacheProcessor;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.util.WSThreadLocal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public class ServletWrapper
implements CacheableServlet,
Servlet,
HttpJspPage,
ConfigChangeListener {
    private static final long serialVersionUID = 5502601840576150659L;
    private static TraceComponent tc = Trace.register(ServletWrapper.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    Servlet proxied = null;
    ConfigEntry configEntry = null;
    boolean wrapsCacheableServlet = false;
    private HashMap activeConfigEntries = new HashMap();
    private static WSThreadLocal threadLocalConfigEntry = new WSThreadLocal();

    public ServletWrapper(Servlet servlet) {
        this.proxied = servlet;
        this.wrapsCacheableServlet = servlet instanceof CacheableServlet;
        ConfigManager.getInstance().addConfigChangeListener(this);
    }

    public void configChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareMetadata(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("prepareMetadata: " + this.proxied));
        }
        FragmentInfo fragmentInfo = null;
        if (this.wrapsCacheableServlet) {
            CacheableServlet cacheableServlet = (CacheableServlet)this.proxied;
            String string = cacheableServlet.getId(cacheProxyRequest);
            int n = cacheableServlet.getSharingPolicy(cacheProxyRequest);
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cacheId is null");
                }
            } else {
                fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
                String string2 = cacheProxyRequest.getMethod();
                StringBuffer stringBuffer = new StringBuffer();
                if (string.indexOf("requestType=" + string2) == -1 && (string2.equals("GET") || string2.equals("POST")) && !fragmentInfo.isIgnoreGetPost()) {
                    fragmentInfo.addDataId(string);
                    stringBuffer.append(string).append(':').append("requestType=" + string2);
                    string = stringBuffer.toString();
                }
                fragmentInfo.setId(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sharingPolicy: " + n));
                }
                fragmentInfo.setSharingPolicy(n);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
            }
            return;
        }
        Object object4 = this.activeConfigEntries;
        synchronized (object4) {
            object3 = null;
            object2 = cacheProxyRequest.getContextPath();
            object = this.proxied.getClass().getName() + ".class";
            String string = this.buildName(cacheProxyRequest);
            if (string != null) {
                object3 = (ConfigEntry)this.activeConfigEntries.get(string);
            }
            if (object3 == null) {
                String string3 = object2 == null ? object : (String)object2 + "/" + (String)object;
                object3 = (ConfigEntry)this.activeConfigEntries.get(string3);
            }
            if (object3 == null && (object3 = ConfigManager.getInstance().getServletCacheEntry(this.proxied, string, (String)object2)) != null) {
                this.activeConfigEntries.put(((ConfigEntry)object3).name, object3);
            }
            threadLocalConfigEntry.set(object3);
        }
        object4 = (ConfigEntry)threadLocalConfigEntry.get();
        fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
        if (object4 == null) {
            fragmentInfo.setId(null);
        } else {
            object3 = (FragmentCacheProcessor)ConfigManager.getInstance().getCacheProcessor((ConfigEntry)object4);
            try {
                ((FragmentCacheProcessor)object3).execute(cacheProxyRequest, cacheProxyResponse, this.proxied);
                fragmentInfo.setId(((CacheProcessor)object3).getId());
                if (((CacheProcessor)object3).getId() != null) {
                    ((FragmentCacheProcessor)object3).populateFragmentInfo(fragmentInfo);
                }
                if ((object2 = ServerCache.getJspCache(((ConfigEntry)object4).instanceName)) != null && (object = ((CacheProcessor)object3).getInvalidationIds()) != null) {
                    int n = ((ArrayList)object).size();
                    for (int i = 0; i < n; ++i) {
                        ((JSPCache)object2).invalidateById((String)((ArrayList)object).get(i), i == n - 1);
                    }
                }
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                threadLocalConfigEntry.set(null);
                ConfigManager.getInstance().returnCacheProcessor((CacheProcessor)object3);
                throw throwable;
            }
            threadLocalConfigEntry.set(null);
            ConfigManager.getInstance().returnCacheProcessor((CacheProcessor)object3);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
        }
    }

    String buildName(CacheProxyRequest cacheProxyRequest) {
        String string = cacheProxyRequest.getAbsoluteUri();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getId(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getId() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getId()));
        }
        return cacheProxyRequest.getFragmentInfo().getId();
    }

    public int getSharingPolicy(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSharingPolicy() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getSharingPolicy()));
        }
        return cacheProxyRequest.getFragmentInfo().getSharingPolicy();
    }

    public void destroy() {
        CacheConfig cacheConfig = ServerCache.cacheUnit.getCacheConfig();
        if (!CacheServiceImpl.state.equals("STOPPING")) {
            Iterator iterator = this.activeConfigEntries.values().iterator();
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                JSPCache jSPCache = ServerCache.getJspCache(configEntry.instanceName);
                if (jSPCache == null) continue;
                if (cacheConfig.disableTemplateInvalidation) {
                    Tr.info((TraceComponent)tc, (String)"dynacache.error", (Object)("Error type=destroy warning. Skipping template invalidation for JSP " + configEntry.name));
                    continue;
                }
                jSPCache.invalidateByTemplate(configEntry.name, true);
            }
        }
        this.activeConfigEntries.clear();
        this.proxied.destroy();
        ConfigManager.getInstance().removeConfigChangeListener(this);
    }

    public ServletConfig getServletConfig() {
        return this.proxied.getServletConfig();
    }

    public String getServletInfo() {
        return this.proxied.getServletInfo();
    }

    public ServletContext getServletContext() {
        return this.proxied.getServletConfig().getServletContext();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init()");
        }
        this.proxied.init(servletConfig);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        CacheHook.handleServlet(this, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }

    public Servlet getProxiedServlet() {
        return this.proxied;
    }

    public void serviceProxied(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.proxied.service(servletRequest, servletResponse);
    }

    public void _jspService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ((HttpJspPage)this.proxied)._jspService(httpServletRequest, httpServletResponse);
    }

    public void jspInit() {
        ((HttpJspPage)this.proxied).jspInit();
    }

    public void jspDestroy() {
        ((HttpJspPage)this.proxied).jspDestroy();
    }
}

