/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.IdGenerator;
import com.ibm.websphere.servlet.cache.MetaDataGenerator;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Property;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class FragmentCacheProcessor
extends CacheProcessor {
    protected static TraceComponent tc = Trace.register(FragmentCacheProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String PROPERTY_EDGEABLE = "edgeable";
    public static final String PROPERTY_CONSUME_SUBFRAGMENTS = "consume-subfragments";
    public static final String PROPERTY_DO_NOT_CONSUME = "do-not-consume";
    public static final String PROPERTY_EXTERNALCACHE = "externalcache";
    public static final String PROPERTY_ALTERNATE_URL = "alternate_url";
    public static final String PROPERTY_SAVE_ATTRIBUTES = "save-attributes";
    public static final String PROPERTY_STORE_COOKIES = "store-cookies";
    public static final String PROPERTY_IGNORE_GET_POST = "ignore-get-post";
    protected static final int SLOT_EDGEABLE = 5;
    protected static final int SLOT_CONSUME_SUBFRAGMENTS = 6;
    protected static final int SLOT_EXTERNALCACHE = 7;
    protected static final int SLOT_ALTERNATE_URL = 8;
    protected static final int SLOT_CONTAINS_EDGEABLE_PATHINFO = 9;
    protected static final int SLOT_ESI_VALUE_CACHE = 10;
    protected static final int SLOT_ESI_PATHINFO_VALUES = 11;
    protected static final int SLOT_CONTAINS_EDGEABLE_SERVLETPATH = 12;
    protected static final int SLOT_ESI_SERVLETPATH_VALUES = 13;
    protected static final int SLOT_SAVE_ATTRIBUTES = 14;
    protected static final int SLOT_STORE_COOKIES = 15;
    protected static final int SLOT_DO_NOT_CONSUME = 16;
    protected static final int SLOT_ATTRIBUTE_EXCLUDE_LIST = 17;
    protected static final int SLOT_IGNORE_GET_POST = 18;
    protected static final int PROCESSOR_SLOTS = 19;
    protected CacheProxyRequest request = null;
    protected CacheProxyResponse response = null;
    protected Servlet servlet = null;
    protected static HashMap ESICache = new HashMap();
    protected static HashMap ESIQueryCache = new HashMap();
    String externalCacheGroupId;
    boolean edgeable = false;
    String esiQueryString = null;
    String esiId = null;
    boolean consumeSubfragments = false;
    boolean doNotConsume = false;
    String baseName = null;
    String altUrl = null;
    String pathInfo = null;
    String servletpath = null;
    boolean ignoreGetPost = false;

    public void reset(ConfigEntry configEntry) {
        super.reset(configEntry);
        this.request = null;
        this.response = null;
        this.externalCacheGroupId = null;
        this.consumeSubfragments = false;
        this.doNotConsume = false;
        this.edgeable = false;
        this.altUrl = null;
        this.pathInfo = null;
        this.servletpath = null;
        if (configEntry != null) {
            this.sharingPolicy = configEntry.sharingPolicy;
        }
        this.esiQueryString = null;
        this.esiId = null;
        this.baseName = null;
        this.ignoreGetPost = false;
    }

    public boolean preProcess(ConfigEntry configEntry) {
        boolean bl;
        boolean bl2;
        String string;
        configEntry.processorData = new Object[19];
        boolean bl3 = super.preProcess(configEntry);
        Property property = (Property)configEntry.properties.get(PROPERTY_EDGEABLE);
        String string2 = string = property != null ? property.value : null;
        if (string != null) {
            string = string.trim();
        }
        Boolean bl4 = new Boolean(string);
        configEntry.processorData[5] = bl4;
        if (bl4.booleanValue()) {
            property = (Property)configEntry.properties.get(PROPERTY_ALTERNATE_URL);
            String string3 = string = property != null ? property.value : null;
            if (string != null) {
                string = string.trim();
                configEntry.processorData[8] = string;
            }
        }
        String string4 = string = (property = (Property)configEntry.properties.get(PROPERTY_CONSUME_SUBFRAGMENTS)) != null ? property.value : null;
        if (string != null) {
            string = string.trim();
        }
        configEntry.processorData[6] = new Boolean(string);
        property = (Property)configEntry.properties.get(PROPERTY_DO_NOT_CONSUME);
        String string5 = string = property != null ? property.value : null;
        if (string != null) {
            string = string.trim();
        }
        configEntry.processorData[16] = new Boolean(string);
        property = (Property)configEntry.properties.get(PROPERTY_EXTERNALCACHE);
        String string6 = string = property != null ? property.value : null;
        if (string != null) {
            string = string.trim();
            configEntry.processorData[7] = string;
        }
        String string7 = string = (property = (Property)configEntry.properties.get(PROPERTY_SAVE_ATTRIBUTES)) != null ? property.value : null;
        if (string != null) {
            string = string.trim();
            bl4 = new Boolean(string);
            String[] stringArray = null;
            if (property != null && property.excludeList != null) {
                stringArray = new String[property.excludeList.length];
                for (bl2 = false; bl2 < property.excludeList.length; bl2 += 1) {
                    stringArray[bl2] = property.excludeList[bl2];
                }
            }
            configEntry.processorData[17] = stringArray;
        } else {
            bl4 = Boolean.TRUE;
        }
        configEntry.processorData[14] = bl4;
        property = (Property)configEntry.properties.get(PROPERTY_STORE_COOKIES);
        string = property != null ? property.value : null;
        configEntry.processorData[15] = string;
        property = (Property)configEntry.properties.get(PROPERTY_IGNORE_GET_POST);
        String string8 = string = property != null ? property.value : null;
        if (string != null) {
            string = string.trim();
        }
        configEntry.processorData[18] = new Boolean(string);
        for (bl = false; bl < configEntry.cacheIds.length; bl += 1) {
            bl3 &= this.preProcess(configEntry.cacheIds[bl]);
        }
        bl = false;
        bl2 = false;
        Boolean bl5 = (Boolean)configEntry.processorData[5];
        boolean bl6 = bl5 != null && bl5 != false;
        for (int i = 0; i < configEntry.cacheIds.length; ++i) {
            CacheId cacheId = configEntry.cacheIds[i];
            bl4 = (Boolean)cacheId.processorData[5];
            if (!bl6 && (bl4 == null || !bl4.booleanValue())) continue;
            for (int j = 0; j < cacheId.components.length; ++j) {
                HashSet hashSet;
                if (cacheId.components[j].iType == 12) {
                    bl = true;
                    hashSet = (HashSet)configEntry.processorData[11];
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    }
                    hashSet.addAll(cacheId.components[j].values.keySet());
                    configEntry.processorData[11] = hashSet;
                    continue;
                }
                if (cacheId.components[j].iType != 13) continue;
                bl2 = true;
                hashSet = (HashSet)configEntry.processorData[13];
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(cacheId.components[j].values.keySet());
                configEntry.processorData[13] = hashSet;
            }
        }
        configEntry.processorData[9] = new Boolean(bl);
        configEntry.processorData[12] = new Boolean(bl2);
        if (bl || bl2) {
            configEntry.processorData[10] = new HashMap();
        }
        return bl3;
    }

    public boolean preProcess(CacheId cacheId) {
        cacheId.processorData = new Object[19];
        boolean bl = super.preProcess(cacheId);
        if (cacheId.properties != null) {
            String string;
            Property property = (Property)cacheId.properties.get(PROPERTY_EDGEABLE);
            String string2 = string = property != null ? property.value : null;
            if (string != null) {
                string = string.trim();
                Boolean bl2 = new Boolean(string);
                cacheId.processorData[5] = bl2;
                if (bl2.booleanValue()) {
                    property = (Property)cacheId.properties.get(PROPERTY_ALTERNATE_URL);
                    String string3 = string = property != null ? property.value : null;
                    if (string != null) {
                        string = string.trim();
                        cacheId.processorData[8] = string;
                    }
                }
            }
            if (cacheId.processorData[6] == null || !((Boolean)cacheId.processorData[6]).booleanValue()) {
                property = (Property)cacheId.properties.get(PROPERTY_CONSUME_SUBFRAGMENTS);
                String string4 = string = property != null ? property.value : null;
                if (string != null) {
                    string = string.trim();
                    cacheId.processorData[6] = new Boolean(string);
                }
            }
            if (cacheId.processorData[16] == null || !((Boolean)cacheId.processorData[16]).booleanValue()) {
                property = (Property)cacheId.properties.get(PROPERTY_DO_NOT_CONSUME);
                String string5 = string = property != null ? property.value : null;
                if (string != null) {
                    string = string.trim();
                    cacheId.processorData[16] = new Boolean(string);
                }
            }
            String string6 = string = (property = (Property)cacheId.properties.get(PROPERTY_EXTERNALCACHE)) != null ? property.value : null;
            if (string != null) {
                string = string.trim();
                cacheId.processorData[7] = string;
            }
            if (cacheId.processorData[18] == null || !((Boolean)cacheId.processorData[18]).booleanValue()) {
                property = (Property)cacheId.properties.get(PROPERTY_IGNORE_GET_POST);
                String string7 = string = property != null ? property.value : null;
                if (string != null) {
                    string = string.trim();
                    cacheId.processorData[18] = new Boolean(string);
                }
            }
        }
        return bl;
    }

    public void processCacheIdProperties(CacheId cacheId) {
        super.processCacheIdProperties(cacheId);
        if (cacheId.processorData[5] != null) {
            this.edgeable = (Boolean)cacheId.processorData[5];
        }
        if (cacheId.processorData[6] != null) {
            this.consumeSubfragments = (Boolean)cacheId.processorData[6];
        }
        if (cacheId.processorData[7] != null) {
            this.externalCacheGroupId = (String)cacheId.processorData[7];
        }
        if (cacheId.processorData[8] != null) {
            this.altUrl = (String)cacheId.processorData[8];
        }
        if (cacheId.processorData[16] != null) {
            this.doNotConsume = (Boolean)cacheId.processorData[16];
        }
        if (cacheId.processorData[18] != null) {
            this.ignoreGetPost = (Boolean)cacheId.processorData[18];
        }
    }

    public void processConfigEntryProperties() {
        super.processConfigEntryProperties();
        if (this.configEntry.processorData[5] != null) {
            this.edgeable = (Boolean)this.configEntry.processorData[5];
        }
        if (this.configEntry.processorData[6] != null) {
            this.consumeSubfragments = (Boolean)this.configEntry.processorData[6];
        }
        if (this.configEntry.processorData[7] != null) {
            this.externalCacheGroupId = (String)this.configEntry.processorData[7];
        }
        if (this.configEntry.processorData[8] != null) {
            this.altUrl = (String)this.configEntry.processorData[8];
        }
        if (this.configEntry.processorData[16] != null) {
            this.doNotConsume = (Boolean)this.configEntry.processorData[16];
        }
        if (this.configEntry.processorData[18] != null) {
            this.ignoreGetPost = (Boolean)this.configEntry.processorData[18];
        }
    }

    public String getBaseName() {
        if (this.baseName == null) {
            this.baseName = this.configEntry.name;
        }
        return this.baseName;
    }

    public void populateFragmentInfo(FragmentInfo fragmentInfo) {
        Object object;
        fragmentInfo.setId(this.getId());
        fragmentInfo.addTemplate(this.getBaseName());
        fragmentInfo.setInstanceName(this.configEntry.instanceName);
        if (!this.cacheable) {
            return;
        }
        boolean bl = (Boolean)this.configEntry.processorData[14];
        fragmentInfo.setStoreAttributes(bl);
        String[] stringArray = (String[])this.configEntry.processorData[17];
        fragmentInfo.setAttributeExcludeList(stringArray);
        String string = (String)this.configEntry.processorData[15];
        if (string != null) {
            fragmentInfo.setStoreCookies(new Boolean(string.trim()));
        } else {
            object = ServerCache.getCache(this.configEntry.instanceName);
            if (object != null) {
                fragmentInfo.setStoreCookies(((Cache)object).cacheInstanceStoreCookies);
            } else {
                fragmentInfo.setStoreCookies(true);
            }
        }
        fragmentInfo.setSharingPolicy(this.sharingPolicy);
        fragmentInfo.setPersistToDisk(this.persistToDisk);
        fragmentInfo.setTimeLimit(this.timeout);
        fragmentInfo.setInactivity(this.inactivity);
        fragmentInfo.setIgnoreGetPost(this.ignoreGetPost);
        if (this.priority > 0) {
            fragmentInfo.setPriority(this.priority);
        }
        if (this.groupIds != null) {
            for (int i = 0; i < this.groupIds.size(); ++i) {
                fragmentInfo.addDataId((String)this.groupIds.get(i));
            }
        }
        if (this.edgeable) {
            object = this.getESICacheId(this.configEntry);
            if (object != null) {
                fragmentInfo.setEdgeable(true);
                fragmentInfo.setESICacheId((String)object);
                fragmentInfo.setESIQueryString(this.esiQueryString);
            }
            if (this.altUrl != null) {
                fragmentInfo.setAlternateUrl(this.altUrl);
            }
        }
        fragmentInfo.setConsumeSubfragments(this.consumeSubfragments);
        fragmentInfo.setDoNotConsume(this.doNotConsume);
        if (this.externalCacheGroupId != null) {
            fragmentInfo.setExternalCacheGroupId(this.externalCacheGroupId);
        }
        if (this.cacheIdForMetaDataGenerator != null) {
            this.processMetaDataGenerator(this.cacheIdForMetaDataGenerator);
        }
    }

    public boolean execute(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse, Servlet servlet) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("execute: " + this.configEntry.name));
        }
        this.request = cacheProxyRequest;
        this.response = cacheProxyResponse;
        this.servlet = servlet;
        super.execute();
        if (this.cacheable) {
            object2 = cacheProxyRequest.getCharacterEncoding();
            if (object2 != null) {
                this.id.append(':').append((String)object2);
            }
            object = cacheProxyRequest.getMethod();
            if (this.ignoreGetPost) {
                if (!((String)object).equals("GET") && !((String)object).equals("POST")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Request type is not GET or POST, value of property ignore-get-post will be set to false for this request.");
                    }
                    this.ignoreGetPost = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignore-get-post property is set to true, will not differentiate between GET and POST requests types unless defined explicitly in the cache policy.");
                }
            }
            if (this.id.toString().indexOf("requestType=" + (String)object) == -1 && (((String)object).equals("GET") || ((String)object).equals("POST")) && !this.ignoreGetPost) {
                this.id.append(':').append("requestType=" + (String)object);
            }
        }
        if (this.edgeable) {
            object2 = (Boolean)this.configEntry.processorData[9];
            if (((Boolean)object2).booleanValue()) {
                this.pathInfo = cacheProxyRequest.getPathInfo();
            }
            if (((Boolean)(object = (Boolean)this.configEntry.processorData[12])).booleanValue()) {
                this.servletpath = ((String)cacheProxyRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type")).equals("include") ? (String)cacheProxyRequest.getAttribute("javax.servlet.include.servlet_path") : cacheProxyRequest.getServletPath();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"execute");
        }
        return this.cacheable;
    }

    protected boolean processCacheId(CacheId cacheId) {
        boolean bl = super.processCacheId(cacheId);
        if (bl) {
            this.esiQueryString = this.getESIQueryString(cacheId);
        }
        return bl;
    }

    protected Object getComponentValue(Component component) {
        if (component == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FragmentCacheProcessor.getComponentValue(): null component passed in, returning null.");
            }
            return null;
        }
        Object object = null;
        switch (component.iType) {
            case 3: {
                if (!component.id.equals("*")) {
                    return this.request.getParameter(component.id);
                }
                if (!this.response.getFragmentComposer().getInclude()) {
                    object = this.request.getQueryString();
                    break;
                }
                object = (String)this.request.getAttribute("javax.servlet.include.query_string");
                break;
            }
            case 11: {
                object = this.request.getAttribute(component.id);
                if (component.index <= -1) break;
                if (object instanceof Collection) {
                    object = ((Collection)object).toArray();
                }
                if (!(object instanceof Object[]) || ((Object[])object).length <= component.index) break;
                object = object[component.index];
                break;
            }
            case 2: {
                HttpSession httpSession = this.request.getSession(false);
                if (httpSession == null) break;
                object = httpSession.getAttribute(component.id);
                break;
            }
            case 4: {
                Cookie[] cookieArray = this.request.getCookies();
                if (cookieArray == null) break;
                for (int i = 0; object == null && i < cookieArray.length; ++i) {
                    if (!cookieArray[i].getName().equals(component.id)) continue;
                    object = cookieArray[i].getValue();
                }
                break;
            }
            case 5: {
                return this.request.getHeader(component.id);
            }
            case 6: {
                object = this.request.getLocale();
                break;
            }
            case 12: {
                if (!this.response.getFragmentComposer().getInclude()) {
                    object = this.request.getPathInfo();
                    break;
                }
                object = (String)this.request.getAttribute("javax.servlet.include.path_info");
                break;
            }
            case 13: {
                if (!this.response.getFragmentComposer().getInclude()) {
                    object = this.request.getServletPath();
                    break;
                }
                object = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
                break;
            }
            case 14: {
                Object[] objectArray = this.request.getParameterValues(component.id);
                if (objectArray == null) break;
                Arrays.sort(objectArray);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append((String)objectArray[i]);
                    if (i == objectArray.length - 1) continue;
                    stringBuffer.append(',');
                }
                object = stringBuffer.toString();
                break;
            }
            case 20: {
                object = this.request.getMethod();
                break;
            }
            case 21: {
                try {
                    Object object2 = this.request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
                    Method method = object2.getClass().getMethod("getAttribute", String.class);
                    object = method.invoke(object2, component.id);
                    break;
                }
                catch (Exception exception) {
                    System.out.println("Warning: struts.jar is not in the application or server classpath. Hence component type 'tiles_attribute' is not supported.");
                    return null;
                }
            }
            default: {
                Tr.error((TraceComponent)tc, (String)"DYNA0040E", (Object)new Object[]{component.type, this.request.getContextPath() + this.request.getServletPath()});
                return null;
            }
        }
        if (object == null) {
            return null;
        }
        if (object != null) {
            if (component.method != null) {
                object = this.processMethod(component.method, object);
            } else if (component.field != null) {
                object = this.processField(component.field, object);
            }
        }
        return object;
    }

    protected String processIdGenerator(CacheId cacheId) {
        if (cacheId.idGeneratorImpl == null) {
            try {
                Class<?> clazz = Class.forName(cacheId.idGenerator, true, Thread.currentThread().getContextClassLoader());
                cacheId.idGeneratorImpl = clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.FragmentCacheProcessor.processIdGenerator", "291", this);
                Tr.error((TraceComponent)tc, (String)"dynacache.idgeneratorerror", (Object)new Object[]{cacheId.idGenerator});
                return null;
            }
        }
        return ((IdGenerator)cacheId.idGeneratorImpl).getId(this.request);
    }

    protected void processMetaDataGenerator(CacheId cacheId) {
        if (cacheId.metaDataGeneratorImpl == null) {
            try {
                Class<?> clazz = Class.forName(cacheId.metaDataGenerator, true, Thread.currentThread().getContextClassLoader());
                cacheId.metaDataGeneratorImpl = clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.FragmentCacheProcessor.processMetaDataGenerator", "306", this);
                Tr.error((TraceComponent)tc, (String)"dynacache.metadatageneratorerror", (Object)new Object[]{cacheId.metaDataGenerator});
                return;
            }
        }
        ((MetaDataGenerator)cacheId.metaDataGeneratorImpl).setMetaData(this.request, this.response);
    }

    protected String[] processInvalidationGenerator(Invalidation invalidation) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Servlets do not support custom invalidation generating classes.");
        }
        return null;
    }

    public String getESICacheId(ConfigEntry configEntry) {
        if (this.esiId != null) {
            return this.esiId;
        }
        HashMap hashMap = (HashMap)configEntry.processorData[10];
        if (hashMap != null) {
            this.esiId = (String)hashMap.get(this.pathInfo);
            if (this.esiId != null) {
                return this.esiId;
            }
            this.esiId = (String)hashMap.get(this.servletpath);
            if (this.esiId != null) {
                return this.esiId;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        if (configEntry.cacheIds != null && configEntry.cacheIds.length > 0) {
            for (int i = 0; i < configEntry.cacheIds.length; ++i) {
                CacheId cacheId = configEntry.cacheIds[i];
                if ((cacheId.processorData[5] == null || !((Boolean)cacheId.processorData[5]).booleanValue()) && (configEntry.processorData[5] == null || !((Boolean)configEntry.processorData[5]).booleanValue())) continue;
                this.getESIRule(configEntry.cacheIds[i], stringBuffer, configEntry.name);
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        stringBuffer.insert(0, "cacheid=\"");
        stringBuffer.append("\"");
        this.esiId = stringBuffer.toString();
        if (((Boolean)configEntry.processorData[9]).booleanValue() && ((HashSet)configEntry.processorData[11]).contains(this.pathInfo)) {
            hashMap.put(this.pathInfo, this.esiId);
        }
        if (((Boolean)configEntry.processorData[12]).booleanValue() && ((HashSet)configEntry.processorData[13]).contains(this.servletpath)) {
            hashMap.put(this.servletpath, this.esiId);
        }
        return this.esiId;
    }

    public String getESIQueryString(CacheId cacheId) {
        if (this.esiQueryString != null) {
            return this.esiQueryString;
        }
        String string = this.request.getAbsoluteUri();
        int n = -1;
        if (string != null) {
            n = string.indexOf("?");
        }
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        StringBuffer stringBuffer = null;
        String string3 = null;
        String string4 = null;
        if (cacheId.components != null) {
            for (int i = 0; i < cacheId.components.length; ++i) {
                Component component = cacheId.components[i];
                boolean bl = false;
                if (component.type.equals("parameter")) {
                    if (n > -1) {
                        string2 = this.request.getAbsoluteUri().substring(n + 1);
                        stringTokenizer = new StringTokenizer(string2, "&");
                    }
                    if (stringTokenizer != null) {
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            string4 = string3.substring(0, string3.indexOf("="));
                            if (!string4.trim().equals(component.id.trim())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(32 * cacheId.components.length);
                        stringBuffer.append("?");
                    } else {
                        stringBuffer.append("&");
                    }
                    if (bl) {
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append(component.id).append("=").append("$(QUERY_STRING{" + component.id + "})");
                    continue;
                }
                if (!component.type.equals("cookie")) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(32 * cacheId.components.length);
                    stringBuffer.append("?");
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append(component.id).append("=").append("$(HTTP_COOKIE{" + component.id + "})");
            }
        }
        this.esiQueryString = stringBuffer != null ? stringBuffer.toString() : "";
        return this.esiQueryString;
    }

    public void getESIRule(CacheId cacheId, StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        block7: for (int i = 0; cacheId.components != null && i < cacheId.components.length; ++i) {
            Component component = cacheId.components[i];
            switch (component.iType) {
                case 3: {
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer();
                    } else {
                        stringBuffer2.append(" ");
                    }
                    component.getESIComponent(stringBuffer2);
                    continue block7;
                }
                case 5: {
                    if (stringBuffer4 == null) {
                        stringBuffer4 = new StringBuffer();
                    } else {
                        stringBuffer4.append(" ");
                    }
                    component.getESIComponent(stringBuffer4);
                    continue block7;
                }
                case 4: {
                    if (stringBuffer3 == null) {
                        stringBuffer3 = new StringBuffer();
                    } else {
                        stringBuffer3.append(" ");
                    }
                    component.getESIComponent(stringBuffer3);
                    continue block7;
                }
                case 12: {
                    int n;
                    if (component.values != null && component.values.size() != 0 && !component.values.containsKey(this.pathInfo)) {
                        return;
                    }
                    if (component.notValues == null || component.notValues.length <= 0) continue block7;
                    boolean bl = true;
                    for (n = 0; n < component.notValues.length; ++n) {
                        if (!component.notValues[n].equals(this.pathInfo)) continue;
                        bl = false;
                    }
                    if (bl) continue block7;
                    return;
                }
                case 13: {
                    int n;
                    if (component.values != null && component.values.size() != 0 && !component.values.containsKey(this.servletpath)) {
                        return;
                    }
                    if (component.notValues == null || component.notValues.length <= 0) continue block7;
                    boolean bl = true;
                    for (n = 0; n < component.notValues.length; ++n) {
                        if (!component.notValues[n].equals(this.servletpath)) continue;
                        bl = false;
                    }
                    if (bl) continue block7;
                    return;
                }
                default: {
                    Tr.error((TraceComponent)tc, (String)"DYNA0041E", (Object)new Object[]{component.type, string});
                    return;
                }
            }
        }
        stringBuffer.append("(");
        if (stringBuffer2 != null) {
            stringBuffer.append(stringBuffer2.toString());
        }
        if (stringBuffer3 == null && stringBuffer4 == null) {
            stringBuffer.append(")").toString();
            return;
        }
        stringBuffer.append(",");
        if (stringBuffer3 != null) {
            stringBuffer.append(stringBuffer3.toString());
        }
        if (stringBuffer4 != null) {
            stringBuffer.append(",").append(stringBuffer4.toString());
        }
        stringBuffer.append(")");
    }
}

