/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.servlet.ESIProcessor;
import com.ibm.ws.cache.servlet.ESIProcessorStats;
import com.ibm.ws.cache.servlet.ESIServerStats;
import java.io.IOException;
import java.util.HashMap;

public class ESIStats {
    private static final TraceComponent _tc = Trace.register(ESIStats.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.servlet.ESIStats");
    private HashMap _serverStats = new HashMap();
    private boolean _gatherEntries = false;

    public boolean getGatherEntries() {
        return this._gatherEntries;
    }

    public void setGatherEntries(boolean bl) {
        this._gatherEntries = bl;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setGatherEntries " + bl));
        }
    }

    public void gather() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"gather");
        }
        this.clear();
        int n = this._gatherEntries ? 8064 : 3968;
        ESIProcessorStats[] eSIProcessorStatsArray = ESIProcessor.gather(n);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"sorting gathered statistics");
        }
        for (int i = 0; i < eSIProcessorStatsArray.length; ++i) {
            String string = eSIProcessorStatsArray[i].getHostName();
            ESIServerStats eSIServerStats = (ESIServerStats)this._serverStats.get(string);
            if (eSIServerStats == null) {
                eSIServerStats = new ESIServerStats(string);
                this._serverStats.put(string, eSIServerStats);
            }
            eSIServerStats.addProcessorStats(eSIProcessorStatsArray[i]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"gather");
        }
    }

    public ESIServerStats[] getServerStats() {
        return this._serverStats.values().toArray(new ESIServerStats[0]);
    }

    public void clear() {
        this._serverStats.clear();
    }

    public void resetCounters() throws IOException {
        ESIProcessor.resetCounters();
    }

    public void clearCaches() throws IOException {
        ESIProcessor.clearCaches();
    }
}

