/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.cache.servlet.ESIInputStream;
import com.ibm.ws.cache.servlet.ESIOutputStream;
import com.ibm.ws.cache.servlet.ESIProcessorRequest;
import com.ibm.ws.cache.servlet.ESIProcessorStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ESIProcessor {
    private static final List _running = Collections.synchronizedList(new LinkedList());
    private static final TraceComponent _tc = Tr.register((Class)ESIProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.servlet.ESIProcessor");
    private static final boolean isZOS = ESIInvalidatorHelper.isZOS;
    private String _hostName;
    private int _pid;
    private ESIInputStream _in;
    private ESIOutputStream _out;
    private boolean _isAlive;
    private ESIProcessorRequest _curRequest = null;
    private static ESIProcessor protoprocessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(String string, InputStream inputStream, OutputStream outputStream) {
        ESIProcessor eSIProcessor;
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)("run: " + string));
            }
            eSIProcessor = null;
            try {
                try {
                    eSIProcessor = new ESIProcessor(string, inputStream, outputStream);
                    if (isZOS) {
                        protoprocessor = eSIProcessor;
                    }
                    _running.add(eSIProcessor);
                    if (!isZOS) {
                        eSIProcessor.listen();
                    }
                }
                catch (IOException iOException) {
                    if (_tc.isDebugEnabled()) {
                        iOException.printStackTrace();
                    }
                    Object var6_5 = null;
                    if (eSIProcessor != null) {
                        _running.remove(eSIProcessor);
                    }
                    if (!_tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)_tc, (String)("run: " + eSIProcessor));
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                    Object var6_6 = null;
                    if (eSIProcessor != null) {
                        _running.remove(eSIProcessor);
                    }
                    if (!_tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)_tc, (String)("run: " + eSIProcessor));
                    return;
                }
                Object var6_4 = null;
                if (eSIProcessor == null) break block13;
                _running.remove(eSIProcessor);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (eSIProcessor != null) {
                    _running.remove(eSIProcessor);
                }
                if (!_tc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)_tc, (String)("run: " + eSIProcessor));
                throw throwable;
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)("run: " + eSIProcessor));
    }

    public static ESIProcessor[] getRunning() {
        if (isZOS) {
            _running.clear();
            _running.add(protoprocessor);
        }
        return _running.toArray(new ESIProcessor[0]);
    }

    public static synchronized int collectEdgeStats(int n) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("collectEdgeStats " + n));
        }
        String string = null;
        int n2 = 0;
        if (protoprocessor == null) {
            throw new IOException("collectEdgeStats() : Edge inactive.");
        }
        protoprocessor.writeInt(2);
        protoprocessor.writeInt(n);
        protoprocessor.flushWithResponse();
        string = ESIProcessor.protoprocessor._in.readUTF();
        n2 = new Integer(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("collectEdgeStats() : plugins responded : " + n2));
        }
        return n2;
    }

    public static void invalidateIds(Iterator iterator) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"invalidateIds");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            for (int i = 0; i < eSIProcessorArray.length; ++i) {
                try {
                    eSIProcessorArray[i].invalidateId(string);
                    continue;
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)_tc, (String)("failure invalidating " + string + " in " + eSIProcessorArray[i] + ": " + exception.getMessage()));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"invalidateIds");
        }
    }

    public static void clearCaches() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"clearCaches");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        for (int i = 0; i < eSIProcessorArray.length; ++i) {
            try {
                eSIProcessorArray[i].clearCache();
                continue;
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)_tc, (String)("failure clearing cache in " + eSIProcessorArray[i] + ": " + exception.getMessage()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"clearCaches");
        }
    }

    public static void resetCounters() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"resetCounters");
        }
        ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
        for (int i = 0; i < eSIProcessorArray.length; ++i) {
            try {
                eSIProcessorArray[i].resetCounter();
                continue;
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)_tc, (String)("failure resetting counters in " + eSIProcessorArray[i] + ": " + exception.getMessage()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"resetCounters");
        }
    }

    public static synchronized ESIProcessorStats[] gather(int n) throws IOException {
        ESIProcessorStats[] eSIProcessorStatsArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"gather");
        }
        if (!isZOS) {
            int n2;
            ESIProcessor[] eSIProcessorArray = ESIProcessor.getRunning();
            eSIProcessorStatsArray = new ESIProcessorStats[eSIProcessorArray.length];
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("submitting requests to " + eSIProcessorStatsArray.length + " ESI processors"));
            }
            for (n2 = 0; n2 < eSIProcessorStatsArray.length; ++n2) {
                eSIProcessorStatsArray[n2] = new ESIProcessorStats(eSIProcessorArray[n2], n);
                eSIProcessorArray[n2].submit(eSIProcessorStatsArray[n2]);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"waiting for responses");
            }
            n2 = 0;
            for (int i = 0; i < eSIProcessorStatsArray.length; ++i) {
                try {
                    if (eSIProcessorArray[i].isAlive()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("waiting for response from " + eSIProcessorArray[i].toString()));
                        }
                        eSIProcessorStatsArray[i].awaitCompletion();
                        ++n2;
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("processor is dead; not waiting for response from " + eSIProcessorArray[i].toString()));
                    }
                    eSIProcessorStatsArray[i] = null;
                    continue;
                }
                catch (Throwable throwable) {
                    eSIProcessorStatsArray[i] = null;
                }
            }
            if (eSIProcessorStatsArray.length > n2) {
                ESIProcessorStats[] eSIProcessorStatsArray2 = new ESIProcessorStats[n2];
                n2 = 0;
                for (int i = 0; i < eSIProcessorStatsArray.length; ++i) {
                    if (eSIProcessorStatsArray[i] == null) continue;
                    eSIProcessorStatsArray2[n2++] = eSIProcessorStatsArray[i];
                }
                eSIProcessorStatsArray = eSIProcessorStatsArray2;
            }
        } else {
            int n3 = ESIProcessor.collectEdgeStats(8064);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("processors : " + n3));
            }
            eSIProcessorStatsArray = new ESIProcessorStats[n3];
            for (int i = 0; i < n3; ++i) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("processing stats block " + i));
                }
                eSIProcessorStatsArray[i] = new ESIProcessorStats(protoprocessor, 8064);
                eSIProcessorStatsArray[i].handle();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"gather");
        }
        return eSIProcessorStatsArray;
    }

    protected ESIProcessor(String string, InputStream inputStream, OutputStream outputStream) throws IOException {
        this._hostName = string;
        this._in = new ESIInputStream(inputStream);
        this._out = new ESIOutputStream(outputStream);
        if (isZOS && this._out == null) {
            Tr.event((TraceComponent)_tc, (String)"ESIProcessor constructor : no ESI OutputStream available.");
            throw new IOException("ESIProcessor constructor : no ESI OutputStream available.");
        }
        this.initPID();
        this._isAlive = true;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("constructed " + this));
        }
    }

    public boolean isAlive() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("is alive: " + this));
        }
        return this._isAlive;
    }

    protected synchronized void markDead() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("mark dead: " + this));
        }
        this._isAlive = false;
        this.notify();
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPID() {
        return this._pid;
    }

    public synchronized void invalidateId(String string) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("invalidateId '" + string + "' in " + this));
        }
        this.writeInt(5);
        this.writeString(string);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("invalidateId '" + string + "' in " + this));
        }
    }

    public synchronized void clearCache() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("clearCache in " + this));
        }
        this.writeInt(4);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("clearCache in " + this));
        }
    }

    public synchronized void resetCounter() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("resetCounter in " + this));
        }
        this.writeInt(3);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("resetCounter in " + this));
        }
    }

    public synchronized void submit(ESIProcessorRequest eSIProcessorRequest) throws IOException {
        this._curRequest = eSIProcessorRequest;
        this.notify();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("submit gather in " + this));
        }
    }

    private synchronized void listen() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("begin listening to " + this));
        }
        while (this._isAlive) {
            if (this._curRequest != null) {
                try {
                    this._curRequest.handle();
                    this._curRequest.markCompleted(null);
                }
                catch (Throwable throwable) {
                    this._curRequest.markCompleted(throwable);
                }
                this._curRequest = null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("end listening to " + this));
        }
    }

    private void initPID() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("initPID from " + this));
        }
        if (!isZOS) {
            this.writeInt(1);
            this.flush();
            this._pid = this.readInt();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("initPID from " + this));
        }
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public int readInt() throws IOException {
        try {
            int n = this._in.readInt();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("readInt " + n));
            }
            return n;
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public String readString() throws IOException {
        try {
            String string = this._in.readUTF();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("readString " + string));
            }
            return string;
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void writeInt(int n) throws IOException {
        try {
            if (!isZOS) {
                this._out.writeInt(n);
            } else {
                String string = new Integer(n).toString();
                this._out.writeUTF(string);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("writeInt " + n));
            }
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void writeString(String string) throws IOException {
        try {
            this._out.writeUTF(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("writeString " + string));
            }
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void flush() throws IOException {
        try {
            this._out.flush();
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public void flushWithResponse() throws IOException {
        try {
            this._in = this._out.flushWithResponse();
        }
        catch (IOException iOException) {
            this.markDead();
            throw iOException;
        }
    }

    public String toString() {
        return this._hostName + "-" + this._pid;
    }
}

