/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class CacheProxyReader
extends BufferedReader {
    boolean canMark = true;

    public CacheProxyReader(Reader reader) {
        super(reader);
    }

    public CacheProxyReader(Reader reader, int n) {
        super(reader, n);
        this.canMark = true;
        try {
            this.mark(n);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.servlet.CacheProxyRequest.CacheProxyReader", "496", this);
            iOException.printStackTrace();
            throw new IllegalStateException("mark must succeed to init CacheProxyReader while computing cacheId: " + iOException.getMessage());
        }
        this.canMark = false;
    }

    protected void setCanMark(boolean bl) {
        this.canMark = bl;
    }

    public void mark(int n) throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("CacheProxyReader does not support mark");
        }
        super.mark(n);
    }

    public boolean markSupported() {
        return this.canMark;
    }

    public void reset() throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("CacheProxyReader does not support mark/reset");
        }
        super.reset();
    }
}

