/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.io.WSByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class CacheProxyOutputStream
extends ServletOutputStream {
    private static TraceComponent tc = Trace.register(CacheProxyOutputStream.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private OutputStream outputStream = null;
    private boolean closed = false;
    private WSByteArrayOutputStream cachingStream = new WSByteArrayOutputStream();
    private boolean caching = false;
    boolean flushrequired = false;
    boolean outputStreamFlushed = false;
    boolean delayWrite = false;
    boolean postDelayCachingValue = false;

    public CacheProxyOutputStream() {
    }

    public CacheProxyOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.closed = false;
        this.flushrequired = false;
    }

    public void reset() {
        this.cachingStream.reset();
        this.caching = false;
        this.outputStream = null;
        this.closed = false;
        this.flushrequired = false;
        this.outputStreamFlushed = false;
        this.delayWrite = false;
        this.postDelayCachingValue = false;
    }

    public void resetBuffer() {
        this.cachingStream.reset();
        this.flushrequired = false;
    }

    public void setCaching(boolean bl) {
        this.caching = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCaching: this=" + (Object)((Object)this) + " caching=" + bl));
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setBufferSize(int n) {
    }

    public void setDelayWrite(boolean bl, boolean bl2) {
        this.delayWrite = bl;
        this.postDelayCachingValue = bl2;
    }

    public byte[] getCachedData() {
        return this.cachingStream.toByteArray();
    }

    public void write(int n) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(n);
        }
        this.outputStream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(byArray);
        }
        this.outputStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(byArray, n, n2);
        }
        this.outputStream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.outputStreamFlushed = true;
        if (this.flushrequired) {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
            this.flushrequired = false;
            if (this.delayWrite & !this.caching) {
                this.caching = this.postDelayCachingValue;
                this.delayWrite = false;
            }
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

