/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.cache.esi.ESIInvalidatorCollector;
import com.ibm.ws.cache.esi.ESIInvalidatorConnection;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.cache.esi.ESIInvalidatorSprayer;
import com.ibm.ws.util.ThreadPool;
import java.util.Enumeration;

public class ESIInvalidatorDriver {
    private static TraceComponent tc = Tr.register((Class)ESIInvalidatorDriver.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static ESIInvalidatorSprayer eips = null;
    protected static StringBuffer resultsBuffer = new StringBuffer();
    private static ThreadPool pool = null;
    private static Thread sprayer = null;
    protected static Thread driver = null;
    protected static boolean waiting = false;
    protected static int selection = 0;
    protected static int notifies = 0;
    protected static int requests = 0;
    protected static int results = 0;

    public ESIInvalidatorDriver() {
        pool = new ThreadPool("ESI Collector", 1, ESIInvalidatorHelper.threads);
        pool.createThreads(ESIInvalidatorHelper.threads);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ESIInvalidatorDriver() : thread pool limit = " + ESIInvalidatorHelper.threads));
        }
    }

    public synchronized String sendCommand() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendCommand() data : " + ESIInvalidator.cmdStr.length() + " / '" + ESIInvalidator.cmdStr + "' / "));
        }
        if (!ESIInvalidator.isUp) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sendCommand() : CR proxy is down");
            }
            return "notok";
        }
        String string = ESIInvalidatorHelper.setShort(1) + "0";
        switch (ESIInvalidator.cmdVal) {
            case 7: {
                ESIInvalidatorHelper.cacheInterval = new Integer(ESIInvalidator.cmdStr.substring(1, ESIInvalidator.cmdStr.length()).trim());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sendCommand() contact. cache interval : " + ESIInvalidatorHelper.cacheInterval));
                }
                if (sprayer == null) {
                    eips = new ESIInvalidatorSprayer();
                    sprayer = new Thread(eips);
                    sprayer.setDaemon(true);
                    sprayer.start();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"sendCommand() contact");
                }
                return "ok";
            }
        }
        if (ESIInvalidator.connections.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("sendCommand() : edge is quiet - nowhere to send command : " + ESIInvalidator.cmdStr));
            }
            return string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendCommand() : sending data " + ESIInvalidator.cmdStr + " to " + ESIInvalidator.connections.size() + " plugins"));
        }
        if (ESIInvalidator.cmdVal != 2) {
            sprayer.interrupt();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sendCommand() : sprayer awoken");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendCommand() : invoking collectors");
        }
        return this.sprayGather();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sprayGather() {
        Object object;
        String string;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sprayGather()");
            }
            string = null;
            selection = new Integer(ESIInvalidator.cmdStr.substring(1, ESIInvalidator.cmdStr.length()).trim());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sprayGather() : gather selection : " + selection));
            }
            object = ESIInvalidator.connections;
            synchronized (object) {
                notifies = ESIInvalidator.connections.size();
                resultsBuffer.setLength(0);
                requests = notifies;
                results = 0;
                driver = Thread.currentThread();
                Enumeration enumeration = ESIInvalidator.connections.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchCollector((ESIInvalidatorConnection)enumeration.nextElement());
                }
            }
            if (notifies > 0) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sprayGather() : waiting " + ESIInvalidatorHelper.timeout + " msecs for gather response from " + notifies + " connections ..."));
                    }
                    waiting = true;
                    this.wait(ESIInvalidatorHelper.timeout);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"sprayGather() : wait for gather response timed out");
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)"sprayGather() : wait interrupted");
                }
            }
        }
        object = driver;
        synchronized (object) {
            waiting = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sprayGather() : wait exited. notifies outstanding : " + notifies + " results returned " + results));
            }
            string = new Integer(results).toString();
            string = ESIInvalidatorHelper.setShort(string.length()) + string + resultsBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sprayGather() : results " + results));
        }
        return string;
    }

    protected void dispatchCollector(ESIInvalidatorConnection eSIInvalidatorConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dispatchCollector() : " + resultsBuffer.length()));
        }
        ESIInvalidatorCollector eSIInvalidatorCollector = new ESIInvalidatorCollector();
        eSIInvalidatorCollector.setConnection(eSIInvalidatorConnection);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dispatchCollector() : pool size / max / grow : " + pool.getPoolSize() + " / " + pool.getMaximumPoolSize() + " / " + pool.isGrowAsNeeded()));
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dispatchCollector() : executing collector");
            }
            pool.execute((Runnable)eSIInvalidatorCollector);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dispatchCollector() : collector executed");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dispatchCollector() : " + resultsBuffer.length()));
        }
    }
}

