/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIIntercept;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.cache.esi.ESIInterceptOutputStream;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ESIInvalidatorConnection
extends ThreadLocal {
    private static TraceComponent tc = Tr.register((Class)ESIInvalidatorConnection.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected boolean isBound = false;
    private byte[] session = null;
    private String plugin = null;
    private String remoteHostName = null;
    private int pid = 0;
    private StringBuffer resultsBuffer = null;
    private ESIInterceptInputStream dis = null;
    private ESIInterceptOutputStream dos = null;
    private byte[] uriBytes = null;

    public Object initialValue() {
        return this;
    }

    protected ESIInvalidatorConnection(byte[] byArray, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("constructor for session " + string));
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("address " + new String(string.getBytes("Cp-037"))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = byArray;
        this.plugin = string;
        this.uriBytes = string2.getBytes();
        int n = this.plugin.indexOf(":");
        this.remoteHostName = this.plugin.substring(0, n);
        if (this.bind()) {
            this.resultsBuffer = new StringBuffer();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(ESIInvalidatorConnection.getThread() + " eipc connection established for plugin " + this.plugin));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("eipc connection not established for plugin " + this.plugin));
            }
            this.unbind();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor for session");
        }
    }

    private boolean bind() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bind() : " + this.plugin));
        }
        boolean bl = false;
        try {
            this.dis = new ESIInterceptInputStream(this.uriBytes);
            this.dos = new ESIInterceptOutputStream(this.session);
            byte[] byArray = new byte[this.dis.available()];
            this.dis.read(byArray, 0, byArray.length);
            String string = new String(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bind() : " + ESIInvalidatorConnection.getThread() + " request received : " + string));
            }
            if (string.indexOf("/_DynaCacheEsi/esiInvalidator") > -1) {
                if (string.indexOf("Expect: 100-Continue") > 0) {
                    this.dos.write(ESIInvalidatorHelper.contbytes, 0, ESIInvalidatorHelper.contbytes.length);
                }
                this.dos.write(ESIInvalidatorHelper.okbytes, 0, ESIInvalidatorHelper.okbytes.length);
                this.dos.flush();
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bind() : connection bound for plugin : " + this.plugin));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bind() : connection received invalid request : " + string));
                }
                this.unbind();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bind() : plugin connection failed : " + exception.toString() + " - attempting cleanup"));
            }
            this.unbind();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bind() : " + ESIInvalidatorConnection.getThread() + " connection established : " + bl));
        }
        this.isBound = bl;
        return bl;
    }

    protected void unbind() {
        block7: {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("unbind() : " + this.plugin));
                }
                this.isBound = false;
                try {
                    ESIInvalidator.connections.remove(this.plugin);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("unbind() : caught exception " + exception + " while removing plugin " + this.plugin));
                }
            }
            try {
                ESIIntercept.ESIFree(this.session);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("unbind() : caught exception " + exception + " while removing plugin " + this.plugin));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unbind()");
        }
    }

    protected int getPid() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPid() " + this.pid));
        }
        return this.pid;
    }

    protected void setPid(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPid() " + n));
        }
        this.pid = n;
    }

    protected DataInputStream getDis() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDis()");
        }
        return this.dis;
    }

    protected DataOutputStream getDos() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDos()");
        }
        return this.dos;
    }

    protected String getPlugin() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPlugin() " + this.plugin));
        }
        return this.plugin;
    }

    protected byte[] getSession() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSession()");
        }
        return this.session;
    }

    protected String getRemoteHostName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRemoteHostName() " + this.remoteHostName));
        }
        return this.remoteHostName;
    }

    private static String getThread() {
        return "(" + Thread.currentThread().getName() + ")";
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }
}

