/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.cache.esi.ESIInterceptOutputStream;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.cache.esi.ESIInvalidatorConnection;
import com.ibm.ws.cache.esi.ESIInvalidatorDriver;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import java.io.IOException;

public class ESIInvalidatorCollector
extends ThreadLocal
implements Runnable {
    private static TraceComponent tc = Tr.register((Class)ESIInvalidatorCollector.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private ESIInvalidatorConnection eipc = null;
    private boolean available = false;

    public Object initialValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run() : collector thread running ...");
        }
        String string = ESIInvalidatorCollector.getThread();
        if (this.eipc == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run() : null eipc set for collector thread " + string));
            }
            return;
        }
        String string2 = this.getConnection().getPlugin();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("run() : collector thread " + string + " awoken for connection " + string2));
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("run() : collector thread " + string + " sending gather to plugin " + string2));
            }
            this.collect((ESIInterceptOutputStream)this.getConnection().getDos());
            ++ESIInvalidatorDriver.results;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("run() ex : collector thread " + string + " broken connection (" + exception.toString() + ") to " + string2));
            }
            this.getConnection().unbind();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("run() ex : collector thread " + string + " after command send failure, plugins connected : " + ESIInvalidator.connections.size()));
            }
        }
        finally {
            this.notifyDriver();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("run() on " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDriver() {
        String string = ESIInvalidatorCollector.getThread();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("notifyDriver() from collector " + this + " on " + string));
        }
        Thread thread = ESIInvalidatorDriver.driver;
        synchronized (thread) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notifyDriver() " + string + " notifies : " + ESIInvalidatorDriver.notifies + " driver waiting : " + ESIInvalidatorDriver.waiting));
            }
            this.available = true;
            if (ESIInvalidatorDriver.waiting) {
                --ESIInvalidatorDriver.notifies;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("notifyDriver() : " + string + " notifies outstanding after this sequence : " + ESIInvalidatorDriver.notifies + ". Driver waiting : " + ESIInvalidatorDriver.waiting));
                }
                if (ESIInvalidatorDriver.notifies == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("notifyDriver() : " + string + " interrupting driver : " + ESIInvalidatorDriver.driver.getName() + " / " + ESIInvalidatorDriver.driver.toString()));
                    }
                    ESIInvalidatorDriver.driver.interrupt();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("notifyDriver() on " + string + " : " + ESIInvalidatorDriver.notifies));
        }
    }

    private void collect(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        this.fetchPid(eSIInterceptOutputStream);
        ESIInterceptInputStream eSIInterceptInputStream = this.sendGather(eSIInterceptOutputStream);
        this.collectStats(eSIInterceptInputStream);
    }

    private void fetchPid(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("fetchPid() " + ESIInvalidatorCollector.getThread() + " "));
        }
        ESIInterceptInputStream eSIInterceptInputStream = ESIInvalidatorHelper.chunkCommand(eSIInterceptOutputStream, 1, true);
        ESIInvalidatorHelper.dechunkResponse(eSIInterceptInputStream);
        this.getConnection().setPid(eSIInterceptInputStream.readInt());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("fetchPid() : " + ESIInvalidatorCollector.getThread() + " " + this.getConnection().getPid()));
        }
    }

    private ESIInterceptInputStream sendGather(ESIInterceptOutputStream eSIInterceptOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendGather() " + ESIInvalidatorCollector.getThread() + " " + ESIInvalidatorDriver.selection));
        }
        eSIInterceptOutputStream.write(ESIInvalidatorHelper.length8);
        eSIInterceptOutputStream.write(ESIInvalidatorHelper.crlfbytes, 0, ESIInvalidatorHelper.crlfbytes.length);
        eSIInterceptOutputStream.writeInt(2);
        eSIInterceptOutputStream.writeInt(ESIInvalidatorDriver.selection);
        eSIInterceptOutputStream.write(ESIInvalidatorHelper.crlfbytes, 0, ESIInvalidatorHelper.crlfbytes.length);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendGather() " + ESIInvalidatorCollector.getThread()));
        }
        return eSIInterceptOutputStream.flushWithResponse();
    }

    private void collectStats(ESIInterceptInputStream eSIInterceptInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("collectStats(" + this.toString() + ") " + ESIInvalidatorCollector.getThread()));
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPlugin();
        String string2 = ESIInvalidatorCollector.getThread();
        int n = 0;
        int n2 = 0;
        stringBuffer.append(ESIInvalidatorHelper.setInt(1));
        stringBuffer.append(ESIInvalidatorHelper.setInt(this.getConnection().getPid()));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + "  setting remotehostname " + this.getConnection().getRemoteHostName() + " for plugin " + string));
        }
        stringBuffer.append(ESIInvalidatorHelper.setShort((short)this.getConnection().getRemoteHostName().length()));
        stringBuffer.append(this.getConnection().getRemoteHostName());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " dechunking response for plugin " + string));
        }
        ESIInvalidatorHelper.dechunkResponse(eSIInterceptInputStream);
        n = eSIInterceptInputStream.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " got responseType " + n));
        }
        if (n != 2) {
            throw new IOException("collectStats() : " + string2 + " did not find start of response");
        }
        stringBuffer.append(ESIInvalidatorHelper.setInt(n));
        block4: while (true) {
            n = eSIInterceptInputStream.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " responseType " + n));
            }
            stringBuffer.append(ESIInvalidatorHelper.setInt(n));
            switch (n) {
                case 12: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " cache entry"));
                    }
                    short s = eSIInterceptInputStream.readShort();
                    stringBuffer.append(ESIInvalidatorHelper.setShort(s));
                    byte[] byArray = new byte[s];
                    eSIInterceptInputStream.read(byArray, 0, byArray.length);
                    String string3 = new String(byArray, "ASCII");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " cache entry received " + new String(string3)));
                    }
                    stringBuffer.append(string3);
                    int n3 = eSIInterceptInputStream.readInt();
                    if (n3 != 6) {
                        throw new IOException("collectStats() : " + string2 + " expecting end of cache entry, instead got " + n3);
                    }
                    stringBuffer.append(ESIInvalidatorHelper.setInt(n3));
                    if (!tc.isDebugEnabled()) continue block4;
                    Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " done cache entry"));
                    continue block4;
                }
                case 6: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " end of gather"));
                    }
                    stringBuffer.append(ESIInvalidatorHelper.setInt(n));
                    break;
                }
                default: {
                    if (n > 0) {
                        n2 = eSIInterceptInputStream.readInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " default received value : " + n2));
                        }
                        stringBuffer.append(ESIInvalidatorHelper.setInt(n2));
                        break;
                    }
                    throw new IOException("collectStats() : " + string2 + " default received something unrecognisable : " + n2);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("collectStats() : " + string2 + " done with response type : " + n));
            }
            if (n == 6) break;
        }
        ESIInvalidatorDriver.resultsBuffer.append(stringBuffer);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("collectStats(" + this.toString() + ") " + string2 + " response length : " + stringBuffer.length()));
        }
    }

    protected void setConnection(ESIInvalidatorConnection eSIInvalidatorConnection) {
        this.available = false;
        this.eipc = eSIInvalidatorConnection;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConnection(" + this.toString() + ") collector"));
        }
    }

    protected ESIInvalidatorConnection getConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getConnection(" + this.toString() + ") collector"));
        }
        return (ESIInvalidatorConnection)this.eipc.get();
    }

    private String getPlugin() {
        return this.getConnection().getPlugin();
    }

    private static String getThread() {
        return "(# " + Thread.currentThread().getName() + ")";
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }
}

