/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.eca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.management.AdminHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ECAOutputStream
extends DataOutputStream {
    private static final TraceComponent tc = Trace.register(ECAOutputStream.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final boolean isZOS = AdminHelper.getPlatformHelper().isZOS();
    private ByteArrayOutputStream bos = null;

    public ECAOutputStream(OutputStream outputStream) {
        super(isZOS ? new ByteArrayOutputStream() : outputStream);
        if (isZOS) {
            this.bos = (ByteArrayOutputStream)this.out;
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush");
        }
        if (this.bos != null) {
            int n = AdminHelper.getPlatformHelper().doECAService(this.bos.toByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flush rc " + n));
            }
            this.bos.reset();
        } else {
            this.out.flush();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush");
        }
    }
}

