/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSBootstrapMsgImpl;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerCacheMsgListener;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerDataXfer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import com.ibm.wsspi.drs.DRSMiscInterface;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class DynacacheDRSControllerInstanceImpl
implements DRSControllerInstance {
    DRSInstanceTokenTable registeredServants;
    DRSServantProxyFactory drsServantProxyFactory;
    DRSControllerDataXfer ddx;
    DynacacheDRSControllerDataXfer dynacacheDDX;
    DRSDataXfer baseDDX;
    DRSSettings drss;
    DynacacheDRSControllerCacheMsgListener dcml;
    DynacacheDRSControllerBootstrap db;
    ArrayList dbmList;
    boolean usingHAManager;
    boolean eventStateReplicationUp;
    boolean eventStateIsCongested;
    boolean addServantAlreadyInvoked;
    boolean alreadyAskedDRSForBootstrap;
    long uniqueInstanceId;
    long instanceId;
    Map miscParms;
    String ddxKey;
    String instanceName;
    String instanceUniqueName;
    String instanceUniqueId;
    boolean isDRSCongested;
    private DRSEventObject isUpEvent;
    private DRSEventObject isNotCongestedEvent;
    private int unAvailableCount;
    private static final int MAX_UNAVAILABLE_ATTEMPTS = 50;
    private Integer drsStateLock;
    private Integer lock;
    private static TraceComponent tc = Tr.register((Class)DynacacheDRSControllerInstanceImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final short DRS_PEER2PEER = 0;

    public DynacacheDRSControllerInstanceImpl(String string, DRSSettings dRSSettings, Map map, boolean bl, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR ddxKey = " + string));
        }
        this.ddxKey = string;
        this.drss = dRSSettings;
        this.miscParms = map;
        this.usingHAManager = bl;
        this.uniqueInstanceId = l;
        this.instanceUniqueId = this.ddxKey + ":" + this.uniqueInstanceId;
        this.isDRSCongested = false;
        this.isUpEvent = new DRSEventObject(1, (Object)this);
        this.isNotCongestedEvent = new DRSEventObject(4, (Object)this);
        this.eventStateReplicationUp = true;
        this.eventStateIsCongested = false;
        this.addServantAlreadyInvoked = false;
        this.alreadyAskedDRSForBootstrap = false;
        this.dbmList = new ArrayList();
        this.lock = new Integer(997);
        this.drsStateLock = new Integer(144);
        this.ddx = null;
        this.baseDDX = null;
        this.dynacacheDDX = null;
        this.db = null;
        this.dcml = null;
        this.drsServantProxyFactory = null;
        this.instanceUniqueName = string + ":" + this.uniqueInstanceId;
        this.registeredServants = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable((String)("DynacacheDRSControllerInstance" + this.instanceUniqueName), (String)"registeredServants");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR ddxKey = " + this.ddxKey));
            Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR DRS Settings = " + this.drss));
            Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR Misc Parms = " + this.miscParms));
            Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR Using HAManager = " + this.usingHAManager));
            Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR Unique Instance Id = " + this.uniqueInstanceId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl() - CTOR ddxKey = " + this.ddxKey + " uniqueInstanceId = " + this.uniqueInstanceId));
        }
    }

    public void initialize() {
        String string = "DynacacheDRSControllerInstanceImpl.initialize/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " - ddxKey = " + this.ddxKey));
        }
        if (this.usingHAManager) {
            this.instanceId = this.ddx.getInstanceId();
            this.instanceName = this.ddx.getInstanceName();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + this.ddxKey + ": not using HAManager"));
            }
            this.instanceId = this.uniqueInstanceId;
            this.instanceName = this.ddxKey;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " instanceId = " + this.instanceId));
            Tr.debug((TraceComponent)tc, (String)(string + " instanceName = " + this.instanceName));
            Tr.debug((TraceComponent)tc, (String)(string + " instanceUniqueName = " + this.instanceUniqueName));
            Tr.debug((TraceComponent)tc, (String)(string + " usingHAManager = " + this.usingHAManager));
            Tr.debug((TraceComponent)tc, (String)(string + " ddxKey = " + this.ddxKey));
            Tr.debug((TraceComponent)tc, (String)(string + " uniqueInstanceId = " + this.uniqueInstanceId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }

    public DRSControllerDataXfer getDRSControllerDataXfer() {
        String string = "DynacacheDRSControllerInstanceImpl.getDRSControllerDataXfer/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "ddx =" + this.ddx));
        }
        return this.ddx;
    }

    public DynacacheDRSControllerDataXfer getDynacacheDRSControllerDataXfer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DynacacheDRSControllerInstanceImpl.getDynacacheDRSControllerDataXfer()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DynacacheDRSControllerInstanceImpl.getDynacacheDRSControllerDataXfer()");
        }
        return this.dynacacheDDX;
    }

    public DRSInstanceTokenTable getDRSInstanceTokenTable() {
        String string = "DynacacheDRSControllerInstanceImpl.getDRSInstanceTokenTable/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + ": number of registeredServants in DRSInstanceTokenTable =" + this.registeredServants.size()));
        }
        return this.registeredServants;
    }

    public ArrayList getWaitingBootStrapResponses() {
        String string = "DynacacheDRSControllerInstanceImpl.getWaitingBootStrapResponses/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + "Returning dbmList = " + this.dbmList));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
        return this.dbmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSaveBootstrapResponse(DRSBootstrapMsg dRSBootstrapMsg) {
        String string = "DynacacheDRSControllerInstanceImpl.shouldSaveBootstrapResponse/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        boolean bl = false;
        if (dRSBootstrapMsg != null) {
            Integer n = this.lock;
            synchronized (n) {
                bl = this.registeredServants.isEmpty();
                if (bl) {
                    this.dbmList.add(dRSBootstrapMsg);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(string + " list size = " + this.dbmList.size()));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit - rc = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServant(DRSInstanceToken dRSInstanceToken, DRSEventObject dRSEventObject) {
        String string = "DynacacheDRSControllerInstanceImpl.addServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " token = " + dRSInstanceToken + " event = " + dRSEventObject));
        }
        DynacacheDRSBootstrapMsgImpl dynacacheDRSBootstrapMsgImpl = new DynacacheDRSBootstrapMsgImpl();
        dynacacheDRSBootstrapMsgImpl._isSolicit = false;
        dynacacheDRSBootstrapMsgImpl.mode = 0;
        dynacacheDRSBootstrapMsgImpl.instanceId = this.getInstanceId();
        dynacacheDRSBootstrapMsgImpl.setBootServantToken(dRSInstanceToken);
        DynacacheDRSBootstrapMsgImpl dynacacheDRSBootstrapMsgImpl2 = dynacacheDRSBootstrapMsgImpl;
        try {
            Integer n = this.lock;
            synchronized (n) {
                if (this.registeredServants.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(string + " servant(" + dRSInstanceToken.getStoken() + " is the first servant to register"));
                    }
                    if (!this.dbmList.isEmpty()) {
                        for (int i = 0; i < this.dbmList.size(); ++i) {
                            DRSBootstrapMsg dRSBootstrapMsg = (DRSBootstrapMsg)this.dbmList.get(i);
                            this.db.sendBootstrapResponseToServant(dRSInstanceToken, dRSBootstrapMsg);
                        }
                        this.dbmList.clear();
                    } else if (this.addServantAlreadyInvoked) {
                        if (this.usingHAManager) {
                            if (this.isDRSAvailable()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(string + ": requesting a bootstrap from DRS."));
                                }
                                ((DRSMiscInterface)this.baseDDX).bootstrapRequestByClientInstance();
                                this.alreadyAskedDRSForBootstrap = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(string + " Cannot bootstrap:  DRS is not available. "));
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(string + " Cannot bootstrap:  not using HAManager. "));
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(string + "registeredServants.size =" + this.registeredServants.size()));
                    }
                    Iterator iterator = this.registeredServants.getIterator();
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        DRSInstanceToken dRSInstanceToken2 = (DRSInstanceToken)iterator.next();
                        try {
                            ++n2;
                            this.db.sendHandleBootstrapRequestToServant(dRSInstanceToken2, dynacacheDRSBootstrapMsgImpl2, false);
                            this.db.sendBootstrapResponseToServant(dRSInstanceToken, dynacacheDRSBootstrapMsgImpl2);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            if (this.registeredServants.size() - n2 != 0 || this.alreadyAskedDRSForBootstrap) continue;
                            if (this.usingHAManager) {
                                if (this.isDRSAvailable()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)(string + ": requesting a bootstrap from DRS."));
                                    }
                                    ((DRSMiscInterface)this.baseDDX).bootstrapRequestByClientInstance();
                                    this.alreadyAskedDRSForBootstrap = true;
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)(string + " Cannot bootstrap from servant with token " + dRSInstanceToken2 + ":  DRS is not available. "));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(string + " Cannot bootstrap from servant with token " + dRSInstanceToken2 + ":  not using HAManager."));
                        }
                    }
                    this.alreadyAskedDRSForBootstrap = false;
                }
                this.registeredServants.addServant(dRSInstanceToken);
                this.dcml.sendEvent(dRSInstanceToken, this.isUpEvent);
                this.dcml.sendEvent(dRSInstanceToken, this.isNotCongestedEvent);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerInstanceImpl.addServant", "338", this);
            Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
        }
        if (!this.addServantAlreadyInvoked) {
            this.addServantAlreadyInvoked = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Token = " + dRSInstanceToken));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServant(DRSInstanceToken dRSInstanceToken) {
        String string = "DynacacheDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " Token = " + dRSInstanceToken));
        }
        Integer n = this.lock;
        synchronized (n) {
            this.registeredServants.deleteServant(dRSInstanceToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServant(String string) {
        String string2 = "DynacacheDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + " Stoken = " + string));
        }
        Integer n = this.lock;
        synchronized (n) {
            this.registeredServants.deleteServant(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + " Exit"));
        }
    }

    public long getInstanceId() {
        String string = "DynacacheDRSControllerInstanceImpl.getInstanceId/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        long l = this.instanceId;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + "instanceId = " + this.instanceId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit. instanceId = " + l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationUp() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSReplicationUp: Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = true;
            this.eventStateIsCongested = false;
        }
        if (!bl) {
            Tr.info((TraceComponent)tc, (String)"DYNA1026I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSReplicationUp: Exit - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationDown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSReplicationDown: Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = false;
            this.eventStateIsCongested = false;
        }
        if (bl) {
            Tr.info((TraceComponent)tc, (String)"DYNA1027I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSReplicationDown: Exit - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSCongested() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSCongested: Entry  - eventStateIsCongested = " + this.eventStateIsCongested));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
            this.eventStateIsCongested = true;
        }
        if (!bl) {
            Tr.info((TraceComponent)tc, (String)"DYNA1028I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSCongested: Exit - eventStateIsCongested = " + this.eventStateIsCongested));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSNotCongested() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSNotCongested: Entry  - eventStateIsCongested = " + this.eventStateIsCongested));
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            this.eventStateIsCongested = false;
        }
        Tr.info((TraceComponent)tc, (String)"DYNA1029I", (Object)this.instanceUniqueName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.setDRSNotCongested: Exit - eventStateIsCongested = " + this.eventStateIsCongested));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSAvailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DynacacheDRSControllerInstanceImpl.isDRSAvailable: Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSAvailable: DRS state - eventStateReplicationUp = " + this.eventStateReplicationUp + " - eventStateIsCongested = " + this.eventStateIsCongested));
            }
            boolean bl2 = bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
            if (!bl && this.usingHAManager) {
                try {
                    ++this.unAvailableCount;
                    if (this.unAvailableCount > 50) {
                        boolean bl3;
                        this.unAvailableCount = 0;
                        if (!this.eventStateReplicationUp) {
                            bl3 = this.baseDDX.isReplicationUp();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSAvailable: replicationUp = " + bl3));
                            }
                            if (bl3) {
                                this.setDRSReplicationUp();
                            }
                        }
                        if (this.eventStateReplicationUp && this.eventStateIsCongested) {
                            bl3 = this.baseDDX.isCongested();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSAvailable: isCongested = " + bl3));
                            }
                            if (!bl3) {
                                this.setDRSNotCongested();
                            }
                        }
                        bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerInstanceImpl.isDRSAvailable", "525", this);
                    Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{"DynacacheDRSControllerInstanceImpl.isDRSAvailable: ", throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSAvailable: Exit - isDRSAvailable = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSUp() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DynacacheDRSControllerInstanceImpl.isDRSUp: Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSUp: Exit - isDRSUp = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSCongested() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DynacacheDRSControllerInstanceImpl.isDRSCongested: Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DynacacheDRSControllerInstanceImpl.isDRSCongested: Exit - isDRSCongested = " + bl));
        }
        return bl;
    }
}

