/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.drs.DRSPushPullTable;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSAnnounceRenounceListener;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSJvmId;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;

public class DRSMessageListener
implements DRSCacheMsgListener,
DRSAnnounceRenounceListener {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static final boolean IS_UNIT_TEST = false;
    private Monitor monitor = null;
    private static CacheUnit cacheUnit;
    private String cacheName = null;
    private Cache cache = null;
    private boolean isDRSCongested = false;
    private boolean isDRSReady = false;
    private DRSPushPullTable pushPullTable = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isDRSReady() {
        return this.isDRSReady;
    }

    public boolean isDRSCongested() {
        return this.isDRSCongested;
    }

    private DRSMessageListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSMessageListener(CacheUnit cacheUnit, Cache cache) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DRSMessageListener() - CTOR cacheName=" + (cache != null ? cache.getCacheName() : "null")));
        }
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cacheUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache.getCacheName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            if (DRSMessageListener.cacheUnit != null) {
                if (DRSMessageListener.cacheUnit != cacheUnit) {
                    throw new AssertionError();
                }
            }
        }
        CacheUnit cacheUnit2 = DRSMessageListener.cacheUnit != null ? DRSMessageListener.cacheUnit : cacheUnit;
        synchronized (cacheUnit2) {
            this.cache = cache;
            DRSMessageListener.cacheUnit = cacheUnit;
            this.cacheName = cache.getCacheName();
        }
        this.pushPullTable = new DRSPushPullTable(this.cacheName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DRSMessageListener() - CTOR " + this));
        }
    }

    public void event(DRSEventObject dRSEventObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"event()");
        }
        int n = dRSEventObject.getEvent();
        switch (n) {
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("event() cacheName=" + this.cacheName + " event=IS_CONGESTED"));
                }
                this.isDRSCongested = true;
                break;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("event() cacheName=" + this.cacheName + " event=NOT_CONGESTED"));
                }
                this.isDRSCongested = false;
                this.cache.setDRSDisabled(false);
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("event() cacheName=" + this.cacheName + " event=REPLICATION_DOWN"));
                }
                this.isDRSReady = false;
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("event() cacheName=" + this.cacheName + " event=REPLICATION_UP"));
                }
                this.isDRSReady = true;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown DRS Event");
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("event() " + this));
        }
    }

    public void processDRSCacheMsgEvent(EventObject eventObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processDRSCacheMsgEvent() event=" + eventObject));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void createEntry(Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntry() cacheName=" + this.cacheName + " entryKey=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void createEntryProp(Object object, Object object2, Object object3) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntryProp() cacheName=" + this.cacheName + " entryKey=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateEntry(Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateEntry cacheName=" + this.cacheName + " entryKey=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateEntryProp(Object object, Object object2, Object object3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2));
        }
        long l = System.currentTimeMillis();
        Short s = (Short)object2;
        short s2 = s;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateEntryProp() - operation key " + s2));
        }
        switch (s2) {
            case 13: {
                CacheEntry cacheEntry = (CacheEntry)object3;
                cacheEntry.processDrsInbound(l);
                cacheUnit.setEntry(this.cacheName, cacheEntry);
                break;
            }
            case 1: {
                Externalizable externalizable;
                Object object4;
                HashMap hashMap = (HashMap)object3;
                String string = (String)hashMap.get(DRSNotificationService.cacheIdObj);
                HashMap hashMap2 = (HashMap)hashMap.get(DRSNotificationService.invaIDsObj);
                HashMap hashMap3 = (HashMap)hashMap.get(DRSNotificationService.invalTemplsObj);
                ArrayList arrayList = (ArrayList)hashMap.get(DRSNotificationService.pushesObj);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateEntryProp() pushEntryEvents " + arrayList));
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    if (!$assertionsDisabled && !(object4 instanceof CacheEntry)) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && ((CacheEntry)object4).getSharingPolicy() != 2) {
                        throw new AssertionError();
                    }
                    ((CacheEntry)object4).processDrsInbound(l);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateEntryProp() invalidateIdEvents " + hashMap2));
                }
                object4 = hashMap2.values().iterator();
                while (object4.hasNext()) {
                    externalizable = (InvalidateByIdEvent)object4.next();
                    ((InvalidateByIdEvent)externalizable).source = 2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateEntryProp() invalidateTemplateEvents " + hashMap3));
                }
                object4 = hashMap3.values().iterator();
                while (object4.hasNext()) {
                    externalizable = (InvalidateByTemplateEvent)object4.next();
                    ((InvalidateByTemplateEvent)externalizable).source = 2;
                    if (!((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()) continue;
                    this.clearPushPullTable();
                }
                cacheUnit.batchUpdate(string, hashMap2, hashMap3, arrayList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateEntryProp() " + this));
        }
    }

    public Object getEntry(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntry() cacheName=" + this.cacheName + " entryKey=" + object));
        }
        Object object2 = ((IdObject)object).getId();
        CacheEntry cacheEntry = null;
        boolean bl = false;
        cacheEntry = cacheUnit.getEntry(this.cacheName, object2, bl);
        if (cacheEntry != null) {
            cacheEntry.finish();
        }
        if (cacheEntry != null && !cacheEntry.prepareForSerialization()) {
            cacheEntry = null;
        }
        if (cacheEntry != null) {
            cacheEntry.processDrsOutbound();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEntry() cacheEntry=" + cacheEntry + "id=" + (cacheEntry != null ? cacheEntry.id : "null") + " " + this));
        }
        return cacheEntry;
    }

    public Object getEntryProp(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void removeEntry(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeEntry() entryKey=" + object));
        }
    }

    public void clearPushPullTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("clearPushPullTable()before clear - PushPullTableSize=" + this.pushPullTable.size()));
        }
        this.pushPullTable.clear();
    }

    public void removeEntryProp(Object object, Object object2, Object object3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean entryIDExists(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("entryIDExists() cacheName=" + this.cacheName + " entryKey=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    public boolean propIDExists(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("propIDExists() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    public void asyncAck(DRSCacheMsg dRSCacheMsg, DRSCacheMsg dRSCacheMsg2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("asyncAck() cacheName=" + this.cacheName + " DRSCacheMsg in " + dRSCacheMsg + " out=" + dRSCacheMsg2));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void nowThePrimary(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("nowThePrimary() cacheName=" + this.cacheName + " partitionId" + l));
        }
    }

    public void nowThePrimary(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("nowThePrimary() cacheName=" + this.cacheName + " Identity" + identity));
        }
    }

    public Object processQueryRequest(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processQueryRequest() cacheName=" + this.cacheName + " key=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void queryResp(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("queryResp() cacheName=" + this.cacheName + " resp=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void response(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("response() cacheName=" + this.cacheName + " response=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public Object broadcast(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("broadcast() cacheName=" + this.cacheName + " key=" + object));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void announceEntries(ArrayList arrayList, DRSJvmId dRSJvmId) {
        this.pushPullTable.announceEntries(arrayList, dRSJvmId);
    }

    public void renounceEntries(ArrayList arrayList) {
        this.pushPullTable.renounceEntries(arrayList);
    }

    public Object getEntry(Object object, DRSJvmId dRSJvmId) {
        return this.getEntry(object);
    }

    public DRSPushPullTable getPushPullTable() {
        return this.pushPullTable;
    }

    static {
        $assertionsDisabled = !DRSMessageListener.class.desiredAssertionStatus();
        tc = Trace.register(DRSMessageListener.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        cacheUnit = null;
    }
}

