/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheHandler;
import com.ibm.ws.cache.config.CacheInstance;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigErrorHandler;
import com.ibm.ws.cache.config.ConfigFileEntry;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.cache.servlet.ServletCacheEngine;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.xml.ParserFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ConfigManager
implements AlarmListener {
    private static TraceComponent tc = Trace.register(ConfigManager.class, "WebSphere Cache", "com.ibm.ws.cache.resources.dynacache");
    static final String CACHE_SPEC = "cachespec.xml";
    static final String CACHE_SPEC_DTD = "cachespec.dtd";
    static String propertiesDir = "";
    private SAXParser jaxpParser = null;
    private ArrayList globalCacheInstances = new ArrayList();
    private ArrayList globalCacheEntries = new ArrayList();
    private ArrayList legacyCacheEntries = new ArrayList();
    private ArrayList configListeners = new ArrayList();
    private HashMap cacheEntries = new HashMap();
    private HashMap configFiles = new HashMap();
    private HashMap potentialConfigFiles = new HashMap();
    private HashMap EJBConfigFiles = new HashMap();
    private int counter = 0;
    private int reloadInterval = -1;
    private HashMap entryCache = new HashMap();
    private MultiProcessorPool processorPool = new MultiProcessorPool();
    private HashMap jaxRpcClientConfigEntries = new HashMap(1);
    private HashMap servletEntryCache = new HashMap();
    private static ConfigManager instance = new ConfigManager();

    public static ConfigManager getInstance() {
        return instance;
    }

    protected ConfigManager() {
    }

    public synchronized void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.add(configChangeListener);
    }

    public synchronized void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.remove(configChangeListener);
    }

    public synchronized void fireChangedEvent() {
        int n = this.configListeners.size();
        for (int i = 0; i < n; ++i) {
            ((ConfigChangeListener)this.configListeners.get(i)).configChanged();
        }
    }

    public void setReloadInterval(int n) {
        if (this.reloadInterval == -1) {
            this.reloadInterval = n;
            AlarmManager.create((long)n, (AlarmListener)this, null);
        }
    }

    public static void setPropertiesDirectory(String string) {
        propertiesDir = string;
        if (!propertiesDir.endsWith(File.separator)) {
            propertiesDir = propertiesDir + File.separator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        ++this.counter;
        HashMap hashMap = this.configFiles;
        synchronized (hashMap) {
            this.checkConfig();
        }
        if (this.counter == 6) {
            hashMap = this.potentialConfigFiles;
            synchronized (hashMap) {
                this.checkPotentialConfig();
            }
            hashMap = this.EJBConfigFiles;
            synchronized (hashMap) {
                this.checkEJBJarConfig();
            }
            this.counter = 0;
        }
        AlarmManager.create((long)this.reloadInterval, (AlarmListener)this, null);
    }

    protected void checkConfig() {
        Iterator iterator = this.configFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            try {
                if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) continue;
                if (configFileEntry.configFile.exists()) {
                    if (this.loadConfig(configFileEntry.fileName, configFileEntry.isWarFile, configFileEntry.isModule, configFileEntry.appName, configFileEntry.appContext)) continue;
                    iterator.remove();
                    continue;
                }
                this.potentialConfigFiles.put(configFileEntry.fileName, configFileEntry);
                iterator.remove();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                iterator.remove();
            }
        }
    }

    protected void checkPotentialConfig() {
        Iterator iterator = this.potentialConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            if (!configFileEntry.configFile.exists()) continue;
            this.configFiles.put(configFileEntry.fileName, configFileEntry);
            iterator.remove();
            try {
                if (this.loadConfig(configFileEntry.fileName, configFileEntry.isWarFile, configFileEntry.isModule, configFileEntry.appName, configFileEntry.appContext)) continue;
                this.configFiles.remove(configFileEntry.fileName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                this.configFiles.remove(configFileEntry.fileName);
            }
        }
    }

    protected void checkEJBJarConfig() {
        Iterator iterator = this.EJBConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            try {
                if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) continue;
                if (configFileEntry.configFile.exists()) {
                    this.loadEJBJarConfig(configFileEntry.fileName, configFileEntry.appName, configFileEntry.appContext);
                    continue;
                }
                iterator.remove();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                iterator.remove();
            }
        }
    }

    public void addLegacyCacheEntry(ConfigEntry configEntry) {
        if (this.preProcessEntry(configEntry)) {
            this.globalCacheEntries.add(configEntry);
            this.legacyCacheEntries.add(configEntry);
            if (configEntry != null) {
                Iterator iterator = configEntry.allNames.iterator();
                while (iterator.hasNext()) {
                    String string;
                    ConfigEntry configEntry2 = (ConfigEntry)configEntry.clone();
                    configEntry2.name = string = (String)iterator.next();
                    this.servletEntryCache.put(string, configEntry2);
                }
            }
        }
    }

    public ConfigEntry getJaxRpcConfigEntry(String string) {
        return (ConfigEntry)this.jaxRpcClientConfigEntries.get(string);
    }

    public ConfigEntry getServletCacheEntry(Object object, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getServletCacheEntry()" + string + " " + string2));
        }
        Class<?> clazz = object.getClass();
        String string3 = clazz.getName() + ".class";
        ConfigEntry configEntry = null;
        if (string != null) {
            configEntry = (ConfigEntry)this.servletEntryCache.get(string);
        }
        if (configEntry == null) {
            String string4 = string2 == null ? string3 : string2 + "/" + string3;
            configEntry = (ConfigEntry)this.servletEntryCache.get(string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("using config entry: " + configEntry));
        }
        return configEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getCacheEntry(Object object, String string, String string2) {
        Class<?> clazz;
        String string3;
        ConfigEntry configEntry;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry()" + string + " " + string2));
        }
        if ((configEntry = (ConfigEntry)this.entryCache.get(string3 = (clazz = object.getClass()).getName() + (string != null ? string : "null") + (string2 != null ? string2 : "null"))) == null) {
            String string4;
            String string5 = clazz.getName() + ".class";
            String string6 = string4 = string2 == null ? string5 : string2 + "/" + string5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 1of2" + string));
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 2of2" + string4));
            }
            for (int i = 0; i < this.globalCacheEntries.size() && configEntry == null; ++i) {
                ConfigEntry configEntry2 = (ConfigEntry)this.globalCacheEntries.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking " + configEntry2.className + " " + configEntry2.name + ": " + configEntry2.allNames));
                }
                if (!configEntry2.allNames.contains(string) && !configEntry2.allNames.contains(string4)) continue;
                configEntry = (ConfigEntry)configEntry2.clone();
                HashMap hashMap = this.entryCache;
                synchronized (hashMap) {
                    this.entryCache.put(string3, configEntry);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Config Entry cached using key " + string3));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using config entry: " + configEntry));
            }
        }
        return configEntry;
    }

    public ConfigEntry getCacheEntry(Object object, String string) {
        return this.getCacheEntry(object, string, null);
    }

    public CacheProcessor getCacheProcessor(ConfigEntry configEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCacheProcessor");
        }
        if (configEntry == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("iClassName = " + configEntry.iClassName));
        }
        CacheProcessor cacheProcessor = (CacheProcessor)this.processorPool.pools[configEntry.iClassName].remove();
        cacheProcessor.reset(configEntry);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCacheProcessor: " + cacheProcessor));
        }
        return cacheProcessor;
    }

    public void returnCacheProcessor(CacheProcessor cacheProcessor) {
        this.processorPool.pools[cacheProcessor.configEntry.iClassName].add(cacheProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadConfig(String string, boolean bl, boolean bl2, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadConfig()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loading cache config file from: " + string + "isWarFile=" + bl + " isModule=" + bl2 + " appName=" + string2));
        }
        String string3 = string;
        File file = new File(string);
        if (file.isDirectory()) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string3 = bl ? string + "WEB-INF/cachespec.xml" : string + "META-INF/cachespec.xml";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("325 - fileName=" + string));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("327 - configFileName=" + string3));
        }
        HashMap hashMap2 = this.configFiles;
        synchronized (hashMap2) {
            HashMap hashMap3 = this.potentialConfigFiles;
            synchronized (hashMap3) {
                block31: {
                    ConfigFileEntry configFileEntry = (ConfigFileEntry)this.configFiles.get(string);
                    if (configFileEntry == null) {
                        configFileEntry = (ConfigFileEntry)this.potentialConfigFiles.get(string);
                    }
                    if (configFileEntry == null) {
                        configFileEntry = new ConfigFileEntry();
                        configFileEntry.configFile = new File(string3);
                        configFileEntry.fileName = string;
                        configFileEntry.lastModified = 0L;
                        configFileEntry.isModule = bl2;
                        configFileEntry.isJarFile = file.isFile() && bl2;
                        configFileEntry.isWarFile = bl;
                        configFileEntry.appContext = hashMap;
                        if (!configFileEntry.configFile.exists()) {
                            this.potentialConfigFiles.put(string, configFileEntry);
                            return false;
                        }
                        this.configFiles.put(string, configFileEntry);
                    }
                    if (!configFileEntry.configFile.exists()) {
                        this.potentialConfigFiles.put(string, configFileEntry);
                        this.configFiles.remove(string);
                        return false;
                    }
                    if (this.potentialConfigFiles.get(string) != null) {
                        this.configFiles.put(string, configFileEntry);
                        this.potentialConfigFiles.remove(string);
                    }
                    if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) return true;
                    configFileEntry.lastModified = configFileEntry.configFile.lastModified();
                    CacheHandler cacheHandler = new CacheHandler(string2, hashMap);
                    try {
                        try {
                            XMLReader xMLReader = null;
                            if (this.jaxpParser == null) {
                                this.jaxpParser = this.newSAXParser();
                            }
                            xMLReader = this.jaxpParser.getXMLReader();
                            try {
                                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "250", this);
                            }
                            RuleHandler ruleHandler = new RuleHandler();
                            ruleHandler.addRule("cache", cacheHandler);
                            xMLReader.setContentHandler(ruleHandler);
                            xMLReader.setErrorHandler(new ConfigErrorHandler(string3));
                            xMLReader.setEntityResolver(new CacheSpecEntityResolver());
                            cacheHandler.setFilename(string3);
                            xMLReader.parse(string3);
                            this.updateCacheInstances(configFileEntry, cacheHandler, string3);
                            this.updateEntries(configFileEntry, cacheHandler, string3);
                        }
                        catch (SAXParseException sAXParseException) {
                            FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "295", this);
                            String string4 = sAXParseException.getMessage();
                            String string5 = Integer.toString(sAXParseException.getLineNumber());
                            String string6 = Integer.toString(sAXParseException.getColumnNumber());
                            Tr.error((TraceComponent)tc, (String)"DYNA0045E", (Object)new Object[]{string4, string, string5, string6});
                            Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string + " (" + string3 + ")"});
                            System.out.println("SAXParseException loading cache entries from " + string + " (" + string3 + ")" + ": " + sAXParseException.getMessage() + " at line " + string5 + " coloumn " + string6);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)sAXParseException);
                            }
                            Object var17_22 = null;
                            if (!tc.isEntryEnabled()) return true;
                            Tr.exit((TraceComponent)tc, (String)("loadConfig()  fileName=" + string + " configFileName=" + string3));
                            break block31;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "303", this);
                            Tr.error((TraceComponent)tc, (String)"DYNA0046E", (Object)new Object[]{iOException.getMessage(), string});
                            Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string + " (" + string3 + ")"});
                            System.out.println("IOException loading cache entries from " + string + " (" + string3 + ")" + ": " + iOException.getMessage());
                            ArrayList arrayList = cacheHandler.getEntries();
                            if (arrayList != null) {
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                    System.out.println("configEntry:" + configEntry.toString());
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)iOException);
                            }
                            Object var17_23 = null;
                            if (!tc.isEntryEnabled()) return true;
                            Tr.exit((TraceComponent)tc, (String)("loadConfig()  fileName=" + string + " configFileName=" + string3));
                            break block31;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "308", this);
                            Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string + " (" + string3 + ")"});
                            System.out.println("Exception loading cache entries from " + string + " (" + string3 + ")" + ": " + exception.getMessage());
                            ArrayList arrayList = cacheHandler.getEntries();
                            if (arrayList != null) {
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                    System.out.println("configEntry:" + configEntry.toString());
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)exception);
                            }
                            Object var17_24 = null;
                            if (!tc.isEntryEnabled()) return true;
                            Tr.exit((TraceComponent)tc, (String)("loadConfig()  fileName=" + string + " configFileName=" + string3));
                            break block31;
                        }
                        Object var17_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_25 = null;
                        if (!tc.isEntryEnabled()) throw throwable;
                        Tr.exit((TraceComponent)tc, (String)("loadConfig()  fileName=" + string + " configFileName=" + string3));
                        throw throwable;
                    }
                    if (!tc.isEntryEnabled()) return true;
                    Tr.exit((TraceComponent)tc, (String)("loadConfig()  fileName=" + string + " configFileName=" + string3));
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadEJBJarConfig(String string, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadEJBJarConfig");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loading cache config file from: " + string + " appName=" + string2));
        }
        HashMap hashMap2 = this.EJBConfigFiles;
        synchronized (hashMap2) {
            block26: {
                block25: {
                    boolean bl;
                    block24: {
                        ConfigFileEntry configFileEntry = (ConfigFileEntry)this.EJBConfigFiles.get(string);
                        if (configFileEntry == null) {
                            configFileEntry = new ConfigFileEntry();
                            configFileEntry.configFile = new File(string);
                            configFileEntry.fileName = string;
                            configFileEntry.lastModified = 0L;
                            configFileEntry.isModule = true;
                            configFileEntry.isJarFile = true;
                            configFileEntry.isWarFile = false;
                            configFileEntry.appContext = hashMap;
                            this.EJBConfigFiles.put(string, configFileEntry);
                        }
                        if (configFileEntry.configFile.isDirectory()) {
                            this.EJBConfigFiles.remove(string);
                            return false;
                        }
                        if (!configFileEntry.configFile.exists()) {
                            this.EJBConfigFiles.remove(string);
                            return false;
                        }
                        if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) return true;
                        configFileEntry.lastModified = configFileEntry.configFile.lastModified();
                        CacheHandler cacheHandler = new CacheHandler(string2, hashMap);
                        try {
                            try {
                                XMLReader xMLReader = null;
                                if (this.jaxpParser == null) {
                                    this.jaxpParser = this.newSAXParser();
                                }
                                xMLReader = this.jaxpParser.getXMLReader();
                                try {
                                    xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "250", this);
                                }
                                RuleHandler ruleHandler = new RuleHandler();
                                ruleHandler.addRule("cache", cacheHandler);
                                xMLReader.setContentHandler(ruleHandler);
                                xMLReader.setErrorHandler(new ConfigErrorHandler(string));
                                xMLReader.setEntityResolver(new CacheSpecEntityResolver());
                                ZipFile zipFile = new ZipFile(string);
                                ZipEntry zipEntry = zipFile.getEntry(configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml");
                                if (zipEntry == null) {
                                    zipFile.close();
                                    bl = false;
                                    Object var13_26 = null;
                                    break block24;
                                }
                                cacheHandler.setFilename(configFileEntry.fileName + (configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml"));
                                InputStream inputStream = zipFile.getInputStream(zipEntry);
                                xMLReader.parse(new InputSource(inputStream));
                                inputStream.close();
                                zipFile.close();
                                this.updateCacheInstances(configFileEntry, cacheHandler, string);
                                this.updateEntries(configFileEntry, cacheHandler, string);
                                break block25;
                            }
                            catch (SAXParseException sAXParseException) {
                                FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "295", this);
                                String string3 = sAXParseException.getMessage();
                                String string4 = Integer.toString(sAXParseException.getLineNumber());
                                String string5 = Integer.toString(sAXParseException.getColumnNumber());
                                Tr.error((TraceComponent)tc, (String)"DYNA0045E", (Object)new Object[]{string3, string, string4, string5});
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                System.out.println("SAXParseException loading cache entries from " + string + ": " + sAXParseException.getMessage() + " at line " + string4 + " coloumn " + string5);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)sAXParseException);
                                }
                                Object var13_28 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
                                break block26;
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "303", this);
                                Tr.error((TraceComponent)tc, (String)"DYNA0046E", (Object)new Object[]{iOException.getMessage(), string});
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                System.out.println("IOException loading cache entries from " + string + ": " + iOException.getMessage());
                                ArrayList arrayList = cacheHandler.getEntries();
                                if (arrayList != null) {
                                    Iterator iterator = arrayList.iterator();
                                    while (iterator.hasNext()) {
                                        ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                        System.out.println("configEntry:" + configEntry.toString());
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)iOException);
                                }
                                Object var13_29 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
                                break block26;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "308", this);
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                System.out.println("Exception loading cache entries from " + string + ": " + exception.getMessage());
                                ArrayList arrayList = cacheHandler.getEntries();
                                if (arrayList != null) {
                                    Iterator iterator = arrayList.iterator();
                                    while (iterator.hasNext()) {
                                        ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                        System.out.println("configEntry:" + configEntry.toString());
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)exception);
                                }
                                Object var13_30 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_31 = null;
                            if (!tc.isEntryEnabled()) throw throwable;
                            Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
                            throw throwable;
                        }
                    }
                    if (!tc.isEntryEnabled()) return bl;
                    Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
                    return bl;
                }
                Object var13_27 = null;
                if (!tc.isEntryEnabled()) return true;
                Tr.exit((TraceComponent)tc, (String)"loadEJBJarConfig");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(ConfigFileEntry configFileEntry, CacheHandler cacheHandler, String string) {
        Object object;
        Object object2;
        configFileEntry.configEntries = cacheHandler.getEntries();
        Iterator<Object> iterator = configFileEntry.configEntries.iterator();
        while (iterator.hasNext()) {
            object2 = (ConfigEntry)iterator.next();
            if (!this.preProcessEntry((ConfigEntry)object2)) {
                iterator.remove();
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cache policy:" + object2));
            }
            try {
                if (!((ConfigEntry)object2).className.equalsIgnoreCase("static") && !((ConfigEntry)object2).name.endsWith("com.ibm.ws.webcontainer.servlet.SimpleFileServlet.class")) continue;
                object = null;
                if (configFileEntry.appContext != null && (object = (String)configFileEntry.appContext.get("servlet")) != null) {
                    if (((String)object).endsWith("/") && ((String)object).length() > 2) {
                        object = ((String)object).substring(0, ((String)object).length() - 2);
                    }
                    ServletCacheEngine.addStaticContentPolicy((String)object);
                }
                if (object != null) continue;
                int n = ((ConfigEntry)object2).name.indexOf("/", 1);
                if (n == -1) {
                    ServletCacheEngine.addStaticContentPolicy("/");
                    continue;
                }
                object = ((ConfigEntry)object2).name.substring(0, n);
                if (!((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
                ServletCacheEngine.addStaticContentPolicy((String)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
            }
        }
        object2 = new ArrayList();
        iterator = this.configFiles.values().iterator();
        while (iterator.hasNext()) {
            object = (ConfigFileEntry)iterator.next();
            if (((ConfigFileEntry)object).configEntries == null) continue;
            ((ArrayList)object2).addAll(((ConfigFileEntry)object).configEntries);
        }
        iterator = this.EJBConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            object = (ConfigFileEntry)iterator.next();
            if (((ConfigFileEntry)object).configEntries == null) continue;
            ((ArrayList)object2).addAll(((ConfigFileEntry)object).configEntries);
        }
        ((ArrayList)object2).addAll(this.legacyCacheEntries);
        object = null;
        HashMap<String, ConfigEntry> hashMap = null;
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            String string2;
            ConfigEntry configEntry;
            ConfigEntry configEntry2 = (ConfigEntry)((ArrayList)object2).get(i);
            if (configEntry2.iClassName == 4) {
                if (object == null) {
                    object = new HashMap(10);
                }
                if (configEntry2 == null) continue;
                iterator = configEntry2.allNames.iterator();
                while (iterator.hasNext()) {
                    configEntry = (ConfigEntry)configEntry2.clone();
                    configEntry.name = string2 = (String)iterator.next();
                    ((HashMap)object).put(string2, configEntry);
                }
                continue;
            }
            if (configEntry2.iClassName != 1 && configEntry2.iClassName != 3 && configEntry2.iClassName != 5) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, ConfigEntry>();
            }
            if (configEntry2 == null) continue;
            iterator = configEntry2.allNames.iterator();
            while (iterator.hasNext()) {
                configEntry = (ConfigEntry)configEntry2.clone();
                configEntry.name = string2 = (String)iterator.next();
                hashMap.put(string2, configEntry);
            }
        }
        if (object == null) {
            this.jaxRpcClientConfigEntries.clear();
        } else {
            this.jaxRpcClientConfigEntries = object;
        }
        if (hashMap == null) {
            this.servletEntryCache.clear();
        } else {
            this.servletEntryCache = hashMap;
        }
        this.globalCacheEntries = object2;
        HashMap hashMap2 = this.entryCache;
        synchronized (hashMap2) {
            this.entryCache.clear();
        }
        this.fireChangedEvent();
        Tr.info((TraceComponent)tc, (String)"DYNA0047I", (Object)new Object[]{string});
    }

    private void updateCacheInstances(ConfigFileEntry configFileEntry, CacheHandler cacheHandler, String string) {
        ConfigFileEntry configFileEntry2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateCacheInstance");
        }
        configFileEntry.cacheInstances = cacheHandler.getInstances();
        Iterator<Object> iterator = configFileEntry.cacheInstances.iterator();
        while (iterator.hasNext()) {
            object = (CacheInstance)iterator.next();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("cache instance:" + object));
        }
        object = new ArrayList();
        iterator = this.configFiles.values().iterator();
        while (iterator.hasNext()) {
            configFileEntry2 = (ConfigFileEntry)iterator.next();
            if (configFileEntry2.cacheInstances == null) continue;
            ((ArrayList)object).addAll(configFileEntry2.cacheInstances);
        }
        iterator = this.EJBConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            configFileEntry2 = (ConfigFileEntry)iterator.next();
            if (configFileEntry2.cacheInstances == null) continue;
            ((ArrayList)object).addAll(configFileEntry2.cacheInstances);
        }
        this.globalCacheInstances = object;
        this.fireChangedEvent();
        Tr.info((TraceComponent)tc, (String)"DYNA0047I", (Object)new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateCacheInstance");
        }
    }

    public ArrayList getCacheInstances() {
        return this.globalCacheInstances;
    }

    public ArrayList getEntries() {
        return this.globalCacheEntries;
    }

    public ArrayList getCacheEntries(String string) {
        ArrayList<ConfigEntry> arrayList = new ArrayList<ConfigEntry>();
        Iterator iterator = this.globalCacheEntries.iterator();
        if (string == null) {
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                if (configEntry.instanceName != null) continue;
                arrayList.add(configEntry);
            }
        } else {
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                if (configEntry.instanceName == null || !configEntry.instanceName.equals(string)) continue;
                arrayList.add(configEntry);
            }
        }
        return arrayList;
    }

    protected boolean preProcessEntry(ConfigEntry configEntry) {
        boolean bl = true;
        if (configEntry.className.equalsIgnoreCase("servlet")) {
            configEntry.iClassName = 1;
        } else if (configEntry.className.equalsIgnoreCase("command")) {
            configEntry.iClassName = 2;
        } else if (configEntry.className.equalsIgnoreCase("webservice")) {
            configEntry.iClassName = 3;
        } else if (configEntry.className.equalsIgnoreCase("JAXRPCClient")) {
            configEntry.iClassName = 4;
        } else if (configEntry.className.equalsIgnoreCase("static")) {
            configEntry.iClassName = 5;
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object)new Object[]{configEntry.className, "class"});
            bl = false;
        }
        if (bl) {
            CacheProcessor cacheProcessor = this.getCacheProcessor(configEntry);
            bl = cacheProcessor.preProcess(configEntry);
            this.returnCacheProcessor(cacheProcessor);
        }
        return bl;
    }

    private SAXParser newSAXParser() {
        SAXParser sAXParser;
        block7: {
            SAXParserFactory sAXParserFactory = null;
            sAXParser = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ConfigManager.newSAXParser()");
            }
            try {
                sAXParserFactory = ParserFactory.newSAXParserFactory();
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "314", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ConfigManager: ParserConfigurationException in newSAXParser()");
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                FFDCFilter.processException((Throwable)sAXNotRecognizedException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "317", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ConfigManager: SAXNotRecognizedException in newSAXParser()");
                }
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "320", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"ConfigManager: SAXException in newSAXParser()");
            }
        }
        return sAXParser;
    }

    static class MultiProcessorPool {
        CacheProcessorPool[] pools = new CacheProcessorPool[16];

        MultiProcessorPool() {
            this.addPool(1, "com.ibm.ws.cache.servlet.FragmentCacheProcessor");
            this.addPool(5, "com.ibm.ws.cache.servlet.FragmentCacheProcessor");
            this.addPool(3, "com.ibm.ws.cache.servlet.WebServicesCacheProcessor");
            this.addPool(4, "com.ibm.ws.cache.webservices.client.JAXRPCCacheProcessor");
            this.addPool(2, "com.ibm.ws.cache.command.CommandCacheProcessor");
        }

        public void addPool(int n, String string) {
            try {
                this.pools[n] = new CacheProcessorPool(100, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.MultiProcessorPool", "402", this);
            }
        }
    }

    static class CacheProcessorPool
    extends ObjectPool {
        Class myClass;

        public CacheProcessorPool(int n, String string) {
            super("CommandCacheProcessorPool", n);
            try {
                this.myClass = (class$com$ibm$ws$cache$config$ConfigManager == null ? (class$com$ibm$ws$cache$config$ConfigManager = ConfigManager.class$("com.ibm.ws.cache.config.ConfigManager")) : class$com$ibm$ws$cache$config$ConfigManager).getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "378", (Object)this);
            }
        }

        protected Object createObject() {
            try {
                return this.myClass.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "382", (Object)this);
                return null;
            }
        }

        public boolean add(CacheProcessor cacheProcessor) {
            cacheProcessor.reset(null);
            return super.add((Object)cacheProcessor);
        }
    }

    static class CacheSpecEntityResolver
    implements EntityResolver {
        CacheSpecEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            try {
                String string3 = propertiesDir + ConfigManager.CACHE_SPEC_DTD;
                return new InputSource(new FileReader(string3));
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.resolveEntity", "332", this);
                return null;
            }
        }
    }
}

