/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ConfigEntry {
    private static TraceComponent tc = Trace.register(ConfigEntry.class, "WebSphere Cache", "com.ibm.ws.cache.resources.dynacache");
    public String className;
    public String name;
    public String instanceName;
    public HashSet allNames;
    public int sharingPolicy = 1;
    public HashMap properties;
    public CacheId[] cacheIds;
    public DependencyId[] dependencyIds;
    public Invalidation[] invalidations;
    public int iClassName;
    public static final int SERVLET = 1;
    public static final int COMMAND = 2;
    public static final int WEB_SERVICE = 3;
    public static final int WEB_SERVICE_CLIENT = 4;
    public static final int STATIC = 5;
    public Object[] processorData = null;

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("[CacheEntry]");
        printWriter.println("className     : " + this.className);
        printWriter.println("instanceName     : " + this.instanceName);
        printWriter.println("name          : " + this.name);
        printWriter.println("all names      : " + this.allNames);
        printWriter.println("sharingPolicy : " + this.sharingPolicy);
        if (this.properties != null && this.properties.size() > 0) {
            Iterator iterator = this.properties.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Property)iterator.next()).toString());
            }
        }
        for (n = 0; this.cacheIds != null && n < this.cacheIds.length; ++n) {
            printWriter.println("[CacheId " + n + "]");
            printWriter.println(this.cacheIds[n]);
        }
        for (n = 0; this.dependencyIds != null && n < this.dependencyIds.length; ++n) {
            printWriter.println("[Dependency " + n + "]");
            printWriter.println(this.dependencyIds[n]);
        }
        for (n = 0; this.invalidations != null && n < this.invalidations.length; ++n) {
            printWriter.println("[Invalidation " + n + "]");
            printWriter.println(this.invalidations[n]);
        }
        return stringWriter.toString();
    }

    public String fancyFormat() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("[" + this.name + "]");
        printWriter.println("instanceName     : " + this.instanceName);
        printWriter.println("className      : " + this.className);
        printWriter.println("sharing Policy : " + this.sharingPolicy + " " + (this.sharingPolicy == 1 ? "NOT_SHARED" : (this.sharingPolicy == 3 ? "SHARED_PULL" : (this.sharingPolicy == 2 ? "SHARED_PUSH" : (this.sharingPolicy == 4 ? "SHARED_PUSH_PULL" : "unknown")))));
        if (this.properties != null && this.properties.size() > 0) {
            Iterator iterator = this.properties.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Property)iterator.next()).fancyFormat(1));
            }
        }
        for (n = 0; this.cacheIds != null && n < this.cacheIds.length; ++n) {
            printWriter.println("[CacheId " + n + "]");
            printWriter.println(this.cacheIds[n].fancyFormat(1));
        }
        for (n = 0; this.dependencyIds != null && n < this.dependencyIds.length; ++n) {
            printWriter.println("[Dependency " + n + "]");
            printWriter.println(this.dependencyIds[n].fancyFormat(1));
        }
        for (n = 0; this.invalidations != null && n < this.invalidations.length; ++n) {
            printWriter.println("[Invalidation " + n + "]");
            printWriter.println(this.invalidations[n].fancyFormat(1));
        }
        return stringWriter.toString();
    }

    public static String getESIDependencies(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration != null && enumeration.hasMoreElements() || enumeration2 != null && enumeration2.hasMoreElements())) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("dependencies=\"");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" ");
                stringBuffer.append((String)enumeration.nextElement());
            }
        }
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                stringBuffer.append(" ");
                stringBuffer.append((String)enumeration2.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        ConfigEntry configEntry = new ConfigEntry();
        configEntry.className = this.className;
        configEntry.iClassName = this.iClassName;
        configEntry.instanceName = this.instanceName;
        configEntry.name = this.name;
        configEntry.allNames = this.allNames;
        configEntry.sharingPolicy = this.sharingPolicy;
        if (this.properties != null) {
            configEntry.properties = new HashMap(this.properties.size());
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                configEntry.properties.put(k, ((Property)this.properties.get(k)).clone());
            }
        }
        if (this.cacheIds != null) {
            configEntry.cacheIds = new CacheId[this.cacheIds.length];
            for (int i = 0; i < this.cacheIds.length; ++i) {
                configEntry.cacheIds[i] = (CacheId)this.cacheIds[i].clone();
            }
        }
        if (this.dependencyIds != null) {
            configEntry.dependencyIds = new DependencyId[this.dependencyIds.length];
            for (int i = 0; i < this.dependencyIds.length; ++i) {
                configEntry.dependencyIds[i] = (DependencyId)this.dependencyIds[i].clone();
            }
        }
        if (this.invalidations != null) {
            configEntry.invalidations = new Invalidation[this.invalidations.length];
            for (int i = 0; i < this.invalidations.length; ++i) {
                configEntry.invalidations[i] = (Invalidation)this.invalidations[i].clone();
            }
        }
        if (this.processorData != null) {
            configEntry.processorData = new Object[this.processorData.length];
            for (int i = 0; i < this.processorData.length; ++i) {
                configEntry.processorData[i] = this.processorData[i];
            }
        }
        return configEntry;
    }
}

