/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandIdGenerator;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;

public class CommandCacheProcessor
extends CacheProcessor {
    private static TraceComponent tc = Trace.register(CommandCacheProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected CacheableCommand command;
    int sharingPolicy;

    public String getBaseName() {
        return this.command.getClass().getName();
    }

    public void reset(ConfigEntry configEntry) {
        super.reset(configEntry);
        if (configEntry != null) {
            this.sharingPolicy = configEntry.sharingPolicy;
        }
    }

    public void setCacheableCommand(CacheableCommand cacheableCommand) {
        this.command = cacheableCommand;
    }

    protected Object getComponentValue(Component component) {
        Object object = null;
        if (component.idMethod != null) {
            object = this.processMethod(component.idMethod, this.command);
        } else if (component.idField != null) {
            object = this.processField(component.idField, this.command);
        } else if (component.type.equals("method")) {
            component.idMethod = new Method();
            component.idMethod.name = component.id;
            component.idMethod.index = component.index;
            object = this.processMethod(component.idMethod, this.command);
        } else if (component.type.equals("field")) {
            component.idField = new Field();
            component.idField.name = component.id;
            component.idField.index = component.index;
            object = this.processField(component.idField, this.command);
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0038E", (Object)new Object[]{component.type, this.command.getClass().getName()});
        }
        if (object != null) {
            if (component.method != null) {
                object = this.processMethod(component.method, object);
            } else if (component.field != null) {
                object = this.processField(component.field, object);
            }
        }
        return object;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    protected String processIdGenerator(CacheId cacheId) {
        if (cacheId.idGeneratorImpl == null) {
            try {
                Class<?> clazz = Class.forName(cacheId.idGenerator, true, Thread.currentThread().getContextClassLoader());
                cacheId.idGeneratorImpl = clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CommandCacheProcessor.processIdGenerator", "121", this);
                Tr.error((TraceComponent)tc, (String)"dynacache.idgeneratorerror", (Object)new Object[]{cacheId.idGenerator});
            }
        }
        if (this.groupIds == null) {
            this.groupIds = new ArrayList();
        }
        return ((CommandIdGenerator)cacheId.idGeneratorImpl).getId(this.command, this.groupIds);
    }

    protected void processMetaDataGenerator(CacheId cacheId) {
        Tr.error((TraceComponent)tc, (String)"DYNA0039E");
    }

    protected String[] processInvalidationGenerator(Invalidation invalidation) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Commands do not support custom invalidation generating classes.");
        }
        return null;
    }
}

