/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.PropertiesEntityResolver;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static TraceComponent tc = Trace.register(XMLUtil.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");

    public static Element getElementByTagName(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No element named " + string + " in " + document.getDoctype().getName() + "."));
            }
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static Element getElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No element named " + string + " in " + element.getTagName() + "."));
            }
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = XMLUtil.getAttribute(namedNodeMap, string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static String getAttribute(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static Document parse(String string) throws IOException, SAXException {
        if (string == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException(parserConfigurationException, "com.ibm.ws.cache.XMLUtil.parse", "166");
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public static Document parse(String string, InputStream inputStream) throws IOException, SAXException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream was null");
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException(parserConfigurationException, "com.ibm.ws.cache.XMLUtil.parse", "192");
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public static Document getDocumentWithExternalDTD(String string) throws IOException, SAXException {
        if (string == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            PropertiesEntityResolver propertiesEntityResolver = new PropertiesEntityResolver();
            documentBuilder.setEntityResolver(propertiesEntityResolver);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set entityresolver=" + propertiesEntityResolver));
            }
            Document document = documentBuilder.parse(XMLUtil.findFileInPropertiesDir(string));
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException(parserConfigurationException, "com.ibm.ws.cache.XMLUtil.getDocumentWithExternalDTD", "238");
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public static String findFileInPropertiesDir(String string) throws IOException {
        File file;
        if (string == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("looking for " + string + "..."));
        }
        Properties properties = System.getProperties();
        StringBuffer stringBuffer = new StringBuffer(properties.getProperty("user.install.root", properties.getProperty("was.install.root")));
        stringBuffer.append(properties.getProperty("file.separator"));
        stringBuffer.append("properties");
        stringBuffer.append(properties.getProperty("file.separator"));
        stringBuffer.append(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finding file " + stringBuffer.toString() + "..."));
        }
        if (!(file = new File(stringBuffer.toString())).exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + " not found."));
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " found."));
        }
        return file.toURL().toString();
    }

    public static final String normalize(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("")) {
            return null;
        }
        return string;
    }
}

