/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroup;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroupMember;
import com.ibm.websphere.models.config.dynacache.CacheInstance;
import com.ibm.websphere.models.config.dynacache.ObjectCacheInstance;
import com.ibm.websphere.models.config.dynacache.ServletCacheInstance;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.drs.DRSSettings;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.util.FieldInitializer;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.ecore.EObject;

public class WCCMCacheConfig
extends CacheConfig {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static int zosReplicationType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WCCMCacheConfig(Properties properties, CacheConfig cacheConfig, CacheConfig.Environment environment) {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.configSource = 6;
        this.enableServletSupport = false;
        this.cacheName = null;
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = cacheConfig.cachePriority;
        this.jspCachePriority = cacheConfig.jspCachePriority;
        this.commandCachePriority = cacheConfig.commandCachePriority;
        this.diskHashBuckets = cacheConfig.diskHashBuckets;
        this.cacheUnits = cacheConfig.cacheUnits;
        this.cacheSize = cacheConfig.cacheSize;
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        this.enableCacheReplication = cacheConfig.enableCacheReplication;
        this.replicationType = cacheConfig.replicationType;
        if (cacheConfig.enableCacheReplication && cacheConfig.drss != null) {
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)cacheConfig.drss);
            this.replicationDomain = this.drss.getMessageBrokerDomainName();
        }
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        this.pushFrequency = cacheConfig.pushFrequency;
        if (this.pushFrequency < 1) {
            this.pushFrequency = 1;
        }
        this.batchUpdateInterval = this.pushFrequency * 1000;
        this.enableDiskOffload = false;
        this.flushToDiskOnStop = false;
        super.overrideCacheConfig(properties);
        if (this.enableServletSupport) {
            this.configSource = 5;
        }
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            Object object = cacheConfig.drss;
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            } else {
                this.drss.setMessageBrokerDomainName(this.replicationDomain);
            }
        }
        if (!$assertionsDisabled && !super.verifyConfig()) {
            throw new AssertionError();
        }
    }

    public WCCMCacheConfig(DynamicCache dynamicCache, CacheConfig.Environment environment) {
        Object object;
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.configSource = 1;
        this.enableServletSupport = true;
        this.cacheName = "baseCache";
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = dynamicCache.getDefaultPriority();
        this.jspCachePriority = dynamicCache.getDefaultPriority();
        this.commandCachePriority = dynamicCache.getDefaultPriority() + 2;
        this.diskHashBuckets = dynamicCache.getHashSize();
        this.cacheSize = dynamicCache.getCacheSize();
        this.enableCacheReplication = dynamicCache.isEnableCacheReplication();
        this.replicationType = dynamicCache.getReplicationType().getValue();
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        ServerCache.setSharingPolicy(this.defaultShareType);
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            object = dynamicCache.getCacheReplication();
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            }
        }
        this.pushFrequency = dynamicCache.getPushFrequency();
        if (this.pushFrequency < 1) {
            this.pushFrequency = 1;
        }
        this.batchUpdateInterval = this.pushFrequency * 1000;
        ServerCache.setPushFrequency(this.pushFrequency);
        this.enableDiskOffload = dynamicCache.isEnableDiskOffload();
        if (dynamicCache.getDiskOffloadLocation() != null) {
            this.diskOffloadLocation = dynamicCache.getDiskOffloadLocation();
        }
        this.flushToDiskOnStop = dynamicCache.isFlushToDiskOnStop();
        object = dynamicCache.getCacheGroups().iterator();
        while (object.hasNext()) {
            ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)object.next();
            CacheConfig.ExternalCacheGroup externalCacheGroup2 = new CacheConfig.ExternalCacheGroup();
            externalCacheGroup2.name = externalCacheGroup.getName();
            externalCacheGroup2.type = externalCacheGroup.getType().getValue();
            externalCacheGroup2.members = new ArrayList();
            Iterator iterator = externalCacheGroup.getMembers().iterator();
            while (iterator.hasNext()) {
                ExternalCacheGroupMember externalCacheGroupMember = (ExternalCacheGroupMember)iterator.next();
                CacheConfig.ExternalCacheGroupMember externalCacheGroupMember2 = new CacheConfig.ExternalCacheGroupMember();
                externalCacheGroupMember2.address = externalCacheGroupMember.getAddress();
                externalCacheGroupMember2.beanName = externalCacheGroupMember.getAdapterBeanName();
                externalCacheGroup2.members.add(externalCacheGroupMember2);
            }
            this.externalGroups.add(externalCacheGroup2);
        }
        FieldInitializer.initFromSystemProperties((Object)this);
        super.overrideCacheConfig(null);
        if (!$assertionsDisabled && !super.verifyConfig()) {
            throw new AssertionError();
        }
    }

    public WCCMCacheConfig(CacheInstance cacheInstance, CacheConfig.Environment environment) {
        Object object;
        EtoolsCopyUtility etoolsCopyUtility;
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        EtoolsCopyUtility etoolsCopyUtility2 = new EtoolsCopyUtility();
        this.configSource = 2;
        this.enableServletSupport = false;
        this.cacheName = cacheInstance.getJndiName();
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = cacheInstance.getDefaultPriority();
        this.jspCachePriority = cacheInstance.getDefaultPriority();
        this.commandCachePriority = cacheInstance.getDefaultPriority() + 2;
        this.diskHashBuckets = cacheInstance.getHashSize();
        this.cacheSize = cacheInstance.getCacheSize();
        this.enableCacheReplication = cacheInstance.isEnableCacheReplication();
        this.replicationType = cacheInstance.getReplicationType().getValue();
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            etoolsCopyUtility = new EtoolsCopyUtility();
            object = cacheInstance.getCacheReplication();
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility2.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            }
        }
        this.pushFrequency = cacheInstance.getPushFrequency();
        if (this.pushFrequency < 1) {
            this.pushFrequency = 1;
        }
        this.batchUpdateInterval = this.pushFrequency * 1000;
        this.enableDiskOffload = cacheInstance.isEnableDiskOffload();
        if (cacheInstance.getDiskOffloadLocation() != null) {
            this.diskOffloadLocation = cacheInstance.getDiskOffloadLocation();
        }
        this.flushToDiskOnStop = cacheInstance.isFlushToDiskOnStop();
        if (cacheInstance instanceof ServletCacheInstance) {
            this.enableServletSupport = true;
            this.configSource = 3;
        }
        if (cacheInstance instanceof ObjectCacheInstance) {
            this.useListenerContext = ((ObjectCacheInstance)cacheInstance).isUseListenerContext();
            this.disableDependencyId = ((ObjectCacheInstance)cacheInstance).isDisableDependencyId();
            this.enableReplicationAcks = false;
            this.enableNioSupport = false;
            this.configSource = 4;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Config before custom properties:", (Object)("" + this));
        }
        if ((etoolsCopyUtility = cacheInstance.getPropertySet()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attention: Custom property set is null");
            }
        } else {
            object = new Properties();
            Iterator iterator = etoolsCopyUtility.getResourceProperties().iterator();
            while (iterator.hasNext()) {
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                String string2 = this.getClass().getName() + "." + j2EEResourceProperty.getName();
                String string3 = j2EEResourceProperty.getValue();
                ((Properties)object).put(string2, string3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Attention: Custom property found: " + string2 + "/" + string3));
            }
            FieldInitializer.initFromSystemProperties((Object)this, (Properties)object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config after  custom properties:", (Object)("" + this));
            }
        }
        FieldInitializer.initFromSystemProperties((Object)this);
        super.overrideCacheConfig(null);
        if (!$assertionsDisabled && !super.verifyConfig()) {
            throw new AssertionError();
        }
    }

    private int convertReplicationType(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown replicationType");
                }
                break;
            }
        }
        return n2;
    }

    private boolean isZosForceReplicationActive() {
        if (!DynacachePlatformHelper.isZOSBaseServer()) {
            return false;
        }
        return DynacachePlatformHelper.isBaseServerReplicationEnabled();
    }

    private String getZosReplicationDomainName() {
        return "Dynacache_Base_Server_Domain";
    }

    private int getZosForceReplicationType() {
        zosReplicationType = DynacachePlatformHelper.getZOSBaseServerReplicationType();
        return zosReplicationType;
    }

    static {
        $assertionsDisabled = !WCCMCacheConfig.class.desiredAssertionStatus();
        tc = Trace.register(WCCMCacheConfig.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        zosReplicationType = 0;
    }
}

