/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheInstanceInfo;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.CacheStatisticsListener;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.drs.DRSRemoteServices;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ServerCache {
    private static TraceComponent tc = Trace.register(ServerCache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static boolean cacheEnabled = false;
    public static CacheUnitImpl cacheUnit = null;
    public static Cache cache = null;
    public static CommandCache commandCache = null;
    public static JSPCache jspCache = null;
    public static CacheService cacheService = null;
    public static ClassLoader classLoader = null;
    private static int sharingPolicy = 1;
    private static int pushFrequency = 0;
    private static Map cacheInstances = new HashMap();
    private static Map commandCacheInstances = new HashMap();
    private static Map jspCacheInstances = new HashMap();
    private static Map jaxRpcCacheInstances = new HashMap();
    private static Map monitors = new HashMap();

    public static int getSharingPolicy() {
        return sharingPolicy;
    }

    public static void setSharingPolicy(int n) {
        sharingPolicy = n;
    }

    public static int getPushFrequency() {
        return pushFrequency;
    }

    public static void setPushFrequency(int n) {
        pushFrequency = n;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setClassLoader()classLoader=" + classLoader));
        }
        ServerCache.classLoader = classLoader;
    }

    public static boolean isBatchEnabled() {
        return pushFrequency > 0;
    }

    public static Map getCacheInstances() {
        return cacheInstances;
    }

    public static JSPCache getJspCache(String string) {
        JSPCache jSPCache = jspCache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            jSPCache = (JSPCache)jspCacheInstances.get(string);
            if (!jspCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    jSPCache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    jSPCache = null;
                } else {
                    Cache cache = ServerCache.getCache(string);
                    if (cache == null) {
                        cache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                    jSPCache = new JSPCache();
                    jSPCache.setCache(cache);
                    jSPCache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                    jSPCache.setRemoteServices(cache.getRemoteServices());
                    jSPCache.setDefaultPriority(wCCMCacheConfig.jspCachePriority);
                    jSPCache.setExternalCacheServices(cacheUnit.getExternalCacheServices());
                    jSPCache.start();
                }
                jspCacheInstances.put(string, jSPCache);
            }
        }
        return jSPCache;
    }

    public static CommandCache getCommandCache(String string) {
        CommandCache commandCache = ServerCache.commandCache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            commandCache = (CommandCache)commandCacheInstances.get(string);
            if (!commandCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    commandCache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    commandCache = null;
                } else {
                    Cache cache = ServerCache.getCache(string);
                    if (cache == null) {
                        cache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                    commandCache = new CommandCache();
                    commandCache.setCache(cache);
                    commandCache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                    commandCache.setRemoteServices(cache.getRemoteServices());
                    commandCache.setDefaultPriority(wCCMCacheConfig.commandCachePriority);
                    commandCache.setCommandStoragePolicy(cacheUnit.getCommandStoragePolicy());
                    commandCache.start();
                }
                commandCacheInstances.put(string, commandCache);
            }
        }
        return commandCache;
    }

    public static Cache getJaxRpcCache(String string) {
        Cache cache = ServerCache.cache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            cache = (Cache)jaxRpcCacheInstances.get(string);
            if (!jaxRpcCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    cache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                    cache = null;
                } else {
                    cache = ServerCache.getCache(string);
                    if (cache == null) {
                        cache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                }
                jaxRpcCacheInstances.put(string, cache);
            }
        }
        return cache;
    }

    public static Cache getCache(String string) {
        Cache cache = ServerCache.cache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            cache = (Cache)cacheInstances.get(string);
        }
        return cache;
    }

    public static Cache getConfiguredCache(String string) {
        Cache cache = ServerCache.cache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
            if (wCCMCacheConfig == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object)new Object[]{string});
                cache = null;
            } else {
                cache = ServerCache.getCache(string);
                if (cache == null) {
                    cache = ServerCache.createCache(string, wCCMCacheConfig);
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache createCache(String string, CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createCache()name=" + string + " config=" + cacheConfig + "enableReplication=" + cacheConfig.enableCacheReplication));
        }
        Cache cache = null;
        Object object = null;
        Object object2 = monitors;
        synchronized (object2) {
            object = monitors.get(string);
            if (object == null) {
                object = new Object();
                monitors.put(string, object);
            }
        }
        object2 = object;
        synchronized (object2) {
            cache = ServerCache.getCache(string);
            if (cache == null) {
                cacheConfig.cache = cache = new Cache(string, cacheConfig);
                cache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                DRSNotificationService dRSNotificationService = null;
                RemoteServices remoteServices = null;
                if (cacheConfig.enableCacheReplication) {
                    try {
                        dRSNotificationService = new DRSNotificationService();
                        remoteServices = new DRSRemoteServices();
                        remoteServices.setNotificationService(dRSNotificationService);
                        dRSNotificationService.setCacheName(string);
                        remoteServices.setCacheName(string);
                        cacheService.initNotificationServiceInstance(dRSNotificationService, cacheConfig);
                        dRSNotificationService.start();
                        remoteServices.start();
                        dRSNotificationService.registerCacheUnit(string, cacheUnit);
                        remoteServices.setCacheUnit(cacheUnit.getUniqueCacheName(), cacheUnit);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.ServerCache.createCache", "219", null);
                        exception.printStackTrace();
                        remoteServices = ServerCache.cacheUnit.remoteServices;
                        cacheConfig.enableCacheReplication = false;
                    }
                } else {
                    remoteServices = ServerCache.cacheUnit.remoteServices;
                }
                cache.setRemoteServices(remoteServices);
                cache.setTimeLimitDaemon(ServerCache.cacheUnit.timeLimitDaemon);
                cache.setDefaultPriority(cacheConfig.cachePriority);
                CacheStatisticsListener cacheStatisticsListener = null;
                try {
                    cacheStatisticsListener = (CacheStatisticsListener)ServerCache.getClassLoader().loadClass(cacheConfig.cacheStatisticsListenerBeanName).newInstance();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.ServerCache.createCache", "225", null);
                    throwable.printStackTrace();
                }
                cache.setCacheStatisticsListener(cacheStatisticsListener);
                cacheInstances.put(string, cache);
                cache.start();
            }
        }
        object2 = monitors;
        synchronized (object2) {
            monitors.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCache()name=" + string + " cache=" + cache));
        }
        return cache;
    }

    public static ArrayList getServletCacheInstanceNames() {
        ArrayList arrayList = null;
        if (cacheService != null) {
            arrayList = cacheService.getServletCacheInstanceNames();
        }
        return arrayList;
    }

    public static CacheInstanceInfo[] getCacheInstanceInfo() {
        CacheInstanceInfo[] cacheInstanceInfoArray = null;
        if (cacheService != null) {
            cacheInstanceInfoArray = ((CacheServiceImpl)cacheService).getCacheInstanceInfo();
        }
        return cacheInstanceInfoArray;
    }

    public static int getActiveCacheInstanceCount() {
        return cacheInstances.size();
    }
}

