/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.HTODDependencyTable;
import com.ibm.ws.cache.HTODInvalidationBuffer;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.ReadWriteLock;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashtableAction;
import com.ibm.ws.cache.persistent.htod.HashtableEntry;
import com.ibm.ws.cache.persistent.htod.HashtableOnDisk;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;

public class HTODDynacache {
    private static final boolean IS_UNIT_TEST = false;
    public static final boolean CHECK_EXPIRED = true;
    public static final boolean DELETE = true;
    public static final boolean EXIST = true;
    public static final boolean COMPLETE_CLEAR = true;
    public static final boolean FILTER = true;
    public static final int NUM_SCAN = 50;
    public static final String DISKCACHE_MORE = "DISKCACHE_MORE";
    public static final ValueSet EMPTY_VS = new ValueSet(1);
    private static TraceComponent tc = Trace.register(HTODDynacache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private ReadWriteLock readWriteLock = new ReadWriteLock();
    public PrimitiveArrayPool byteArrayPool = null;
    public PrimitiveArrayPool longArrayPool = null;
    public HashtableEntryObjectPool htEntryPool = null;
    protected HTODInvalidationBuffer invalidationBuffer = null;
    protected String filename;
    protected String dirname;
    protected FileManager object_filemgr;
    protected FileManager dependency_filemgr;
    protected FileManager template_filemgr;
    static String object_suffix = "-objects";
    static String dependency_suffix = "-dependencies";
    static String template_suffix = "-templates";
    protected HashtableOnDisk object_cache = null;
    protected HashtableOnDisk dependency_cache = null;
    protected HashtableOnDisk template_cache = null;
    protected Cache cache = null;
    protected CacheOnDisk cod = null;
    boolean auto_rehash = false;
    long scanExpiredTime = 0L;
    public String cacheName = "";
    protected int initial_hashtable_size = 1296109;
    protected int hashtable_threshold = 75;
    protected int initial_valueset_size = 509;
    protected boolean valueset_rehash = true;
    protected int physical_disk_manager = 2;
    protected ValueSet removeIdsList = null;
    protected HTODDependencyTable auxDataDependencyTable = null;
    protected HTODDependencyTable auxTemplateDependencyTable = null;
    protected boolean delayOffload = false;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected boolean processCompleteClear = true;
    private long deletedSize = 0L;

    public HTODDynacache() {
        PrimitiveArrayPool.PoolConfig poolConfig = new PrimitiveArrayPool.PoolConfig();
        poolConfig.type = 1;
        poolConfig.numberOfPools = 20;
        poolConfig.poolSize = 2;
        poolConfig.poolEntryLife = 300000;
        poolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(poolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig poolConfig2 = new PrimitiveArrayPool.PoolConfig();
        poolConfig2.type = 2;
        poolConfig2.numberOfPools = 20;
        poolConfig2.poolSize = 2;
        poolConfig2.poolEntryLife = 300000;
        poolConfig2.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(poolConfig2, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
    }

    public HTODDynacache(String string, String string2, Cache cache, CacheOnDisk cacheOnDisk) throws IOException, ClassNotFoundException {
        this.dirname = string;
        this.filename = string2;
        this.cache = cache;
        this.cod = cacheOnDisk;
        this.cacheName = cache.cacheName;
        PrimitiveArrayPool.PoolConfig poolConfig = new PrimitiveArrayPool.PoolConfig();
        poolConfig.type = 1;
        poolConfig.numberOfPools = cacheOnDisk.numberOfPools;
        poolConfig.poolSize = cacheOnDisk.poolSize;
        poolConfig.poolEntryLife = cacheOnDisk.poolEntryLife;
        poolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(poolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig poolConfig2 = new PrimitiveArrayPool.PoolConfig();
        poolConfig2.type = 2;
        poolConfig2.numberOfPools = cacheOnDisk.numberOfPools;
        poolConfig2.poolSize = cacheOnDisk.poolSize;
        poolConfig2.poolEntryLife = cacheOnDisk.poolEntryLife;
        poolConfig2.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(poolConfig2, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
        this.invalidationBuffer = new HTODInvalidationBuffer(this.cod);
        this.init_files();
        this.delayOffload = cacheOnDisk.delayOffload;
        int n = cacheOnDisk.delayOffloadEntriesLimit;
        this.disableDependencyId = cacheOnDisk.disableDependencyId;
        this.disableTemplatesSupport = cacheOnDisk.disableTemplatesSupport;
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                this.auxDataDependencyTable = new HTODDependencyTable(1, 1000, cacheOnDisk.delayOffloadDepIdBuckets, 2, n, this);
            }
            if (!this.disableTemplatesSupport) {
                this.auxTemplateDependencyTable = new HTODDependencyTable(2, 100, cacheOnDisk.delayOffloadTemplateBuckets, 2, n, this);
            }
        }
        this.cod.readAndDeleteInvalidationFile();
        if (this.cod.valueSet != null) {
            this.invalidationBuffer.add(this.cod.valueSet, true);
            this.cod.valueSet.clear();
            this.cod.valueSet = null;
        }
    }

    protected void init_files() throws IOException, ClassNotFoundException {
        this.initFileManager();
        this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, this);
        if (this.object_cache == null) {
            HashtableOnDisk.createInstance(this.object_filemgr, this.cod.dataHashtableSize, this.hashtable_threshold);
            this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, this);
        }
        if (!this.disableDependencyId && (this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, this)) == null) {
            HashtableOnDisk.createInstance(this.dependency_filemgr, this.cod.depIdHashtableSize, this.hashtable_threshold);
            this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, this);
        }
        if (!this.disableTemplatesSupport && (this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, this)) == null) {
            HashtableOnDisk.createInstance(this.template_filemgr, this.cod.templateHashtableSize, this.hashtable_threshold);
            this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, this);
        }
    }

    void initFileManager() {
        try {
            this.object_filemgr = new FileManagerImpl(this.filename + object_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
            if (!this.disableDependencyId) {
                this.dependency_filemgr = new FileManagerImpl(this.filename + dependency_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
            }
            if (!this.disableTemplatesSupport) {
                this.template_filemgr = new FileManagerImpl(this.filename + template_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.initFileManager", "265", this);
            this.traceDebug("initFileManager()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            this.closeNoRWLock();
            this.readWriteLock.postWrite();
        }
    }

    private void closeNoRWLock() {
        try {
            this.object_cache.close();
            if (!this.disableDependencyId) {
                this.dependency_cache.close();
            }
            if (!this.disableTemplatesSupport) {
                this.template_cache.close();
            }
            this.object_filemgr.close();
            if (!this.disableDependencyId) {
                this.dependency_filemgr.close();
            }
            if (!this.disableTemplatesSupport) {
                this.template_filemgr.close();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.close", "296", this);
            this.traceDebug("close()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    public void writeAuxiliaryDepTables() {
        if (this.delayOffload) {
            ValueSet valueSet;
            Object e;
            Enumeration enumeration;
            long l = System.currentTimeMillis();
            int n = 0;
            int n2 = 0;
            if (!this.disableDependencyId && !this.auxDataDependencyTable.isEmpty()) {
                enumeration = this.auxDataDependencyTable.getKeys();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    if (!this.auxDataDependencyTable.isUpdated(e)) continue;
                    valueSet = this.auxDataDependencyTable.getEntries(e);
                    this.writeValueSet(this.dependency_cache, e, valueSet);
                    ++n;
                }
                this.auxDataDependencyTable.clear();
            }
            if (!this.disableTemplatesSupport && !this.auxTemplateDependencyTable.isEmpty()) {
                enumeration = this.auxTemplateDependencyTable.getKeys();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    if (!this.auxTemplateDependencyTable.isUpdated(e)) continue;
                    valueSet = this.auxTemplateDependencyTable.getEntries(e);
                    this.writeValueSet(this.template_cache, e, valueSet);
                    ++n2;
                }
                this.auxTemplateDependencyTable.clear();
            }
            this.traceDebug("writeAuxiliaryDepTables()", "cacheName=" + this.cache.cacheName + " Offload auxiliary tables to disk elapsed=" + (System.currentTimeMillis() - l) + " depid count=" + n + " template count=" + n2);
        }
    }

    public void dump_object_statistics() {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("------------------ Object File Manager Statistics ---------------\n");
            this.object_filemgr.dump_stats(outputStreamWriter, true);
            outputStreamWriter.write("------------------ Object HTOD Statistics ---------------\n");
            this.object_cache.dump_htod_stats(outputStreamWriter, true);
            outputStreamWriter.write("========================================================================");
            if (!this.disableDependencyId) {
                outputStreamWriter.write("========================================================================");
                outputStreamWriter.write("------------------ Dependency File Manager Statistics ---------------\n");
                this.dependency_filemgr.dump_stats(outputStreamWriter, true);
                outputStreamWriter.write("------------------ Dependency HTOD Statistics ---------------\n");
                this.dependency_cache.dump_htod_stats(outputStreamWriter, true);
                outputStreamWriter.write("========================================================================");
            }
            if (!this.disableTemplatesSupport) {
                outputStreamWriter.write("========================================================================");
                outputStreamWriter.write("------------------ Template File Manager Statistics ---------------\n");
                this.template_filemgr.dump_stats(outputStreamWriter, true);
                outputStreamWriter.write("------------------ Template HTOD Statistics ---------------\n");
                this.template_cache.dump_htod_stats(outputStreamWriter, true);
                outputStreamWriter.write("========================================================================");
            }
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.dump_object_statistics", "379", this);
            this.traceDebug("dump_object_statistics()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDiskCache() {
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                this.auxDataDependencyTable.clear();
            }
            if (!this.disableTemplatesSupport) {
                this.auxTemplateDependencyTable.clear();
            }
        }
        this.stop(true);
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                this.closeNoRWLock();
                this.deleteDiskCacheFiles();
                this.init_files();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.clearDiskCache", "410", this);
                this.traceDebug("clearDiskCache()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    public void stop(boolean bl) {
        this.processCompleteClear = bl;
        if (this.invalidationBuffer.isBackgroundInvalidationInProgress()) {
            this.invalidationBuffer.setLoopOnce(true);
            if (this.invalidationBuffer.isCleanupPending()) {
                this.invalidationBuffer.resetCleanupPending();
            }
        }
        if (bl) {
            this.invalidationBuffer.clear(true, true);
        } else {
            this.invalidationBuffer.clear(false, true);
            this.cod.valueSet = this.invalidationBuffer.removeAll(true);
            if (this.cod.valueSet.size() > 0) {
                this.cod.createInvalidationFile();
                this.cod.valueSet.clear();
                this.cod.valueSet = null;
            }
        }
    }

    public void deleteDiskCacheFiles() {
        this.cod.deleteDiskCacheFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                this.init_files();
                this.readWriteLock.postWrite();
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.restart", "466", this);
                    this.traceDebug("restart()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    this.readWriteLock.postWrite();
                }
            }
        }
        this.cod.readAndDeleteInvalidationFile();
        if (this.cod.valueSet != null) {
            this.invalidationBuffer.add(this.cod.valueSet, true);
        }
    }

    public void delCacheEntry(CacheEntry cacheEntry) {
        this.invalidationBuffer.add(cacheEntry.id, true);
        for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
            this.invalidationBuffer.addAlias(cacheEntry.aliasList[i]);
        }
    }

    public void delCacheEntry(ValueSet valueSet) {
        this.invalidationBuffer.add(valueSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int delCacheEntry(Object object, boolean bl) {
        int n = 0;
        HashtableEntry hashtableEntry = null;
        if (object != null) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                try {
                    this.readWriteLock.preWrite();
                    if (this.invalidationBuffer.isLoopOnce()) {
                        int n2 = n;
                        return n2;
                    }
                    hashtableEntry = this.object_cache.getAndRemove(object);
                    if (hashtableEntry != null && hashtableEntry.length() > 0) {
                        this.deletedSize += (long)hashtableEntry.length();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "515", this);
                    this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                finally {
                    this.readWriteLock.postWrite();
                }
            }
            if (hashtableEntry != null) {
                object2 = null;
                Object object3 = hashtableEntry.getValue();
                if (object3 != null) {
                    try {
                        object2 = (CacheEntry)SerializationUtility.deserialize((byte[])object3);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "528", this);
                        this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    finally {
                        this.returnToHashtableEntryPool(hashtableEntry);
                    }
                }
                if (object2 != null) {
                    ++n;
                    Object object4 = this.cache;
                    synchronized (object4) {
                        int n3;
                        if (this.invalidationBuffer.isLoopOnce() && this.processCompleteClear) {
                            return n;
                        }
                        for (n3 = 0; n3 < ((CacheEntry)object2)._dataIds.length; ++n3) {
                            this.delDependencyEntry(((CacheEntry)object2)._dataIds[n3], ((CacheEntry)object2).id);
                        }
                        for (n3 = 0; n3 < ((CacheEntry)object2)._templates.length; ++n3) {
                            this.delTemplateEntry(((CacheEntry)object2)._templates[n3], ((CacheEntry)object2).id);
                        }
                        for (n3 = 0; n3 < ((CacheEntry)object2).aliasList.length; ++n3) {
                            ReadWriteLock readWriteLock = this.readWriteLock;
                            synchronized (readWriteLock) {
                                try {
                                    this.readWriteLock.preWrite();
                                    this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.cacheName + " deleting alias with id= " + ((CacheEntry)object2).id + " alias=" + ((CacheEntry)object2).aliasList[n3]);
                                    this.object_cache.remove(((CacheEntry)object2).aliasList[n3]);
                                    this.invalidationBuffer.removeAlias(((CacheEntry)object2).aliasList[n3]);
                                    ++n;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "553", this);
                                    this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                                }
                                finally {
                                    this.readWriteLock.postWrite();
                                }
                                continue;
                            }
                        }
                    }
                    if (!bl && this.cache.bEnableListener && this.cache.eventSource.getInvalidationListenerCount() > 0) {
                        object4 = null;
                        if (!this.cod.ignoreValueInInvalidationEvent) {
                            object4 = ((CacheEntry)object2).serializedValue != null ? (Object)((CacheEntry)object2).serializedValue : ((CacheEntry)object2).getValue();
                        }
                        InvalidationEvent invalidationEvent = new InvalidationEvent(((CacheEntry)object2).id, object4, 4, 1, this.cache.cacheNameNonPrefixed);
                        this.cache.eventSource.fireEvent(invalidationEvent);
                    }
                    if (((CacheEntry)object2).sharingPolicy == 4 || ((CacheEntry)object2).sharingPolicy == 3) {
                        if (bl) {
                            this.cache.invalidateById(((CacheEntry)object2).id, 1, 3, false, false);
                        } else {
                            this.cache.invalidateById(((CacheEntry)object2).id, 3, 3, false, false);
                        }
                    }
                    if (this.cache.cachePerf.isPMIEnabled() && !bl) {
                        this.cache.cachePerf.onInvalidate(((CacheEntry)object2).getTemplate(), 3, 3, 5);
                    }
                    ((CacheEntry)object2).reset();
                }
            }
        }
        this.invalidationBuffer.remove(object, bl);
        return n;
    }

    public void delDependency(Object object) {
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                this.auxDataDependencyTable.removeDependency(object);
            }
            this.delValueSet(this.dependency_cache, object);
        }
    }

    public void delTemplate(String string) {
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                this.auxTemplateDependencyTable.removeDependency(string);
            }
            this.delValueSet(this.template_cache, string);
        }
    }

    public void delDependencyEntry(Object object, Object object2) {
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                int n = this.auxDataDependencyTable.removeEntry(object, object2);
                if (n == 1) {
                    this.delValueSetEntry(this.dependency_cache, object, object2);
                }
            } else {
                this.delValueSetEntry(this.dependency_cache, object, object2);
            }
        }
    }

    public void delTemplateEntry(String string, Object object) {
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                int n = this.auxTemplateDependencyTable.removeEntry(string, object);
                if (n == 1) {
                    this.delValueSetEntry(this.template_cache, string, object);
                }
            } else {
                this.delValueSetEntry(this.template_cache, string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry readCacheEntry(Object object) {
        CacheEntry cacheEntry = null;
        if (this.invalidationBuffer.contains(object)) {
            return cacheEntry;
        }
        HashtableEntry hashtableEntry = null;
        Object object2 = null;
        try {
            this.readWriteLock.preRead();
            hashtableEntry = this.object_cache.getHashTableEntry(object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "716", this);
            this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            CacheEntry cacheEntry2 = null;
            return cacheEntry2;
        }
        finally {
            this.readWriteLock.postRead();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (hashtableEntry != null) {
            object2 = hashtableEntry.getValue();
            if (hashtableEntry.getGrace() == 0L) {
                bl2 = true;
                this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.cacheName + " found alias=" + object + " cacheId=" + object2);
                this.returnToHashtableEntryPool(hashtableEntry);
                try {
                    this.readWriteLock.preRead();
                    if (this.invalidationBuffer.contains(object2)) {
                        CacheEntry cacheEntry3 = cacheEntry;
                        return cacheEntry3;
                    }
                    hashtableEntry = this.object_cache.getHashTableEntry(object2);
                    if (hashtableEntry != null) {
                        object2 = hashtableEntry.getValue();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "736", this);
                    this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    CacheEntry cacheEntry4 = null;
                    return cacheEntry4;
                }
                finally {
                    this.readWriteLock.postRead();
                }
            }
            if (hashtableEntry != null) {
                if (hashtableEntry.isExpired() || hashtableEntry.expire_last_referenced(this.cod.invalInterval)) {
                    bl = true;
                }
                if (bl && !this.cache.bEnableListener && !bl2) {
                    this.invalidationBuffer.add(object, true);
                    this.returnToHashtableEntryPool(hashtableEntry);
                    return null;
                }
                if (object2 != null) {
                    try {
                        cacheEntry = (CacheEntry)SerializationUtility.deserialize((byte[])object2);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "756", this);
                        this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                this.returnToHashtableEntryPool(hashtableEntry);
            }
        }
        if (cacheEntry != null && bl) {
            if (bl2) {
                this.invalidationBuffer.add(cacheEntry.id, true);
                this.invalidationBuffer.addAlias(object);
            }
            if (this.cache.bEnableListener && this.cache.eventSource.getInvalidationListenerCount() > 0) {
                Object object3 = null;
                if (!this.cod.ignoreValueInInvalidationEvent) {
                    object3 = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
                }
                InvalidationEvent invalidationEvent = new InvalidationEvent(cacheEntry.id, object3, 4, 1, this.cache.cacheNameNonPrefixed);
                this.cache.eventSource.fireEvent(invalidationEvent);
            }
            cacheEntry = null;
        }
        return cacheEntry;
    }

    public ValueSet readDependency(Object object, boolean bl) {
        ValueSet valueSet = null;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                valueSet = this.auxDataDependencyTable.getEntries(object);
                if (valueSet == null) {
                    valueSet = this.readValueSet(this.dependency_cache, object, bl);
                    if (valueSet != null) {
                        if (!bl && valueSet.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                            this.auxDataDependencyTable.add(object, valueSet, true);
                        }
                    } else {
                        valueSet = EMPTY_VS;
                    }
                } else if (bl) {
                    this.auxDataDependencyTable.removeDependency(object);
                    this.delValueSet(this.dependency_cache, object);
                }
            } else {
                valueSet = this.readValueSet(this.dependency_cache, object, bl);
            }
        } else {
            valueSet = EMPTY_VS;
        }
        this.invalidationBuffer.filter(valueSet, false);
        return valueSet;
    }

    public ValueSet readTemplate(String string, boolean bl) {
        ValueSet valueSet = null;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                valueSet = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet == null) {
                    valueSet = this.readValueSet(this.template_cache, string, bl);
                    if (valueSet != null) {
                        if (!bl && valueSet.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                            this.auxTemplateDependencyTable.add((Object)string, valueSet, true);
                        }
                    } else {
                        valueSet = EMPTY_VS;
                    }
                } else if (bl) {
                    this.auxTemplateDependencyTable.removeDependency(string);
                    this.delValueSet(this.template_cache, string);
                }
            } else {
                valueSet = this.readValueSet(this.template_cache, string, bl);
            }
        } else {
            valueSet = EMPTY_VS;
        }
        this.invalidationBuffer.filter(valueSet, false);
        return valueSet;
    }

    public ValueSet readCacheIdsByRange(int n, int n2) {
        return this.readByRange(this.object_cache, n, n2, true, true);
    }

    public ValueSet readDependencyByRange(int n, int n2) {
        ValueSet valueSet = null;
        valueSet = !this.disableDependencyId ? this.readByRange(this.dependency_cache, n, n2, false, false) : EMPTY_VS;
        return valueSet;
    }

    public ValueSet readTemplatesByRange(int n, int n2) {
        ValueSet valueSet = null;
        valueSet = !this.disableTemplatesSupport ? this.readByRange(this.template_cache, n, n2, false, false) : EMPTY_VS;
        return valueSet;
    }

    public int getCacheIdsSize() {
        this.readWriteLock.preRead();
        int n = this.object_cache.size();
        this.readWriteLock.postRead();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getDepIdsSize() {
        int n = 0;
        if (!this.disableDependencyId) {
            this.readWriteLock.preRead();
            n = this.dependency_cache.size();
            this.readWriteLock.postRead();
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    public int getTemplatesSize() {
        int n = 0;
        if (!this.disableTemplatesSupport) {
            this.readWriteLock.preRead();
            n = this.template_cache.size();
            this.readWriteLock.postRead();
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheEntry(CacheEntry cacheEntry) {
        Object object;
        this.invalidationBuffer.remove(cacheEntry.id);
        byte[] byArray = null;
        int n = 0;
        try {
            object = new ByteArrayPlusOutputStream(256);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            objectOutputStream.writeObject(cacheEntry);
            objectOutputStream.flush();
            objectOutputStream.close();
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayPlusOutputStream)object).getTheBuffer();
            n = ((ByteArrayOutputStream)object).size();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "1023", this);
            this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            return;
        }
        object = this.readWriteLock;
        synchronized (object) {
            try {
                this.readWriteLock.preWrite();
                if (cacheEntry.timeLimit > 0) {
                    this.object_cache.put(cacheEntry.getIdObject(), byArray, n, cacheEntry.expirationTime, -1L);
                } else {
                    this.object_cache.put(cacheEntry.getIdObject(), byArray, n, -1L, -1L);
                }
                for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
                    this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.cacheName + " adding alias with id=" + cacheEntry.id + " alias=" + cacheEntry.aliasList[i]);
                    this.object_cache.put(cacheEntry.aliasList[i], cacheEntry.getIdObject(), -1L, 0L);
                    this.invalidationBuffer.removeAlias(cacheEntry.aliasList[i]);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "1042", this);
                this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    public void writeDependency(Object object, ValueSet valueSet) {
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet valueSet2 = this.auxDataDependencyTable.getEntries(object);
                if (valueSet2 == null) {
                    if (valueSet.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        this.auxDataDependencyTable.add(object, valueSet, true);
                    }
                    this.writeValueSet(this.dependency_cache, object, valueSet);
                } else {
                    this.auxDataDependencyTable.replace(object, valueSet);
                }
            } else {
                this.writeValueSet(this.dependency_cache, object, valueSet);
            }
        }
    }

    public void writeDependencyEntry(Object object, Object object2) {
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet valueSet = this.auxDataDependencyTable.getEntries(object);
                if (valueSet == null) {
                    if (!this.writeValueSetEntry(this.dependency_cache, object, object2)) {
                        this.auxDataDependencyTable.add(object, object2, true);
                    }
                } else {
                    this.auxDataDependencyTable.add(object, valueSet, object2);
                }
            } else {
                this.writeValueSetEntry(this.dependency_cache, object, object2);
            }
        }
    }

    public void writeTemplate(String string, ValueSet valueSet) {
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet valueSet2 = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet2 == null) {
                    if (valueSet.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        this.auxTemplateDependencyTable.add((Object)string, valueSet, true);
                    }
                    this.writeValueSet(this.template_cache, string, valueSet);
                } else {
                    this.auxTemplateDependencyTable.replace(string, valueSet);
                }
            } else {
                this.writeValueSet(this.template_cache, string, valueSet);
            }
        }
    }

    public void writeTemplateEntry(String string, Object object) {
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet valueSet = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet == null) {
                    if (!this.writeValueSetEntry(this.template_cache, string, object)) {
                        this.auxTemplateDependencyTable.add((Object)string, object, true);
                    }
                } else {
                    this.auxTemplateDependencyTable.add((Object)string, valueSet, object);
                }
            } else {
                this.writeValueSetEntry(this.template_cache, string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueSet readValueSet(HashtableOnDisk hashtableOnDisk, Object object, boolean bl) {
        ValueSet valueSet = new ValueSet(4);
        if (bl) {
            ReadWriteLock readWriteLock = this.readWriteLock;
            synchronized (readWriteLock) {
                block21: {
                    int n;
                    FileManager fileManager;
                    long l;
                    HashtableOnDisk hashtableOnDisk2;
                    block22: {
                        this.readWriteLock.preWrite();
                        Long l2 = (Long)hashtableOnDisk.get(object);
                        hashtableOnDisk2 = null;
                        if (l2 == null) break block21;
                        l = l2;
                        fileManager = hashtableOnDisk.getFileManager();
                        hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l, this);
                        n = hashtableOnDisk2.size();
                        if (n > 0) break block22;
                        ValueSet valueSet2 = valueSet;
                        this.readWriteLock.postWrite();
                        return valueSet2;
                    }
                    try {
                        valueSet = new ValueSet(n);
                        ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, null);
                        hashtableOnDisk2.iterateKeys(valueSetReadCallback, 0, n, false);
                        hashtableOnDisk2.clear();
                        hashtableOnDisk2.close();
                        HashtableOnDisk.destroyInstance(fileManager, l);
                        hashtableOnDisk.remove(object);
                    }
                    catch (Throwable throwable) {
                        try {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1325", this);
                            this.traceDebug("readValueSet()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            this.readWriteLock.postWrite();
                        }
                    }
                }
                this.readWriteLock.postWrite();
            }
        } else {
            try {
                this.readWriteLock.preRead();
                Long l = (Long)hashtableOnDisk.get(object);
                HashtableOnDisk hashtableOnDisk3 = null;
                if (l != null) {
                    long l3 = l;
                    FileManager fileManager = hashtableOnDisk.getFileManager();
                    hashtableOnDisk3 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l3, this);
                    int n = hashtableOnDisk3.size();
                    if (n <= 0) {
                        ValueSet valueSet3 = valueSet;
                        return valueSet3;
                    }
                    valueSet = new ValueSet(n);
                    ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, null);
                    hashtableOnDisk3.iterateKeys(valueSetReadCallback, 0, n, false);
                    hashtableOnDisk3.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1350", this);
                this.traceDebug("readValueSet()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postRead();
            }
        }
        {
            return valueSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueSet readByRange(HashtableOnDisk hashtableOnDisk, int n, int n2, boolean bl, boolean bl2) {
        ValueSet valueSet = null;
        ValueSet valueSet2 = null;
        boolean bl3 = false;
        try {
            this.readWriteLock.preRead();
            if (hashtableOnDisk != null) {
                if (n < 0) {
                    n = hashtableOnDisk.getPreviousRangeIndex();
                } else if (n > 0) {
                    n = hashtableOnDisk.getNextRangeIndex();
                } else {
                    hashtableOnDisk.initRangeIndex();
                }
                if (n2 == -1) {
                    bl3 = true;
                    n2 = hashtableOnDisk.size();
                }
                if (n2 <= 0) {
                    ValueSet valueSet3 = null;
                    return valueSet3;
                }
                this.traceDebug("readByRange()", "cacheName=" + this.cache.cacheName + " before range index=" + n + " length=" + n2);
                valueSet = new ValueSet(n2);
                if (bl) {
                    valueSet2 = new ValueSet(n2 / 2);
                }
                ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, valueSet2);
                int n3 = hashtableOnDisk.iterateKeys(valueSetReadCallback, n, n2, bl);
                if (bl) {
                    this.traceDebug("readByRange()", "cacheName=" + this.cache.cacheName + " after range index=" + n3 + " length=" + n2 + " idsFound=" + valueSet.size() + " idsExpired=" + valueSet2.size());
                } else {
                    this.traceDebug("readByRange()", "cacheName=" + this.cache.cacheName + " after range index=" + n3 + " length=" + n2 + " idsFound=" + valueSet.size());
                }
                hashtableOnDisk.addRangeIndex(n3);
                if (bl) {
                    if (!bl3 && valueSet.size() + valueSet2.size() >= n2) {
                        valueSet.add(DISKCACHE_MORE);
                    }
                } else if (!bl3 && valueSet.size() >= n2) {
                    valueSet.add(DISKCACHE_MORE);
                }
                if (valueSet2 != null && valueSet2.size() > 0) {
                    this.invalidationBuffer.add(valueSet2, false);
                }
                if (bl2) {
                    this.invalidationBuffer.filter(valueSet, true);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readByRange", "1404", this);
            this.traceDebug("readByRange()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
        finally {
            this.readWriteLock.postRead();
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readExpiredByRange(HashtableOnDisk hashtableOnDisk, ValueSet valueSet, int n, int n2, long l) {
        this.scanExpiredTime = 0L;
        boolean bl = false;
        if (hashtableOnDisk == null) {
            return true;
        }
        try {
            this.readWriteLock.preRead();
            if (n == 0) {
                hashtableOnDisk.rangeExpiredIndex = 0;
            }
            long l2 = System.currentTimeMillis();
            DynaAction dynaAction = new DynaAction(valueSet, l);
            int n3 = hashtableOnDisk.iterateKeys(dynaAction, hashtableOnDisk.rangeExpiredIndex, n2, true);
            this.scanExpiredTime = System.currentTimeMillis() - l2;
            if (valueSet.size() + dynaAction.notExpiredCount < n2) {
                hashtableOnDisk.rangeExpiredIndex = 0;
                bl = true;
            } else {
                hashtableOnDisk.rangeExpiredIndex = n3;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readExpiredByRange", "1441", this);
            this.traceDebug("readExpiredByRange()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            bl = true;
        }
        finally {
            this.readWriteLock.postRead();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeValueSet(HashtableOnDisk hashtableOnDisk, Object object, ValueSet valueSet) {
        if (valueSet.size() == 0) {
            this.delValueSet(hashtableOnDisk, object);
            return;
        }
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                Long l = (Long)hashtableOnDisk.get(object);
                HashtableOnDisk hashtableOnDisk2 = null;
                long l2 = 0L;
                FileManager fileManager = hashtableOnDisk.getFileManager();
                if (l == null) {
                    int n = this.calculateTableSize(object, valueSet.size());
                    l2 = HashtableOnDisk.createInstance(fileManager, n, this.hashtable_threshold);
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                    hashtableOnDisk.put(object, new Long(l2));
                } else {
                    l2 = l;
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                    if (hashtableOnDisk2.size() < valueSet.size()) {
                        hashtableOnDisk2.tempTableSize = this.calculateTableSize(object, valueSet.size());
                    }
                    hashtableOnDisk2.clear();
                }
                Iterator iterator = valueSet.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    hashtableOnDisk2.put(e, "");
                }
                hashtableOnDisk2.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1548", this);
                this.traceDebug("writeValueSet()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delValueSet(HashtableOnDisk hashtableOnDisk, Object object) {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                Long l = (Long)hashtableOnDisk.get(object);
                HashtableOnDisk hashtableOnDisk2 = null;
                if (l != null) {
                    long l2 = l;
                    FileManager fileManager = hashtableOnDisk.getFileManager();
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                    hashtableOnDisk2.clear();
                    hashtableOnDisk2.close();
                    HashtableOnDisk.destroyInstance(fileManager, l2);
                    hashtableOnDisk.remove(object);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1600", this);
                this.traceDebug("delValueSet()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delValueSetEntry(HashtableOnDisk hashtableOnDisk, Object object, Object object2) {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                Long l = (Long)hashtableOnDisk.get(object);
                HashtableOnDisk hashtableOnDisk2 = null;
                if (l != null) {
                    long l2 = l;
                    FileManager fileManager = hashtableOnDisk.getFileManager();
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                    hashtableOnDisk2.remove(object2);
                    if (hashtableOnDisk2.size() == 0) {
                        HashtableOnDisk.destroyInstance(fileManager, l2);
                        hashtableOnDisk.remove(object);
                    }
                    hashtableOnDisk2.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1647", this);
                this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeValueSetEntry(HashtableOnDisk hashtableOnDisk, Object object, Object object2) {
        boolean bl = false;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            try {
                Long l = (Long)hashtableOnDisk.get(object);
                HashtableOnDisk hashtableOnDisk2 = null;
                long l2 = 0L;
                FileManager fileManager = hashtableOnDisk.getFileManager();
                if (l == null) {
                    l2 = HashtableOnDisk.createInstance(fileManager, this.initial_valueset_size, this.hashtable_threshold);
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                    hashtableOnDisk.put(object, new Long(l2));
                } else {
                    bl = true;
                    l2 = l;
                    hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, this);
                }
                hashtableOnDisk2.put(object2, "");
                hashtableOnDisk2.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1707", this);
                this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
        return bl;
    }

    public int getNumObjects() {
        this.readWriteLock.preRead();
        int n = Math.max(this.object_cache.size(), 0);
        if (!this.disableDependencyId) {
            n += Math.max(this.dependency_cache.size(), 0);
        }
        if (!this.disableTemplatesSupport) {
            n += Math.max(this.template_cache.size(), 0);
        }
        this.readWriteLock.postRead();
        return n;
    }

    public String cacheType() {
        return "htod";
    }

    public void dump_htod_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_htod_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_filemgr_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_stats_header(Writer writer) {
        try {
            this.object_cache.dump_stats_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_header(Writer writer) {
        try {
            this.object_cache.dump_filemgr_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reset_stats() {
        this.object_cache.reset_stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        boolean bl = false;
        if (!this.invalidationBuffer.contains(object)) {
            try {
                this.readWriteLock.preRead();
                bl = this.object_cache.containsKey(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.containsKey", "1782", this);
                this.traceDebug("containsKey()", "cacheName=" + this.cache.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postRead();
            }
        }
        return bl;
    }

    protected void removeExpiredCache(long l, boolean bl) {
        if (this.object_cache == null) {
            return;
        }
        this.deletedSize = 0L;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (this.getCacheIdsSize() > 0) {
            String string = "  DiskCacheSize=" + this.getCacheIdsSize() + "  DepIdsSize=" + this.getDepIdsSize() + "  TemplatesSize=" + this.getTemplatesSize() + "  Scan=" + bl + "  InvalidationBuffer1=" + this.invalidationBuffer.size(true) + "  InvalidationBuffer2=" + this.invalidationBuffer.size(false);
            Tr.info((TraceComponent)tc, (String)"DYNA0057I", (Object)new Object[]{this.cache.cacheName, string});
            int n = 0;
            boolean bl2 = false;
            ValueSet valueSet = new ValueSet(50);
            do {
                int n2 = 0;
                this.scanExpiredTime = 0L;
                if (bl && this.invalidationBuffer.size() < this.cod.invalidationBufferSize) {
                    if (this.invalidationBuffer.isLoopOnce()) break;
                    bl2 = this.readExpiredByRange(this.object_cache, valueSet, n, 50, l);
                    l3 += this.scanExpiredTime;
                    n2 = valueSet.size();
                    if (n2 > 0) {
                        this.invalidationBuffer.add(valueSet, false);
                        valueSet.clear();
                    }
                    Thread.yield();
                } else if (!bl) {
                    bl2 = true;
                }
                Object object = null;
                int n3 = 0;
                long l7 = 0L;
                do {
                    int n4;
                    object = null;
                    if (this.invalidationBuffer.isLoopOnce()) break;
                    long l8 = System.currentTimeMillis();
                    boolean bl3 = true;
                    object = this.invalidationBuffer.get(true);
                    if (object == null) {
                        bl3 = false;
                        object = this.invalidationBuffer.get(false);
                    }
                    if (object != null && (n4 = this.delCacheEntry(object, bl3)) > 0) {
                        long l9 = System.currentTimeMillis() - l8;
                        l4 += l9;
                        l7 += l9;
                        if (bl3) {
                            l5 += (long)n4;
                        } else {
                            l6 += (long)n4;
                        }
                        n3 += n4;
                    }
                    Thread.yield();
                } while (object != null);
                if (n3 <= 0) continue;
                this.traceDebug("removeExpiredCache()", "cacheName=" + this.cache.cacheName + " deleteComplete=" + bl2 + " current expiredEntries=" + n2 + " ScanTime=" + this.scanExpiredTime + " entriesDeleted=" + n3 + " DeleteTime=" + l7);
            } while (!bl2 && !this.invalidationBuffer.isLoopOnce() && ++n > 0);
            string = "  DiskCacheSize=" + this.getCacheIdsSize() + "  DepIdsSize=" + this.getDepIdsSize() + "  TemplatesSize=" + this.getTemplatesSize() + "  TimeElapsed=" + (System.currentTimeMillis() - l2) + "  ScanTime=" + l3 + "  DeleteTime=" + l4 + "  CacheEntriesDeleted=" + l5 + " ExpiredCacheEntriesDeleted=" + l6 + " TotalDeletedSize=" + this.deletedSize;
            Tr.info((TraceComponent)tc, (String)"DYNA0058I", (Object)new Object[]{this.cache.cacheName, string});
        }
        if (this.invalidationBuffer.isLoopOnce()) {
            this.invalidationBuffer.setLoopOnce(false);
        }
        this.invalidationBuffer.setlastRemoveTime();
    }

    private int calculateTableSize(Object object, int n) {
        int n2 = this.initial_valueset_size;
        boolean bl = false;
        do {
            if (n > n2) {
                n2 = n2 * 2 + 1;
                continue;
            }
            float f = (float)n2 / (float)n;
            if ((double)f < 1.5) {
                n2 = n2 * 2 + 1;
            }
            bl = true;
        } while (!bl);
        this.traceDebug("calculateTableSize()", "cacheName=" + this.cache.cacheName + " id=" + object + " size=" + n + " tableSize=" + n2);
        return n2;
    }

    public void returnToHashtableEntryPool(HashtableEntry hashtableEntry) {
        if (hashtableEntry != null) {
            hashtableEntry.reset();
            this.htEntryPool.add(hashtableEntry);
        }
    }

    public HashtableEntry getFromHashtableEntryPool() {
        return (HashtableEntry)this.htEntryPool.remove();
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " " + string2));
        }
    }

    class DynaAction
    implements HashtableAction {
        ValueSet expiredIds;
        int notExpiredCount = 0;
        long invalInterval;

        DynaAction(ValueSet valueSet, long l) {
            this.expiredIds = valueSet;
            this.invalInterval = l;
            this.notExpiredCount = this.notExpiredCount;
        }

        public boolean execute(HashtableEntry hashtableEntry) throws Exception {
            if (hashtableEntry.getGrace() == -1L && (hashtableEntry.isExpired() || hashtableEntry.expire_last_referenced(this.invalInterval))) {
                this.expiredIds.add(hashtableEntry.getKey());
            } else {
                ++this.notExpiredCount;
            }
            HTODDynacache.this.returnToHashtableEntryPool(hashtableEntry);
            return true;
        }
    }

    class ValueSetReadCallback
    implements HashtableAction {
        ValueSet ids;
        ValueSet expiredIds;

        ValueSetReadCallback(ValueSet valueSet, ValueSet valueSet2) {
            this.ids = valueSet;
            this.expiredIds = valueSet2;
        }

        public boolean execute(HashtableEntry hashtableEntry) throws Exception {
            if (this.expiredIds != null && hashtableEntry.getGrace() == -1L && hashtableEntry.isExpired()) {
                this.expiredIds.add(hashtableEntry.getKey());
            } else {
                this.ids.add(hashtableEntry.getKey());
            }
            HTODDynacache.this.returnToHashtableEntryPool(hashtableEntry);
            return true;
        }
    }

    static class HashtableEntryObjectPool
    extends ObjectPool {
        public HashtableEntryObjectPool(int n) {
            super("HashtableEntryPool", n);
        }

        public Object createObject() {
            return new HashtableEntry();
        }
    }
}

