/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.util.Enumeration;

public class HTODDependencyTable {
    public static final int DEP_ID_TABLE = 1;
    public static final int TEMPLATE_TABLE = 2;
    public static final int OK = 0;
    public static final int NOT_FOUND = 1;
    public static final boolean ADD_TO_NOT_UPDATED_TABLE = true;
    private static TraceComponent tc = Trace.register(DependencyTable.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private FastHashtable dependencyToEntryTable = null;
    private FastHashtable dependencyNotUpdatedTable = null;
    private int type;
    private int maxSize;
    private int entryRemove;
    public int delayOffloadEntriesLimit;
    private HTODDynacache htod;

    public HTODDependencyTable(int n, int n2, int n3, int n4, int n5, HTODDynacache hTODDynacache) {
        this.type = n;
        this.dependencyToEntryTable = new FastHashtable(n2);
        this.dependencyNotUpdatedTable = new FastHashtable(n2 / 2);
        this.maxSize = n3;
        this.entryRemove = n4;
        this.delayOffloadEntriesLimit = n5;
        this.htod = hTODDynacache;
    }

    public void add(Object object, ValueSet valueSet, Object object2) {
        this.dependencyNotUpdatedTable.remove(object);
        valueSet.add(object2);
        if (valueSet.size() > this.delayOffloadEntriesLimit) {
            if (this.type == 1) {
                this.htod.writeValueSet(this.htod.dependency_cache, object, valueSet);
            } else {
                this.htod.writeValueSet(this.htod.template_cache, object, valueSet);
            }
            this.dependencyToEntryTable.remove(object);
        }
    }

    public void add(Object object, ValueSet valueSet, boolean bl) {
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            this.reduceTableSize();
        }
        if (bl) {
            this.dependencyNotUpdatedTable.put(object, valueSet);
        }
        this.dependencyToEntryTable.put(object, valueSet);
    }

    public void add(Object object, Object object2, boolean bl) {
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            this.reduceTableSize();
        }
        ValueSet valueSet = new ValueSet(4);
        valueSet.add(object2);
        if (bl) {
            this.dependencyNotUpdatedTable.put(object, valueSet);
        }
        this.dependencyToEntryTable.put(object, valueSet);
    }

    public void replace(Object object, ValueSet valueSet) {
        this.dependencyNotUpdatedTable.remove(object);
        if (valueSet.size() > this.delayOffloadEntriesLimit) {
            this.dependencyToEntryTable.remove(object);
            if (this.type == 1) {
                this.htod.writeValueSet(this.htod.dependency_cache, object, valueSet);
            } else {
                this.htod.writeValueSet(this.htod.template_cache, object, valueSet);
            }
        } else {
            this.dependencyToEntryTable.put(object, valueSet);
        }
    }

    public void removeDependency(Object object) {
        this.dependencyNotUpdatedTable.remove(object);
        this.dependencyToEntryTable.remove(object);
    }

    public int removeEntry(Object object, Object object2) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            return 1;
        }
        valueSet.remove(object2);
        this.dependencyNotUpdatedTable.remove(object);
        if (valueSet.size() == 0) {
            this.dependencyToEntryTable.remove(object);
            if (this.type == 1) {
                this.htod.delValueSet(this.htod.dependency_cache, object);
            } else {
                this.htod.delValueSet(this.htod.template_cache, object);
            }
        }
        return 0;
    }

    public void clear() {
        this.dependencyToEntryTable.clear();
        this.dependencyNotUpdatedTable.clear();
    }

    public Enumeration getKeys() {
        return this.dependencyToEntryTable.keys();
    }

    public Enumeration getNotUpdateKeys() {
        return this.dependencyNotUpdatedTable.keys();
    }

    public ValueSet getEntries(Object object) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        return valueSet;
    }

    public boolean isEmpty() {
        return this.dependencyToEntryTable.isEmpty();
    }

    public boolean isUpdated(Object object) {
        return !this.dependencyNotUpdatedTable.contains(object);
    }

    private void reduceTableSize() {
        Object object;
        int n = this.entryRemove;
        if (this.dependencyNotUpdatedTable.size() > 0) {
            Enumeration enumeration = this.dependencyNotUpdatedTable.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.dependencyNotUpdatedTable.remove(object);
                this.dependencyToEntryTable.remove(object);
                if (--n != 0) continue;
            }
        }
        if (n > 0) {
            int n2 = 5;
            while (n > 0) {
                object = this.dependencyToEntryTable.keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(e);
                    if (valueSet.size() < n2) {
                        if (this.type == 1) {
                            this.htod.writeValueSet(this.htod.dependency_cache, e, valueSet);
                        } else {
                            this.htod.writeValueSet(this.htod.template_cache, e, valueSet);
                        }
                        this.dependencyToEntryTable.remove(e);
                        --n;
                    }
                    if (n != 0) continue;
                }
                n2 += 3;
            }
        }
    }
}

