/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ExternalCacheAdapter;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;

public class ExternalCacheGroup
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(ExternalCacheGroup.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final int SHARED = 0;
    public static final int NOT_SHARED = 1;
    private String id = null;
    private int type = 0;
    private Hashtable addressToBeanName = new Hashtable();
    private Hashtable addressToBean = new Hashtable();
    private ExternalCacheAdapter[] adapters = new ExternalCacheAdapter[0];

    public ExternalCacheGroup(String string, int n) {
        this.id = string;
        this.type = n;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public void addExternalCacheAdapter(String string, String string2) {
        Object v;
        ExternalCacheAdapter externalCacheAdapter = null;
        try {
            externalCacheAdapter = ExternalCacheGroup.initializeAdapter(string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.servlet.ExternalCacheGroup.addExternalCacheAdapter", "92", this);
            Tr.error((TraceComponent)tc, (String)"dynacache.externaladaptererror", (Object)exception.getMessage());
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding externalCache: " + this.id + " " + string + " " + string2));
        }
        if ((v = this.addressToBeanName.get(string)) != null) {
            Tr.error((TraceComponent)tc, (String)"dynacache.externaldup", (Object)string);
        }
        this.addressToBeanName.put(string, string2);
        this.addressToBean.put(string, externalCacheAdapter);
        this.adapters = this.addressToBean.values().toArray(new ExternalCacheAdapter[0]);
    }

    public void removeExternalCacheAdapter(String string) {
        this.addressToBean.remove(string);
        this.addressToBeanName.remove(string);
        this.adapters = this.addressToBean.values().toArray(new ExternalCacheAdapter[0]);
    }

    public void invalidatePages(ValueSet valueSet) {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].invalidatePages(valueSet.iterator());
        }
    }

    public void invalidateIds(HashMap hashMap) {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].invalidateIds(hashMap.keySet().iterator());
        }
    }

    public void clear() {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].clear();
        }
    }

    public void invalidateIds(HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ValueSet valueSet = (ValueSet)iterator.next();
            if (valueSet == null || valueSet.size() <= 0) continue;
            for (int i = 0; i < this.adapters.length; ++i) {
                this.adapters[i].invalidateIds(valueSet.iterator());
            }
        }
    }

    public void writePages(ArrayList arrayList) {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].writePages(arrayList.iterator());
        }
    }

    private static ExternalCacheAdapter initializeAdapter(String string, String string2) throws IOException, ClassNotFoundException {
        Class<?> clazz = ExternalCacheGroup.class.getClassLoader().loadClass(string2);
        try {
            ExternalCacheAdapter externalCacheAdapter = (ExternalCacheAdapter)clazz.newInstance();
            externalCacheAdapter.setAddress(string);
            return externalCacheAdapter;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.servlet.ExternalCacheGroup.initializeAdapter", "163", null);
            throw new ClassNotFoundException(string2);
        }
    }

    public void preInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].preInvoke(servletCacheRequest, httpServletResponse);
        }
    }

    public void postInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        for (int i = 0; i < this.adapters.length; ++i) {
            this.adapters[i].postInvoke(servletCacheRequest, httpServletResponse);
        }
    }
}

