/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.util.ObjectPool;
import java.io.Serializable;
import java.util.Enumeration;

public class EntryInfo
implements com.ibm.websphere.cache.EntryInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc;
    public static final int NOT_SHARED = 1;
    public static final int SHARED_PUSH = 2;
    public static final int SHARED_PULL = 3;
    public static final int SHARED_PUSH_PULL = 4;
    protected static final boolean SET = true;
    protected static final boolean UNSET = false;
    private boolean expirationTimeFlag = false;
    private boolean inactivityFlag = false;
    private boolean idFlag = false;
    private boolean priorityFlag = false;
    private boolean sharingPolicyFlag = false;
    private boolean lock = false;
    protected Object id = null;
    protected Object userMetaData = null;
    protected int timeLimit = -1;
    protected int inactivity = -1;
    protected long expirationTime = -1L;
    protected int priority = -1;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    protected boolean useBatch = false;
    public ValueSet templates = new ValueSet(4);
    private String template = null;
    public ValueSet dataIds = new ValueSet(4);
    public ValueSet aliasList = new ValueSet(4);
    private transient EntryInfoPool entryInfoPool = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void reset() {
        this.expirationTimeFlag = false;
        this.inactivityFlag = false;
        this.idFlag = false;
        this.priorityFlag = false;
        this.sharingPolicyFlag = false;
        this.lock = false;
        this.id = null;
        this.timeLimit = -1;
        this.inactivity = -1;
        this.expirationTime = -1L;
        this.priority = -1;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.useBatch = false;
        this.templates.clear();
        this.template = null;
        this.dataIds.clear();
        this.aliasList.clear();
        this.userMetaData = null;
        this.entryInfoPool = null;
    }

    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    public Object getIdObject() {
        return this.id;
    }

    public void setId(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.idFlag = true;
        this.id = object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set id=" + object));
        }
    }

    public void setId(String string) {
        this.setId((Object)string);
    }

    boolean wasIdSet() {
        return this.idFlag;
    }

    public boolean isBatchEnabled() {
        return ServerCache.isBatchEnabled();
    }

    public void setBatchEnabled(boolean bl) {
        this.useBatch = bl;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public boolean getPersistToDisk() {
        return this.persistToDisk;
    }

    public void setSharingPolicy(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.sharingPolicyFlag = true;
        this.sharingPolicy = n;
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Illegal sharing policy: " + n);
        }
    }

    public void setPersistToDisk(boolean bl) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.persistToDisk = bl;
    }

    boolean wasSharingPolicySet() {
        return this.sharingPolicyFlag;
    }

    public boolean isNotShared() {
        return this.sharingPolicy == 1;
    }

    public boolean isSharedPush() {
        return this.sharingPolicy == 2 || this.sharingPolicy == 4;
    }

    public boolean isSharedPull() {
        return this.sharingPolicy == 3 || this.sharingPolicy == 4;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.timeLimit = n;
        if (n > 0) {
            long l = (long)n * 1000L;
            this.expirationTime = l + System.currentTimeMillis();
        }
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public void setInactivity(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.inactivityFlag = true;
        this.inactivity = n;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long l) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.expirationTime = l;
        this.timeLimit = (int)((l - System.currentTimeMillis()) / 1000L);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.priorityFlag = true;
        this.priority = n;
    }

    public boolean wasPrioritySet() {
        return this.priorityFlag;
    }

    public Enumeration getTemplates() {
        return this.templates.elements();
    }

    public String getTemplate() {
        return (String)this.templates.getOne();
    }

    public void addTemplate(String string) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.templates.add(string);
    }

    public Enumeration getDataIds() {
        return this.dataIds.elements();
    }

    public void addDataId(String string) {
        this.addDataId((Object)string);
    }

    public void addDataId(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.dataIds.add(object);
    }

    public void unionDependencies(com.ibm.websphere.cache.EntryInfo entryInfo) {
        EntryInfo entryInfo2 = (EntryInfo)entryInfo;
        if (entryInfo2 == this) {
            return;
        }
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.dataIds.union(entryInfo2.dataIds);
        this.templates.union(entryInfo2.templates);
        if (entryInfo2.id != null) {
            this.dataIds.add(entryInfo2.id);
        }
        if (this.expirationTimeFlag) {
            this.setTimeLimit(entryInfo2.timeLimit);
        } else if (entryInfo2.timeLimit == -1 || entryInfo2.timeLimit != -1 && entryInfo2.timeLimit < this.timeLimit) {
            this.timeLimit = entryInfo2.timeLimit;
        }
        if (this.inactivityFlag) {
            this.setInactivity(entryInfo2.inactivity);
        } else if (entryInfo2.inactivity == -1 || entryInfo2.inactivity != -1 && entryInfo2.inactivity < this.inactivity) {
            this.inactivity = entryInfo2.inactivity;
        }
    }

    final void lock() {
        this.lock = true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Enumeration getAliasList() {
        return this.aliasList.elements();
    }

    public void addAlias(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.aliasList.add(object);
    }

    public Object getUserMetaData() {
        return this.userMetaData;
    }

    public void setUserMetaData(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.userMetaData = object;
    }

    public static EntryInfoPool createEntryInfoPool(String string, int n) {
        EntryInfoPool entryInfoPool = new EntryInfoPool(string, n);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntryInfoPool() poolName=" + string));
        }
        return entryInfoPool;
    }

    public void returnToPool() {
        EntryInfoPool entryInfoPool = this.entryInfoPool;
        if (!$assertionsDisabled && this.entryInfoPool == null) {
            throw new AssertionError();
        }
        this.reset();
        entryInfoPool.add(this);
    }

    static {
        $assertionsDisabled = !EntryInfo.class.desiredAssertionStatus();
        tc = Trace.register(EntryInfo.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    }

    static class EntryInfoPool
    extends ObjectPool {
        private boolean disableDependencyId = false;
        private String poolName = null;

        public EntryInfoPool(String string, int n) {
            super(string, n);
            this.poolName = string;
        }

        public Object createObject() {
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.reset();
            return entryInfo;
        }

        public EntryInfo allocate(Object object, Object[] objectArray, Object[] objectArray2) {
            int n;
            EntryInfo entryInfo = (EntryInfo)this.remove();
            entryInfo.entryInfoPool = this;
            entryInfo.setId(object);
            if (objectArray != null && !this.disableDependencyId) {
                for (n = 0; n < objectArray.length; ++n) {
                    entryInfo.addDataId(objectArray[n]);
                }
            }
            if (objectArray2 != null) {
                for (n = 0; n < objectArray2.length; ++n) {
                    entryInfo.addAlias(objectArray2[n]);
                }
            }
            return entryInfo;
        }

        public void setFeatures(CacheConfig cacheConfig) {
            this.disableDependencyId = cacheConfig.disableDependencyId;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setFeatures() poolName=" + this.poolName + " disableDependencyId=" + cacheConfig.disableDependencyId));
            }
        }
    }
}

