/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.cache.EventSourceIntf;
import java.util.HashSet;

public class DCEventSource
implements EventSourceIntf {
    static final InvalidationListener[] EMPTY_INV_LISTENERS = new InvalidationListener[0];
    static final ChangeListener[] EMPTY_CHANGE_LISTENERS = new ChangeListener[0];
    private int invalidationListenerCount = 0;
    private int changeListenerCount = 0;
    private boolean bUpdateInvalidationListener = false;
    private boolean bUpdateChangeListener = false;
    private HashSet hsInvalidationListeners = new HashSet(2);
    private HashSet hsChangeListeners = new HashSet(2);
    private InvalidationListener[] currentInvalidationListeners = EMPTY_INV_LISTENERS;
    private ChangeListener[] currentChangeListeners = EMPTY_CHANGE_LISTENERS;

    public int getInvalidationListenerCount() {
        return this.invalidationListenerCount;
    }

    public int getChangeListenerCount() {
        return this.changeListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(InvalidationEvent invalidationEvent) {
        if (this.bUpdateInvalidationListener) {
            HashSet hashSet = this.hsInvalidationListeners;
            synchronized (hashSet) {
                if (this.invalidationListenerCount > 0) {
                    this.currentInvalidationListeners = new InvalidationListener[this.invalidationListenerCount];
                    this.hsInvalidationListeners.toArray(this.currentInvalidationListeners);
                } else {
                    this.currentInvalidationListeners = EMPTY_INV_LISTENERS;
                }
                this.bUpdateInvalidationListener = false;
            }
        }
        for (int i = 0; i < this.currentInvalidationListeners.length; ++i) {
            this.currentInvalidationListeners[i].fireEvent(invalidationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvalidationListener invalidationListener) {
        HashSet hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.add(invalidationListener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvalidationListener invalidationListener) {
        HashSet hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.remove(invalidationListener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheEntryChanged(ChangeEvent changeEvent) {
        if (this.bUpdateChangeListener) {
            HashSet hashSet = this.hsChangeListeners;
            synchronized (hashSet) {
                if (this.changeListenerCount > 0) {
                    this.currentChangeListeners = new ChangeListener[this.changeListenerCount];
                    this.hsChangeListeners.toArray(this.currentChangeListeners);
                } else {
                    this.currentChangeListeners = EMPTY_CHANGE_LISTENERS;
                }
                this.bUpdateChangeListener = false;
            }
        }
        for (int i = 0; i < this.currentChangeListeners.length; ++i) {
            this.currentChangeListeners[i].cacheEntryChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener changeListener) {
        HashSet hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.add(changeListener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChangeListener changeListener) {
        HashSet hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.remove(changeListener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }
}

