/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.asynchbeans.EventSource;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.asynchbeans.WorkManagerImpl;
import com.ibm.ws.asynchbeans.WorkManagerProperties;
import com.ibm.ws.cache.EventSourceIntf;
import java.util.ArrayList;
import java.util.HashSet;

public class DCAsyncEventSource
implements EventSourceIntf {
    static WorkManagerImpl _manager = null;
    EventSource _eventSourceIL;
    InvalidationListener _invalidationListeners;
    EventSource _eventSourceCL;
    ChangeListener _changeListeners;
    private HashSet _hsInvalidationListeners = new HashSet(2);
    private HashSet _hsChangeListeners = new HashSet(2);
    private int _invalidationListenerCount = 0;
    private int _changeListenerCount = 0;

    public DCAsyncEventSource() {
        if (_manager == null) {
            WorkManagerProperties workManagerProperties = new WorkManagerProperties();
            workManagerProperties.name = "com.ibm.ws.cache.DCAsyncEventSource";
            workManagerProperties.isGrowable = true;
            workManagerProperties.numAlarmThreads = 0;
            workManagerProperties.minThreads = 0;
            workManagerProperties.maxThreads = 10;
            workManagerProperties.isExcluded = true;
            workManagerProperties.enabledServices = new ArrayList();
            _manager = new WorkManagerImpl(workManagerProperties);
        }
        this._eventSourceIL = _manager.createEventSource();
        this._eventSourceCL = _manager.createEventSource();
        this._invalidationListeners = (InvalidationListener)this._eventSourceIL.getEventTrigger(InvalidationListener.class);
        this._changeListeners = (ChangeListener)this._eventSourceCL.getEventTrigger(ChangeListener.class);
    }

    public int getInvalidationListenerCount() {
        return this._invalidationListenerCount;
    }

    public int getChangeListenerCount() {
        return this._changeListenerCount;
    }

    public void fireEvent(InvalidationEvent invalidationEvent) {
        this._invalidationListeners.fireEvent(invalidationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvalidationListener invalidationListener) {
        this._eventSourceIL.addListener((Object)invalidationListener);
        HashSet hashSet = this._hsInvalidationListeners;
        synchronized (hashSet) {
            this._hsInvalidationListeners.add(invalidationListener);
            this._invalidationListenerCount = this._hsInvalidationListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvalidationListener invalidationListener) {
        this._eventSourceIL.removeListener((Object)invalidationListener);
        HashSet hashSet = this._hsInvalidationListeners;
        synchronized (hashSet) {
            this._hsInvalidationListeners.remove(invalidationListener);
            this._invalidationListenerCount = this._hsInvalidationListeners.size();
        }
    }

    public void cacheEntryChanged(ChangeEvent changeEvent) {
        this._changeListeners.cacheEntryChanged(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener changeListener) {
        this._eventSourceCL.addListener((Object)changeListener);
        HashSet hashSet = this._hsChangeListeners;
        synchronized (hashSet) {
            this._hsChangeListeners.add(changeListener);
            this._changeListenerCount = this._hsChangeListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChangeListener changeListener) {
        this._eventSourceCL.removeListener((Object)changeListener);
        HashSet hashSet = this._hsChangeListeners;
        synchronized (hashSet) {
            this._hsChangeListeners.remove(changeListener);
            this._changeListenerCount = this._hsChangeListeners.size();
        }
    }
}

