/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheStatisticsListener;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheGroup;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullNotificationService;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import com.ibm.ws.cache.drs.DRSRemoteServices;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CacheUnitImpl
implements CacheUnit {
    private static TraceComponent tc = Trace.register(CacheUnitImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private String uniqueCacheName = null;
    private Cache cache = null;
    private CommandCache commandCache = null;
    private ExternalCacheServices externalCacheServices = null;
    private CommandStoragePolicy commandStoragePolicy = null;
    private JSPCache jspCache = null;
    protected CacheConfig cacheConfig = null;
    protected BatchUpdateDaemon batchUpdateDaemon = null;
    protected InvalidationAuditDaemon invalidationAuditDaemon = null;
    protected NotificationService notificationService = null;
    protected RemoteServices remoteServices = null;
    protected TimeLimitDaemon timeLimitDaemon = null;
    private CacheStatisticsListener cacheStatisticsListener = null;
    private static boolean isDrsNotification = false;
    private String processType = AdminServiceFactory.getAdminService().getProcessType();

    public CacheUnitImpl(CacheService cacheService) throws RemoteException {
        this.initialize(cacheService);
    }

    public String getUniqueCacheName() {
        return this.uniqueCacheName;
    }

    public void batchUpdate(String string, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("batchUpdate():" + string));
        }
        this.invalidationAuditDaemon.registerInvalidations(hashMap.values().iterator());
        this.invalidationAuditDaemon.registerInvalidations(hashMap2.values().iterator());
        arrayList = this.invalidationAuditDaemon.filterEntryList(arrayList);
        Cache cache = ServerCache.getCache(string);
        if (cache != null) {
            cache.batchUpdate(hashMap, hashMap2, arrayList);
            if (cache.getCacheConfig().enableServletSupport) {
                this.externalCacheServices.invalidateExternalCaches(hashMap, hashMap2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"batchUpdate()");
        }
    }

    public CacheableCommand getCommand(CacheableCommand cacheableCommand, boolean bl) throws CommandException {
        return this.commandCache.getCommandLocally(cacheableCommand, bl);
    }

    public CacheEntry getEntry(String string, Object object, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEntry: {0}", (Object)object);
        }
        Cache cache = this.getCache(string);
        CacheEntry cacheEntry = null;
        if (cache != null) {
            cacheEntry = (CacheEntry)cache.getEntry(object, 2, bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEntry: {0}", (Object)object);
        }
        return cacheEntry;
    }

    public static boolean isDRSNotification() {
        return isDrsNotification;
    }

    public void setEntry(String string, CacheEntry cacheEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setEntry: {0}", (Object)cacheEntry.id);
        }
        if ((cacheEntry = this.invalidationAuditDaemon.filterEntry(cacheEntry)) != null) {
            Cache cache = this.getCache(string);
            cache.setEntry(cacheEntry, 2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setEntry: {0}", (Object)(cacheEntry == null ? "null" : cacheEntry.id));
        }
    }

    public void setExternalCacheFragment(ExternalCacheFragment externalCacheFragment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setExternalCacheFragment: {0}", (Object)externalCacheFragment.getUri());
        }
        if ((externalCacheFragment = this.invalidationAuditDaemon.filterExternalCacheFragment(externalCacheFragment)) != null) {
            this.batchUpdateDaemon.pushExternalCacheFragment(externalCacheFragment, this.cache);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setExternalCacheFragment: {0}", (Object)externalCacheFragment.getUri());
        }
    }

    public void addExternalCacheAdapter(String string, String string2, String string3) {
        this.externalCacheServices.addExternalCacheAdapter(string, string2, string3);
    }

    public void removeExternalCacheAdapter(String string, String string2) {
        this.externalCacheServices.removeExternalCacheAdapter(string, string2);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Cache getCache(String string) {
        return ServerCache.getCache(string);
    }

    public CommandCache getCommandCache() {
        return this.commandCache;
    }

    public ExternalCacheServices getExternalCacheServices() {
        return this.externalCacheServices;
    }

    public CommandStoragePolicy getCommandStoragePolicy() {
        return this.commandStoragePolicy;
    }

    public JSPCache getJSPCache() {
        return this.jspCache;
    }

    private void initialize(CacheService cacheService) {
        this.commandStoragePolicy = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.cacheConfig = cacheService.getCacheConfig();
        try {
            this.uniqueCacheName = this.cacheConfig.serverNameFQ;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Initializing CacheUnit " + this.uniqueCacheName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("batchUpdateInterval set to " + this.cacheConfig.batchUpdateInterval));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("timeHoldingInvalidations set to " + this.cacheConfig.timeHoldingInvalidations));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheSprayerName set to " + this.cacheConfig.cacheSprayerName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notificationType set to " + this.cacheConfig.notificationType));
            }
            if (this.cacheConfig.notificationType.equalsIgnoreCase("DRS")) {
                isDrsNotification = true;
                this.notificationService = cacheService.getDRSNotificationService();
            } else {
                isDrsNotification = false;
                this.notificationService = new NullNotificationService();
                ServerCache.setSharingPolicy(1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheSize set to " + this.cacheConfig.cacheSize));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cachePriority set to " + this.cacheConfig.cachePriority));
            }
            try {
                this.cacheStatisticsListener = (CacheStatisticsListener)this.getClass().getClassLoader().loadClass(this.cacheConfig.cacheStatisticsListenerBeanName).newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheUnitImpl.initialize", "471", this);
                throwable.printStackTrace();
                Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)throwable.getMessage());
                throw new IllegalArgumentException("cacheStatisticsListener must fully specify a bean name for an object of type com.ibm.ws.cache.CacheStatisticsListener");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheStatisticsListener created from class " + this.cacheConfig.cacheStatisticsListenerBeanName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jspCachePriority set to " + this.cacheConfig.jspCachePriority));
            }
            try {
                this.commandStoragePolicy = (CommandStoragePolicy)this.getClass().getClassLoader().loadClass(this.cacheConfig.commandStoragePolicyClassName).newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheUnitImpl.initialize", "488", this);
                throwable.printStackTrace();
                Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)throwable.getMessage());
                throw new IllegalArgumentException("commandStoragePolicy must fully specify a bean name for an object of type com.ibm.ws.cache.command.CommandStoragePolicy");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("commandCachePriority set to " + this.cacheConfig.commandCachePriority));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("commandStoragePolicy created from class " + this.cacheConfig.commandStoragePolicyClassName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("maxTimeLimitInSeconds set to " + this.cacheConfig.maxTimeLimitInSeconds));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("timeGranularityInSeconds set to " + this.cacheConfig.timeGranularityInSeconds));
            }
            this.batchUpdateDaemon = new BatchUpdateDaemon(this.cacheConfig.batchUpdateInterval);
            this.cacheConfig.cache = this.cache = new Cache("baseCache", this.cacheConfig);
            this.commandCache = new CommandCache();
            this.externalCacheServices = new ExternalCacheServices();
            this.jspCache = new JSPCache();
            this.remoteServices = !isDrsNotification ? new NullRemoteServices() : new DRSRemoteServices();
            this.invalidationAuditDaemon = new InvalidationAuditDaemon(this.cacheConfig.timeHoldingInvalidations);
            this.timeLimitDaemon = new TimeLimitDaemon(this.cacheConfig.maxTimeLimitInSeconds, this.cacheConfig.timeGranularityInSeconds);
            this.batchUpdateDaemon.setExternalCacheServices(this.externalCacheServices);
            this.batchUpdateDaemon.setInvalidationAuditDaemon(this.invalidationAuditDaemon);
            this.cache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.cache.setRemoteServices(this.remoteServices);
            this.cache.setTimeLimitDaemon(this.timeLimitDaemon);
            this.cache.setDefaultPriority(this.cacheConfig.cachePriority);
            this.cache.setCacheStatisticsListener(this.cacheStatisticsListener);
            this.commandCache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.commandCache.setCache(this.cache);
            this.commandCache.setRemoteServices(this.remoteServices);
            this.commandCache.setDefaultPriority(this.cacheConfig.commandCachePriority);
            this.commandCache.setCommandStoragePolicy(this.commandStoragePolicy);
            this.jspCache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.jspCache.setCache(this.cache);
            this.jspCache.setRemoteServices(this.remoteServices);
            this.jspCache.setDefaultPriority(this.cacheConfig.jspCachePriority);
            this.jspCache.setExternalCacheServices(this.externalCacheServices);
            this.remoteServices.setCacheUnit(this.uniqueCacheName, this);
            this.remoteServices.setNotificationService(this.notificationService);
            if (!this.processType.equals("DeploymentManager")) {
                HashMap hashMap = null;
                hashMap = this.initializeExternalCacheGroups(this.cacheConfig.externalGroups);
                this.externalCacheServices.setExternalCacheGroups(hashMap);
            }
            this.batchUpdateDaemon.start();
            this.cache.start();
            this.cacheStatisticsListener.start();
            this.commandCache.start();
            this.externalCacheServices.start();
            this.jspCache.start();
            this.invalidationAuditDaemon.start();
            this.notificationService.setCacheName("baseCache");
            this.remoteServices.setCacheName("baseCache");
            this.notificationService.start();
            this.remoteServices.start();
            this.timeLimitDaemon.start();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering this cache unit with any other live cache units...");
            }
            this.notificationService.registerCacheUnit(this.uniqueCacheName, this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"succeeded");
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.CacheUnitImpl.initialize", "640", this);
            throw illegalStateException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheUnitImpl.initialize", "644", this);
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)exception.getMessage());
            throw new IllegalStateException("Unexpected exception in Configuration.initializeDynacache method.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    private HashMap initializeExternalCacheGroups(List list) {
        HashMap<String, ExternalCacheGroup> hashMap = new HashMap<String, ExternalCacheGroup>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CacheConfig.ExternalCacheGroup externalCacheGroup = (CacheConfig.ExternalCacheGroup)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ecg.name = " + externalCacheGroup.name));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ecg.type = " + externalCacheGroup.type));
                }
                ExternalCacheGroup externalCacheGroup2 = new ExternalCacheGroup(externalCacheGroup.name, externalCacheGroup.type);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("adding External Cache Group id = " + externalCacheGroup.name + ", externalCacheGroup = " + externalCacheGroup2));
                }
                hashMap.put(externalCacheGroup.name, externalCacheGroup2);
                Iterator iterator2 = externalCacheGroup.members.iterator();
                while (iterator2.hasNext()) {
                    CacheConfig.ExternalCacheGroupMember externalCacheGroupMember = (CacheConfig.ExternalCacheGroupMember)iterator2.next();
                    externalCacheGroup2.addExternalCacheAdapter(externalCacheGroupMember.address, externalCacheGroupMember.beanName);
                }
            }
        }
        return hashMap;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void addAlias(String string, Object object, Object[] objectArray) {
        block3: {
            Cache cache;
            if (object != null && objectArray != null && (cache = this.getCache(string)) != null) {
                try {
                    cache.addAlias(object, objectArray, false, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Adding alias for cache id " + object + " failure: " + illegalArgumentException.getMessage()));
                }
            }
        }
    }

    public void removeAlias(String string, Object object) {
        block3: {
            Cache cache;
            if (object != null && (cache = this.getCache(string)) != null) {
                try {
                    cache.removeAlias(object, false, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Removing alias " + object + " failure: " + illegalArgumentException.getMessage()));
                }
            }
        }
    }
}

