/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.cache.webservices.client.JAXRPCEntryInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;

public class CacheEntry
implements com.ibm.websphere.cache.CacheEntry,
InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = -3194658354293955553L;
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    protected transient CacheEntryPool cacheEntryPool = null;
    private static final String[] EMPTY_STRING_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final int CACHE_TYPE_JAXRPC = 1;
    public static int DEFAULT_PRIORITY;
    public static int MAX_PRIORITY;
    public Object id = null;
    protected byte[] serializedId = null;
    protected Object value = null;
    protected byte[] serializedValue = null;
    protected Object userMetaData = null;
    protected byte[] serializedUserMetaData = null;
    protected int priority = DEFAULT_PRIORITY;
    protected int timeLimit = -1;
    protected int inactivity = -1;
    public long expirationTime = -1L;
    protected long drsClock = -1L;
    public long timeStamp = -1L;
    protected String[] _templates = EMPTY_STRING_ARRAY;
    protected Object[] _dataIds = EMPTY_OBJECT_ARRAY;
    protected Object[] _serializedDataIds = null;
    protected boolean invalid = false;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    protected boolean useBatch = false;
    public int cacheType = 0;
    protected boolean useByteBuffer = false;
    protected transient int clock = DEFAULT_PRIORITY;
    protected transient int refCount = 0;
    protected transient boolean removeWhenUnpinned = false;
    protected transient boolean isOverflowEntry = false;
    protected transient boolean lruEvicted = false;
    protected Object[] aliasList = EMPTY_OBJECT_ARRAY;
    protected Object[] serializedAliasList = null;
    protected transient LRUHead lruHead;
    protected transient CacheEntry _previous = null;
    protected transient CacheEntry _next = null;
    protected transient boolean loadedFromDisk = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CacheEntry() {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
    }

    public boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.value != null) {
            try {
                this.serializedValue = SerializationUtility.serialize((Serializable)this.value);
                this.value = null;
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.value != null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object)new Object[]{this.id, this.value.getClass().getName(), string});
                bl = false;
            }
        }
        if (this.serializedId == null && bl) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object)new Object[]{this.id == null ? "null" : this.id.getClass().getName(), this.value == null ? "null" : this.value.getClass().getName(), string});
                bl = false;
            }
        }
        if (this._serializedDataIds == null && this._dataIds.length > 0 && bl) {
            this._serializedDataIds = new Object[this._dataIds.length];
            int n = 0;
            try {
                for (n = 0; n < this._dataIds.length; ++n) {
                    this._serializedDataIds[n] = SerializationUtility.serialize((Serializable)this._dataIds[n]);
                }
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (string != null) {
                if (this._dataIds[n] != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object)new Object[]{this.id, this.value.getClass().getName(), string});
                }
                bl = false;
                this._serializedDataIds = null;
            }
        }
        if (this.serializedAliasList == null && this.aliasList.length > 0 && bl) {
            this.serializedAliasList = new Object[this.aliasList.length];
            int n = 0;
            try {
                for (n = 0; n < this.aliasList.length; ++n) {
                    this.serializedAliasList[n] = SerializationUtility.serialize((Serializable)this.aliasList[n]);
                }
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (string != null) {
                if (this.aliasList[n] != null) {
                    Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object)new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK for alias class name=" + this.aliasList[n].getClass().getName() + " exception=" + string});
                }
                bl = false;
                this.serializedAliasList = null;
            }
        }
        if (this.userMetaData != null) {
            try {
                this.serializedUserMetaData = SerializationUtility.serialize((Serializable)this.userMetaData);
                this.userMetaData = null;
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.userMetaData != null) {
                Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object)new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK for user metadata class name=" + this.userMetaData.getClass().getName() + " exception=" + string});
                bl = false;
            }
        }
        return bl;
    }

    public void processDrsInbound(long l) {
        if (this.drsClock <= 0L) {
            return;
        }
        long l2 = l - this.drsClock;
        if (this.expirationTime > 0L) {
            this.expirationTime += l2;
        }
        if (this.timeStamp > 0L) {
            this.timeStamp += l2;
        }
        this.drsClock = -1L;
    }

    public void processDrsOutbound() {
        if (this.drsClock != -1L) {
            return;
        }
        this.drsClock = System.currentTimeMillis();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        int n;
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + this.value == null ? "null object" : this.value.getClass().getName());
        }
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
        } else {
            objectOutput.writeInt(-1);
        }
        if (this.serializedValue != null) {
            objectOutput.writeInt(this.serializedValue.length);
            objectOutput.write(this.serializedValue);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeInt(this.priority);
        objectOutput.writeInt(this.timeLimit);
        objectOutput.writeInt(this.inactivity);
        objectOutput.writeLong(this.expirationTime);
        objectOutput.writeLong(this.timeStamp);
        objectOutput.writeLong(this.drsClock);
        objectOutput.writeInt(this.cacheType);
        objectOutput.writeObject(this._templates);
        if (this._serializedDataIds != null) {
            objectOutput.writeInt(this._serializedDataIds.length);
            for (n = 0; n < this._serializedDataIds.length; ++n) {
                byArray = (byte[])this._serializedDataIds[n];
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeBoolean(this.invalid);
        objectOutput.writeInt(this.sharingPolicy);
        objectOutput.writeBoolean(this.persistToDisk);
        objectOutput.writeBoolean(this.useBatch);
        objectOutput.writeBoolean(this.useByteBuffer);
        if (this.serializedAliasList != null) {
            objectOutput.writeInt(this.serializedAliasList.length);
            for (n = 0; n < this.serializedAliasList.length; ++n) {
                byArray = (byte[])this.serializedAliasList[n];
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        } else {
            objectOutput.writeInt(-1);
        }
        if (this.serializedUserMetaData != null) {
            objectOutput.writeInt(this.serializedUserMetaData.length);
            objectOutput.write(this.serializedUserMetaData);
        } else {
            objectOutput.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        try {
            int n;
            int n2;
            int n3 = objectInput.readInt();
            if (n3 > 0) {
                this.serializedId = new byte[n3];
                objectInput.readFully(this.serializedId);
            } else {
                this.serializedId = null;
            }
            if (this.serializedId != null) {
                try {
                    this.id = SerializationUtility.deserialize(this.serializedId);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "366", this);
                    exception.printStackTrace();
                }
            } else {
                this.id = null;
            }
            if ((n2 = objectInput.readInt()) > 0) {
                this.serializedValue = new byte[n2];
                objectInput.readFully(this.serializedValue);
            } else {
                this.serializedValue = null;
            }
            this.value = null;
            this.priority = objectInput.readInt();
            this.timeLimit = objectInput.readInt();
            this.inactivity = objectInput.readInt();
            this.expirationTime = objectInput.readLong();
            this.timeStamp = objectInput.readLong();
            this.drsClock = objectInput.readLong();
            this.cacheType = objectInput.readInt();
            this._templates = (String[])objectInput.readObject();
            int n4 = objectInput.readInt();
            if (n4 > 0) {
                this._serializedDataIds = new Object[n4];
                for (n = 0; n < n4; ++n) {
                    n2 = objectInput.readInt();
                    this._serializedDataIds[n] = new byte[n2];
                    objectInput.readFully((byte[])this._serializedDataIds[n]);
                }
            } else {
                this._serializedDataIds = null;
            }
            if (this._serializedDataIds != null) {
                this._dataIds = new Object[this._serializedDataIds.length];
                try {
                    for (n = 0; n < this._serializedDataIds.length; ++n) {
                        this._dataIds[n] = SerializationUtility.deserialize((byte[])this._serializedDataIds[n]);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "388", this);
                    exception.printStackTrace();
                    this._dataIds = EMPTY_OBJECT_ARRAY;
                }
                this._serializedDataIds = null;
            } else {
                this._dataIds = EMPTY_OBJECT_ARRAY;
            }
            this.invalid = objectInput.readBoolean();
            this.sharingPolicy = objectInput.readInt();
            this.persistToDisk = objectInput.readBoolean();
            this.useBatch = objectInput.readBoolean();
            this.useByteBuffer = objectInput.readBoolean();
            n4 = objectInput.readInt();
            if (n4 > 0) {
                this.serializedAliasList = new Object[n4];
                for (int i = 0; i < n4; ++i) {
                    n2 = objectInput.readInt();
                    this.serializedAliasList[i] = new byte[n2];
                    objectInput.readFully((byte[])this.serializedAliasList[i]);
                }
            } else {
                this.serializedAliasList = null;
            }
            if (this.serializedAliasList != null) {
                this.aliasList = new Object[this.serializedAliasList.length];
                try {
                    for (int i = 0; i < this.serializedAliasList.length; ++i) {
                        this.aliasList[i] = SerializationUtility.deserialize((byte[])this.serializedAliasList[i]);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "428", this);
                    exception.printStackTrace();
                    this.aliasList = EMPTY_OBJECT_ARRAY;
                }
                this.serializedAliasList = null;
            } else {
                this.aliasList = EMPTY_OBJECT_ARRAY;
            }
            n2 = objectInput.readInt();
            if (n2 > 0) {
                this.serializedUserMetaData = new byte[n2];
                objectInput.readFully(this.serializedUserMetaData);
            } else {
                this.serializedUserMetaData = null;
            }
            this.userMetaData = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "468", this);
            exception.printStackTrace();
        }
    }

    public Object getValue() {
        if (this.serializedValue != null) {
            try {
                this.value = SerializationUtility.deserialize(this.serializedValue);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getValue", "200", this);
                exception.printStackTrace();
            }
            if (this.value != null) {
                this.serializedValue = null;
            }
        }
        return this.value;
    }

    protected void setValue(Object object) {
        this.value = object;
        this.serializedValue = null;
        this.timeStamp = System.currentTimeMillis();
    }

    public Enumeration getTemplates() {
        return new ArrayEnumerator(this._templates);
    }

    public String getTemplate() {
        if (this._templates.length > 0) {
            return this._templates[0];
        }
        return null;
    }

    public Enumeration getDataIds() {
        return new ArrayEnumerator(this._dataIds);
    }

    public void refreshEntry() {
        this.clock = this.priority;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void reset() {
        this.drsClock = -1L;
        this.timeStamp = -1L;
        this.serializedId = null;
        this.id = null;
        if (this.useByteBuffer) {
            this.getValue();
            if (this.value != null) {
                ((DistributedNioMapObject)this.value).release();
            }
        }
        this.serializedValue = null;
        this.value = null;
        this.clock = DEFAULT_PRIORITY;
        this.refCount = 0;
        this.priority = DEFAULT_PRIORITY;
        this.timeLimit = -1;
        this.inactivity = -1;
        this.expirationTime = -1L;
        this.removeWhenUnpinned = false;
        this._templates = EMPTY_STRING_ARRAY;
        this._dataIds = EMPTY_OBJECT_ARRAY;
        this._serializedDataIds = null;
        this.invalid = false;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.isOverflowEntry = false;
        this.lruEvicted = false;
        this.lruHead = null;
        this.useByteBuffer = false;
        this.aliasList = EMPTY_OBJECT_ARRAY;
        this.serializedAliasList = null;
        this.userMetaData = null;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        this.cacheType = 0;
    }

    public void copy(CacheEntry cacheEntry) {
        if (cacheEntry == this) {
            return;
        }
        if (this.useByteBuffer) {
            this.getValue();
            if (this.value != null) {
                ((DistributedNioMapObject)this.value).release();
            }
        }
        this.value = cacheEntry.value;
        this.serializedValue = cacheEntry.serializedValue;
        this.serializedId = cacheEntry.serializedId;
        this.timeStamp = cacheEntry.timeStamp;
        this.expirationTime = cacheEntry.expirationTime;
        this.timeLimit = cacheEntry.timeLimit;
        this.inactivity = cacheEntry.inactivity;
        this.drsClock = cacheEntry.drsClock;
        this.id = cacheEntry.id;
        this.priority = cacheEntry.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > MAX_PRIORITY) {
            this.priority = MAX_PRIORITY;
        }
        this._templates = cacheEntry._templates;
        this._dataIds = cacheEntry._dataIds;
        this._serializedDataIds = cacheEntry._serializedDataIds;
        this.sharingPolicy = cacheEntry.sharingPolicy;
        this.persistToDisk = cacheEntry.persistToDisk;
        this.useBatch = cacheEntry.useBatch;
        this.refCount = cacheEntry.refCount;
        this.aliasList = cacheEntry.aliasList;
        this.serializedAliasList = cacheEntry.serializedAliasList;
        this.useByteBuffer = cacheEntry.useByteBuffer;
        this.userMetaData = cacheEntry.userMetaData;
        this.serializedUserMetaData = cacheEntry.serializedUserMetaData;
        this.loadedFromDisk = cacheEntry.loadedFromDisk;
        this.cacheType = cacheEntry.cacheType;
    }

    public void copyMetaData(EntryInfo entryInfo) {
        entryInfo.lock();
        if (!entryInfo.wasIdSet()) {
            throw new IllegalStateException("id was not set on entryInfo");
        }
        this.id = entryInfo.id;
        this.timeLimit = entryInfo.timeLimit;
        this.inactivity = entryInfo.inactivity;
        this.expirationTime = entryInfo.expirationTime;
        this.priority = entryInfo.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > MAX_PRIORITY) {
            this.priority = MAX_PRIORITY;
        }
        this._templates = entryInfo.templates.toArray(new String[entryInfo.templates.size()]);
        this._dataIds = entryInfo.dataIds.toArray(new Object[entryInfo.dataIds.size()]);
        this._serializedDataIds = null;
        this.sharingPolicy = entryInfo.sharingPolicy;
        this.persistToDisk = entryInfo.persistToDisk;
        this.useBatch = entryInfo.isBatchEnabled();
        this.aliasList = entryInfo.aliasList.toArray(new Object[entryInfo.aliasList.size()]);
        this.serializedAliasList = null;
        this.userMetaData = entryInfo.userMetaData;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        if (entryInfo instanceof JAXRPCEntryInfo) {
            this.cacheType = 1;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CacheEntry)) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        if (this.id == null || cacheEntry.id == null) {
            return super.equals(object);
        }
        return this.id.equals(cacheEntry.id);
    }

    public int hashCode() {
        if (this.id == null) {
            return CacheEntry.class.hashCode();
        }
        return this.id.hashCode();
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public boolean isBatchEnabled() {
        return this.useBatch;
    }

    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    public Object getIdObject() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    public byte[] getDisplayValue() {
        byte[] byArray;
        block9: {
            this.getValue();
            if (this.value == null) {
                return new byte[0];
            }
            if (this.value.getClass().getName().equals("com.ibm.ws.cache.servlet.FragmentComposerMemento")) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.cache.servlet.FragmentComposerMemento");
                    Method method = clazz.getMethod("generateContents", null);
                    return (byte[])method.invoke(this.value, null);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "887", this);
                }
            }
            Object object = this.value;
            if (this.cacheType == 1 && this.value instanceof byte[]) {
                try {
                    object = SerializationUtility.deserialize((byte[])this.value);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "896", this);
                }
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"));
                printWriter.print(object);
                printWriter.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "908", this);
                Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object)exception.getMessage());
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("error getting value for CacheEntry " + this.id + ": " + exception.getMessage()));
            }
        }
        return byArray;
    }

    public Enumeration getAliasList() {
        return new ArrayEnumerator(this.aliasList);
    }

    public void addAlias(Object object) {
        ValueSet valueSet = new ValueSet(this.aliasList.length + 1);
        if (object != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                valueSet.add(this.aliasList[i]);
            }
        }
        valueSet.add(object);
        this.aliasList = valueSet.toArray(new Object[valueSet.size()]);
        this.serializedAliasList = null;
    }

    public void removeAlias(Object object) {
        ValueSet valueSet = new ValueSet(this.aliasList.length);
        if (object != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                valueSet.add(this.aliasList[i]);
            }
        }
        valueSet.remove(object);
        this.aliasList = valueSet.toArray(new Object[valueSet.size()]);
        this.serializedAliasList = null;
    }

    public Object getUserMetaData() {
        if (this.serializedUserMetaData != null) {
            try {
                this.userMetaData = SerializationUtility.deserialize(this.serializedUserMetaData);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getUserMetaData", "600", this);
                exception.printStackTrace();
            }
            this.serializedUserMetaData = null;
        }
        return this.userMetaData;
    }

    protected void setUserMetaData(Object object) {
        this.userMetaData = object;
        this.serializedUserMetaData = null;
    }

    public static CacheEntryPool createCacheEntryPool(Cache cache, int n) {
        CacheEntryPool cacheEntryPool = new CacheEntryPool(n, cache);
        return cacheEntryPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (!$assertionsDisabled && this.cacheEntryPool == null) {
            throw new AssertionError();
        }
        Cache cache = this.cacheEntryPool.cache;
        synchronized (cache) {
            --this.refCount;
            if (this.refCount <= 0) {
                if (this.refCount < 0) {
                    this.refCount = 0;
                }
                if (this.removeWhenUnpinned && this.refCount == 0) {
                    this.returnToPool();
                }
            }
        }
    }

    protected void returnToPool() {
        CacheEntryPool cacheEntryPool = this.cacheEntryPool;
        if (!$assertionsDisabled && this.cacheEntryPool == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.refCount != 0) {
            throw new AssertionError();
        }
        if (this.lruHead != null) {
            this.lruHead.remove(this);
        }
        this.reset();
        cacheEntryPool.add(this);
        --cacheEntryPool.cache.cePoolCount;
    }

    static {
        $assertionsDisabled = !CacheEntry.class.desiredAssertionStatus();
        tc = Trace.register(CacheEntry.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        DEFAULT_PRIORITY = 1;
        MAX_PRIORITY = 16;
    }

    static class CacheEntryPool
    extends ObjectPool {
        Cache cache = null;
        String cacheName = null;

        public CacheEntryPool(int n, Cache cache) {
            super("CacheEntry.Pool", n);
            this.cache = cache;
            this.cacheName = cache.cacheName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheEntryPool created for named cache " + this.cacheName));
            }
        }

        public Object createObject() {
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.reset();
            return cacheEntry;
        }

        public CacheEntry allocate() {
            CacheEntry cacheEntry = (CacheEntry)this.remove();
            cacheEntry.cacheEntryPool = this;
            ++this.cache.cePoolCount;
            return cacheEntry;
        }
    }

    static class ArrayEnumerator
    implements Enumeration {
        int pos = 0;
        Object[] array;

        public ArrayEnumerator(Object[] objectArray) {
            this.array = objectArray;
        }

        public boolean hasMoreElements() {
            return this.array.length > this.pos;
        }

        public Object nextElement() {
            return this.array[this.pos++];
        }
    }

    public static class LRUHead
    implements Iterator {
        public int priority = 0;
        private CacheEntry head;
        private CacheEntry tail;
        private CacheEntry _iterator = null;

        public void addFirst(CacheEntry cacheEntry) {
            cacheEntry._previous = null;
            cacheEntry._next = this.head;
            if (this.head != null) {
                this.head._previous = cacheEntry;
            }
            this.head = cacheEntry;
            if (this.tail == null) {
                this.tail = cacheEntry;
            }
        }

        public void addLast(CacheEntry cacheEntry) {
            cacheEntry._previous = this.tail;
            cacheEntry._next = null;
            if (this.head == null) {
                this.head = cacheEntry;
            } else {
                this.tail._next = cacheEntry;
            }
            this.tail = cacheEntry;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public boolean isLast(CacheEntry cacheEntry) {
            return this.tail == cacheEntry;
        }

        public Iterator iterator() {
            this._iterator = this.head;
            return this;
        }

        public Object next() {
            CacheEntry cacheEntry = this._iterator;
            this._iterator = this._iterator._next;
            return cacheEntry;
        }

        public boolean hasNext() {
            return this._iterator != null;
        }

        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public void remove(CacheEntry cacheEntry) {
            if (cacheEntry.lruHead != this) {
                System.out.println("internal error for cacheEntry=" + cacheEntry);
                System.out.println("_next=" + cacheEntry._next);
                System.out.println("_previous=" + cacheEntry._previous);
                System.out.println("lruHead=" + cacheEntry.lruHead);
                System.out.println("this=" + this);
            }
            if (this.head == cacheEntry) {
                this.head = cacheEntry._next;
                if (this.head != null) {
                    this.head._previous = null;
                }
            } else {
                cacheEntry._previous._next = cacheEntry._next;
                if (cacheEntry._next != null) {
                    cacheEntry._next._previous = cacheEntry._previous;
                }
            }
            if (this.tail == cacheEntry) {
                this.tail = cacheEntry._previous;
            }
            cacheEntry._previous = null;
            cacheEntry._next = null;
            cacheEntry.lruHead = null;
        }

        public CacheEntry removeFirst() {
            CacheEntry cacheEntry = this.head;
            if (cacheEntry != null) {
                this.head = cacheEntry._next;
                if (this.head != null) {
                    this.head._previous = null;
                } else {
                    this.tail = null;
                }
            }
            return cacheEntry;
        }
    }
}

