/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.FieldInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CacheConfig
implements Cloneable {
    private static boolean assertRanOnce;
    public static final String CACHE_NAME = "com.ibm.ws.cache.CacheConfig.cacheName";
    public static final String CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String ENABLE_LOCKING_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableLockingSupport";
    public static final String DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String ENABLE_REPLICATION_ACKS = "com.ibm.ws.cache.CacheConfig.enableReplicationAcks";
    public static final String ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String DISK_CLEANUP_FREQUENCY = "com.ibm.ws.cache.CacheConfig.htodCleanupFrequency";
    public static final String DISK_DELAY_OFFLOAD = "com.ibm.ws.cache.CacheConfig.htodDelayOffload";
    public static final String DISK_DELAY_OFFLOAD_ENTRIES_LIMIT = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadEntriesLimit";
    public static final String DISK_DELAY_OFFLOAD_DEPID_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadDepIdBuckets";
    public static final String DISK_DELAY_OFFLOAD_TEMPLATE_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadTemplateBuckets";
    public static final String IGNORE_VALUE_IN_INVALIDATION_EVENT = "com.ibm.ws.cache.CacheConfig.ignoreValueInInvalidationEvent";
    public static final String USE_SERVER_CLASSLOADER = "com.ibm.ws.cache.CacheConfig.useServerClassLoader";
    public static final String DISABLE_STORE_COOKIES = "com.ibm.ws.cache.CacheConfig.disableStoreCookies";
    public static final String CACHE_NAME_NON_PREFIXED = "com.ibm.ws.cache.CacheConfig.cacheNameNonPrefixed";
    public static final int CACHE_UNITS_ENTRIES = 1;
    public static final int CACHE_UNITS_KILOBYTES = 2;
    static final int UNKNOWN_SOURCE = -1;
    static final int WCCM_DYNAMIC_CACHE = 1;
    static final int WCCM_CACHE_INSTANCE = 2;
    static final int WCCM_SERVLET_CACHE_INSTANCE = 3;
    static final int WCCM_OBJECT_CACHE_INSTANCE = 4;
    static final int FILE_SERVLET_CACHE_INSTANCE = 5;
    static final int FILE_OBJECT_CACHE_INSTANCE = 6;
    static final int FACTORY_SERVLET_CACHE_INSTANCE = 7;
    static final int FACTORY_OBJECT_CACHE_INSTANCE = 8;
    static final int INTERNAL_BASE_CACHE = 254;
    static final int INTERNAL_DMAP_CACHE = 255;
    boolean filterTimeOutInvalidation = false;
    int configSource = -1;
    String cacheName = null;
    String cacheNameNonPrefixed = null;
    String tempDir = null;
    String propertiesDir = null;
    String dtdDir = null;
    String serverCellName = null;
    String serverNodeName = null;
    String serverServerName = null;
    String serverNameFQ = null;
    int cachePriority = CacheEntry.DEFAULT_PRIORITY;
    int jspCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int commandCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int diskHashBuckets = 1024;
    int cacheUnits = 1;
    int cacheSize = 2000;
    String replicationDomain = null;
    boolean enableCacheReplication = false;
    int replicationType = 0;
    int defaultShareType = 1;
    String notificationType = "unicast";
    String cacheSprayerName = "com.ibm.ws.cache.CacheSprayerImpl";
    DRSSettings drss = null;
    int pushFrequency = 1;
    int batchUpdateInterval = 1000;
    boolean enableDiskOffload = false;
    String diskOffloadLocation = null;
    boolean flushToDiskOnStop = false;
    List externalGroups = new ArrayList();
    boolean useListenerContext = false;
    boolean disableDependencyId = false;
    boolean enableLockingSupport = false;
    boolean disableTemplatesSupport = false;
    boolean enableReplicationAcks = false;
    boolean enableNioSupport = false;
    boolean enableServletSupport = false;
    int maxTimeLimitInSeconds = 86400;
    int configReloadInterval = 5000;
    int timeGranularityInSeconds = 5;
    int timeHoldingInvalidations = 300000;
    int htodCleanupHour = 0;
    long htodInvalInterval = 86400000L;
    int htodCleanupFrequency = 0;
    boolean htodDelayOffload = true;
    int htodDelayOffloadDepIdBuckets = 1000;
    int htodDelayOffloadTemplateBuckets = 100;
    int htodDelayOffloadEntriesLimit = 1000;
    int htodDataHashtableSize = 477551;
    int htodDepIdHashtableSize = 47743;
    int htodTemplateHashtableSize = 1031;
    int htodNumberOfPools = 20;
    int htodPoolSize = 2;
    int htodPoolEntryLife = 300000;
    int htodInvalidationBufferSize = 1000;
    int htodInvalidationBufferLife = 10000;
    public boolean disableTemplateInvalidation = false;
    boolean ignoreValueInInvalidationEvent = false;
    boolean useServerClassLoader = false;
    String disableStoreCookies = "none";
    String cacheStatisticsListenerBeanName = "com.ibm.ws.cache.CacheStatisticsListenerImpl";
    String commandStoragePolicyClassName = "com.ibm.ws.cache.command.SerializedPutCommandStorage";
    DistributedObjectCache distributedObjectCache = null;
    Cache cache = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CacheConfig() {
        FieldInitializer.initFromSystemProperties((Object)this);
    }

    protected void reset() {
        this.configSource = -1;
        this.tempDir = null;
        this.propertiesDir = null;
        this.dtdDir = null;
        this.diskOffloadLocation = null;
        this.drss = null;
        this.cacheName = null;
        this.distributedObjectCache = null;
        this.cache = null;
        this.serverCellName = null;
        this.serverNodeName = null;
        this.serverServerName = null;
        this.serverNameFQ = null;
        if (this.externalGroups != null) {
            this.externalGroups.clear();
        }
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public void setEnableDiskOffload(boolean bl) {
        this.enableDiskOffload = bl;
        this.processOffloadDirectory();
    }

    private void processOffloadDirectory() {
        if (this.enableDiskOffload) {
            String string = "";
            String string2 = this.tempDir + this.serverNodeName + File.separator + this.serverServerName + File.separator + "_dynacache";
            string2 = File.separatorChar == '\\' ? string2.replace('/', File.separatorChar) : string2.replace('\\', File.separatorChar);
            if (this.diskOffloadLocation != null && this.diskOffloadLocation.trim().length() != 0) {
                if (this.diskOffloadLocation.indexOf("##") > 0) {
                    return;
                }
                if (this.diskOffloadLocation.equals(string2)) {
                    return;
                }
                string = this.diskOffloadLocation.endsWith("/") || this.diskOffloadLocation.endsWith("\\") ? this.diskOffloadLocation + this.serverNodeName + File.separator + this.serverServerName : this.diskOffloadLocation + File.separator + this.serverNodeName + File.separator + this.serverServerName;
            }
            this.diskOffloadLocation = string.equals("") ? string2 : string + "##" + string2;
            this.diskOffloadLocation = File.separatorChar == '\\' ? this.diskOffloadLocation.replace('/', File.separatorChar) : this.diskOffloadLocation.replace('\\', File.separatorChar);
            CacheServiceImpl cacheServiceImpl = (CacheServiceImpl)CacheServiceImpl.getCacheService();
            if (cacheServiceImpl != null && this.diskOffloadLocation != null) {
                this.diskOffloadLocation = cacheServiceImpl.expandWebSphereVariable(this.diskOffloadLocation);
            }
        }
    }

    public void overrideCacheConfig(Properties properties) {
        if (properties != null) {
            FieldInitializer.initFromSystemProperties((Object)this, (Properties)properties);
        }
        this.processOffloadDirectory();
        if (!this.enableServletSupport) {
            this.disableTemplatesSupport = true;
        }
    }

    protected String fixPath(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public boolean verifyConfig() {
        if (!$assertionsDisabled && !new File(this.tempDir).isDirectory()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !new File(this.propertiesDir).isDirectory()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !new File(this.dtdDir).isDirectory()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cacheName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cacheName.trim().equals("")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.configSource != 3 && this.configSource != 4 && this.configSource != 2 && this.configSource != 1 && this.configSource != 6 && this.configSource != 5 && this.configSource != 8 && this.configSource != 7) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.serverNodeName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.serverServerName == null) {
            throw new AssertionError();
        }
        return true;
    }

    public Object getDrsSettings() {
        return this.drss;
    }

    public void setDrsSettings(Object object) {
        this.drss = (DRSSettings)object;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cache.CacheConfig", "314");
            exception.printStackTrace();
        }
        ((CacheConfig)object).cache = null;
        ((CacheConfig)object).distributedObjectCache = null;
        ((CacheConfig)object).enableServletSupport = false;
        ((CacheConfig)object).enableDiskOffload = false;
        ((CacheConfig)object).flushToDiskOnStop = false;
        ((CacheConfig)object).disableDependencyId = false;
        ((CacheConfig)object).disableTemplatesSupport = false;
        return object;
    }

    public int getBatchUpdateInterval() {
        return this.batchUpdateInterval;
    }

    static {
        $assertionsDisabled = !CacheConfig.class.desiredAssertionStatus();
        assertRanOnce = false;
    }

    static class Environment {
        String tmpDir = null;
        String propDir = null;
        String dtdDir = null;
        String serverCellName = null;
        String serverNodeName = null;
        String serverServerName = null;
        boolean isZOS = false;

        Environment() {
        }
    }

    static class ExternalCacheGroupMember {
        String address;
        String beanName;

        ExternalCacheGroupMember() {
        }
    }

    static class ExternalCacheGroup {
        String name;
        int type;
        List members;

        ExternalCacheGroup() {
        }
    }
}

