/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BatchUpdateDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Trace.register(BatchUpdateDaemon.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private static final HashMap EMPTY_MAP = new HashMap();
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private HashMap updates = new HashMap();
    private HashMap drsBuffer = new HashMap();
    private int drsCongestionThreshold = 5;
    private long lastTimeForTrace = 0L;
    public static final int TRACE_WINDOW = 10000;

    public BatchUpdateDaemon(int n) {
        super(n);
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setInvalidationAuditDaemon(InvalidationAuditDaemon invalidationAuditDaemon) {
        this.invalidationAuditDaemon = invalidationAuditDaemon;
    }

    public void start() {
        if (this.externalCacheServices == null || this.invalidationAuditDaemon == null) {
            throw new IllegalStateException("externalCacheServices and invalidationAuditDaemon must be set before start()");
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateByTemplate(String string, boolean bl, Cache cache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            batchUpdateList.invalidateByTemplateEvents.put(string, new InvalidateByTemplateEvent(string, 5));
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCommand_Clear(boolean bl, Cache cache) {
        String string = cache.getCacheName();
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            batchUpdateList.invalidateByIdEvents.clear();
            batchUpdateList.invalidateByTemplateEvents.clear();
            batchUpdateList.pushCacheEntryEvents.clear();
            batchUpdateList.pushECFEvents.clear();
            InvalidateByTemplateEvent invalidateByTemplateEvent = new InvalidateByTemplateEvent(string, 5);
            invalidateByTemplateEvent.setCacheCommand_Clear();
            batchUpdateList.invalidateByTemplateEvents.put(string, invalidateByTemplateEvent);
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object object, int n, boolean bl, Cache cache) {
        this.invalidateById(object, n, 5, bl, true, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2, Cache cache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            InvalidateByIdEvent invalidateByIdEvent = new InvalidateByIdEvent(object, n, n2, bl2);
            invalidateByIdEvent.setClassLoaderType(cache.useServerClassLoader);
            batchUpdateList.invalidateByIdEvents.put(object, invalidateByIdEvent);
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object object, boolean bl, Cache cache) {
        this.invalidateById(object, 1, bl, cache);
    }

    public synchronized void pushCacheEntry(CacheEntry cacheEntry, Cache cache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(cache);
        batchUpdateList.pushCacheEntryEvents.add(cacheEntry);
    }

    public synchronized void pushExternalCacheFragment(ExternalCacheFragment externalCacheFragment, Cache cache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(cache);
        batchUpdateList.pushECFEvents.add(externalCacheFragment);
    }

    public synchronized void pushAliasEntry(AliasEntry aliasEntry, Cache cache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(cache);
        batchUpdateList.aliasEntryEvents.add(aliasEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void wakeUp(long l, long l2) {
        boolean bl = false;
        try {
            Object object = this;
            synchronized (object) {
                int n = this.updates.size();
                if (n <= 0) {
                } else {
                    BatchUpdateList[] batchUpdateListArray = new BatchUpdateList[n];
                    this.updates.values().toArray(batchUpdateListArray);
                    this.updates.clear();
                    // MONITOREXIT @DISABLED, blocks:[0, 7, 43] lbl13 : MonitorExitStatement: MONITOREXIT : var7_4
                    object = new ArrayList();
                    for (n = 0; n < batchUpdateListArray.length; ++n) {
                        Iterator iterator;
                        Object var22_28;
                        BatchUpdateList batchUpdateList = null;
                        try {
                            Object object2;
                            Object object3;
                            block45: {
                                batchUpdateList = batchUpdateListArray[n];
                                ((ArrayList)object).addAll(batchUpdateList.pushCacheEntryEvents);
                                this.cleanUpEventLists(batchUpdateList.cache, batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents, batchUpdateList.pushECFEvents, batchUpdateList.aliasEntryEvents);
                                if (batchUpdateList.invalidateByIdEvents.size() > 0) {
                                    this.invalidationAuditDaemon.registerInvalidations(batchUpdateList.invalidateByIdEvents.values().iterator());
                                }
                                if (batchUpdateList.invalidateByTemplateEvents.size() > 0) {
                                    this.invalidationAuditDaemon.registerInvalidations(batchUpdateList.invalidateByTemplateEvents.values().iterator());
                                }
                                if (batchUpdateList.pushCacheEntryEvents.size() > 0) {
                                    batchUpdateList.pushCacheEntryEvents = this.invalidationAuditDaemon.filterEntryList(batchUpdateList.pushCacheEntryEvents);
                                }
                                if (batchUpdateList.pushECFEvents.size() > 0) {
                                    batchUpdateList.pushECFEvents = this.invalidationAuditDaemon.filterExternalCacheFragmentList(batchUpdateList.pushECFEvents);
                                }
                                if (batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0 || batchUpdateList.pushCacheEntryEvents.size() > 0) {
                                    Object object4;
                                    BatchUpdateList batchUpdateList2;
                                    object3 = batchUpdateList.cache.getRemoteServices();
                                    if (object3.isDRSReady() && object3.isDRSCongested()) {
                                        object2 = this.drsBuffer;
                                        synchronized (object2) {
                                            this.addToDRSBuffer(batchUpdateList);
                                            batchUpdateList2 = (BatchUpdateList)this.drsBuffer.get(batchUpdateList.cache);
                                            object4 = batchUpdateList2.pushCacheEntryEvents.iterator();
                                            while (object4.hasNext()) {
                                                CacheEntry cacheEntry = (CacheEntry)object4.next();
                                                int n2 = ((ArrayList)object).indexOf(cacheEntry);
                                                if (n2 < 0) continue;
                                                ((ArrayList)object).remove(n2);
                                            }
                                        }
                                    } else if (object3.isDRSReady() && !object3.isDRSCongested()) {
                                        object2 = (BatchUpdateList)this.drsBuffer.get(batchUpdateList.cache);
                                        batchUpdateList2 = null;
                                        if (object2 != null) {
                                            Iterator iterator2;
                                            Object var19_26;
                                            try {
                                                object4 = this.drsBuffer;
                                                synchronized (object4) {
                                                    batchUpdateList2 = this.mergeLists((BatchUpdateList)object2, batchUpdateList);
                                                    this.drsBuffer.remove(batchUpdateList.cache);
                                                }
                                                this.cleanUpEventLists(batchUpdateList2.cache, batchUpdateList2.invalidateByIdEvents, batchUpdateList2.invalidateByTemplateEvents, batchUpdateList2.pushCacheEntryEvents, batchUpdateList2.pushECFEvents, batchUpdateList2.aliasEntryEvents);
                                                object3.batchUpdate(batchUpdateList2.invalidateByIdEvents, batchUpdateList2.invalidateByTemplateEvents, batchUpdateList2.pushCacheEntryEvents, batchUpdateList2.aliasEntryEvents);
                                                var19_26 = null;
                                                if (batchUpdateList2 == null) break block45;
                                                iterator2 = batchUpdateList2.pushCacheEntryEvents.iterator();
                                            }
                                            catch (Throwable throwable) {
                                                var19_26 = null;
                                                if (batchUpdateList2 == null) throw throwable;
                                                iterator2 = batchUpdateList2.pushCacheEntryEvents.iterator();
                                                while (iterator2.hasNext()) {
                                                    ((CacheEntry)iterator2.next()).finish();
                                                }
                                                throw throwable;
                                            }
                                            while (iterator2.hasNext()) {
                                                ((CacheEntry)iterator2.next()).finish();
                                            }
                                        } else {
                                            object3.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents, batchUpdateList.aliasEntryEvents);
                                        }
                                    }
                                }
                            }
                            if (!bl && batchUpdateList.invalidateByTemplateEvents.size() > 0) {
                                object3 = batchUpdateList.invalidateByTemplateEvents.values().iterator();
                                while (object3.hasNext()) {
                                    object2 = (InvalidateByTemplateEvent)object3.next();
                                    if (!((InvalidateByTemplateEvent)object2).isCacheCommand_Clear()) continue;
                                    bl = true;
                                    if (!tc.isDebugEnabled()) break;
                                    Tr.debug((TraceComponent)tc, (String)("cacheName=" + batchUpdateList.cache.cacheName + " Performing cache clear; skip trim cache operation."));
                                    break;
                                }
                            }
                            if (batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0) {
                                batchUpdateList.cache.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, EMPTY_ARRAYLIST);
                            }
                            if ((batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0 || batchUpdateList.pushECFEvents.size() > 0) && batchUpdateList.cache.getCacheConfig().enableServletSupport) {
                                this.externalCacheServices.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushECFEvents);
                            }
                            var22_28 = null;
                            iterator = ((ArrayList)object).iterator();
                        }
                        catch (Throwable throwable) {
                            var22_28 = null;
                            iterator = ((ArrayList)object).iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    ((ArrayList)object).clear();
                                    throw throwable;
                                }
                                ((CacheEntry)iterator.next()).finish();
                            }
                        }
                        while (iterator.hasNext()) {
                            ((CacheEntry)iterator.next()).finish();
                        }
                        ((ArrayList)object).clear();
                    }
                    Object var25_8 = null;
                    Map map = ServerCache.getCacheInstances();
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        Cache cache = (Cache)iterator.next();
                        cache.refreshCachePerf();
                        if (!bl) {
                            cache.trimCache();
                        }
                        if (!tc.isDebugEnabled() || System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) continue;
                        Tr.debug((TraceComponent)tc, (String)("cacheName=" + cache.cacheName + " CE Pool count=" + cache.cePoolCount + " PushPullTableSize=" + cache.getPushPullTableSize()));
                    }
                    if (ServerCache.cache == null) return;
                    ServerCache.cache.refreshCachePerf();
                    if (!bl) {
                        ServerCache.cache.trimCache();
                    }
                    if (!tc.isDebugEnabled()) return;
                    if (System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) return;
                    Tr.debug((TraceComponent)tc, (String)("cacheName=" + ServerCache.cache.cacheName + " CE Pool count=" + ServerCache.cache.cePoolCount + " PushPullTableSize=" + ServerCache.cache.getPushPullTableSize()));
                    this.lastTimeForTrace = System.currentTimeMillis();
                    return;
                }
            }
            Object var25_7 = null;
        }
        catch (Throwable throwable) {
            Object var25_9 = null;
            Map map = ServerCache.getCacheInstances();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Cache cache = (Cache)iterator.next();
                cache.refreshCachePerf();
                if (!bl) {
                    cache.trimCache();
                }
                if (!tc.isDebugEnabled() || System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) continue;
                Tr.debug((TraceComponent)tc, (String)("cacheName=" + cache.cacheName + " CE Pool count=" + cache.cePoolCount + " PushPullTableSize=" + cache.getPushPullTableSize()));
            }
            if (ServerCache.cache == null) throw throwable;
            ServerCache.cache.refreshCachePerf();
            if (!bl) {
                ServerCache.cache.trimCache();
            }
            if (!tc.isDebugEnabled()) throw throwable;
            if (System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) throw throwable;
            Tr.debug((TraceComponent)tc, (String)("cacheName=" + ServerCache.cache.cacheName + " CE Pool count=" + ServerCache.cache.cePoolCount + " PushPullTableSize=" + ServerCache.cache.getPushPullTableSize()));
            this.lastTimeForTrace = System.currentTimeMillis();
            throw throwable;
        }
        Map map = ServerCache.getCacheInstances();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Cache cache = (Cache)iterator.next();
            cache.refreshCachePerf();
            if (!bl) {
                cache.trimCache();
            }
            if (!tc.isDebugEnabled() || System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) continue;
            Tr.debug((TraceComponent)tc, (String)("cacheName=" + cache.cacheName + " CE Pool count=" + cache.cePoolCount + " PushPullTableSize=" + cache.getPushPullTableSize()));
        }
        if (ServerCache.cache == null) return;
        ServerCache.cache.refreshCachePerf();
        if (!bl) {
            ServerCache.cache.trimCache();
        }
        if (!tc.isDebugEnabled()) return;
        if (System.currentTimeMillis() - this.lastTimeForTrace <= 10000L) return;
        Tr.debug((TraceComponent)tc, (String)("cacheName=" + ServerCache.cache.cacheName + " CE Pool count=" + ServerCache.cache.cePoolCount + " PushPullTableSize=" + ServerCache.cache.getPushPullTableSize()));
        this.lastTimeForTrace = System.currentTimeMillis();
    }

    private void cleanUpEventLists(Cache cache, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        Object object;
        Object object2;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)iterator.next();
            object2 = invalidateByIdEvent.getId();
            CacheEntry cacheEntry = cache.getEntryFromMemory(object2);
            if (cacheEntry == null || invalidateByIdEvent.getTimeStamp() >= cacheEntry.getTimeStamp()) continue;
            iterator.remove();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n;
            boolean bl = false;
            object2 = (CacheEntry)iterator.next();
            if (hashMap.containsKey(((CacheEntry)object2).id)) {
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object2)._dataIds.length; ++n) {
                if (!hashMap.containsKey(((CacheEntry)object2)._dataIds[n])) continue;
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object2)._templates.length; ++n) {
                if (!hashMap2.containsKey(((CacheEntry)object2)._templates[n])) continue;
                bl = true;
            }
            if (!bl && !((CacheEntry)object2).prepareForSerialization()) {
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            object2 = (AliasEntry)iterator.next();
            if (hashMap.containsKey(((AliasEntry)object2).id)) {
                bl = true;
            } else {
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    object = (CacheEntry)iterator2.next();
                    if (!((CacheEntry)object).id.equals(((AliasEntry)object2).id) || ((CacheEntry)object).getTimeStamp() <= ((CacheEntry)object2).getTimeStamp()) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            iterator.remove();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            object2 = (ExternalCacheFragment)iterator.next();
            Enumeration enumeration = ((ExternalCacheFragment)object2).getTemplates();
            while (!bl && enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (!hashMap2.containsKey(object)) continue;
                bl = true;
            }
            enumeration = ((ExternalCacheFragment)object2).getInvalidationIds();
            while (!bl && enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (!hashMap.containsKey(object)) continue;
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private final BatchUpdateList getUpdateList(Cache cache) {
        BatchUpdateList batchUpdateList = (BatchUpdateList)this.updates.get(cache);
        if (batchUpdateList == null) {
            batchUpdateList = new BatchUpdateList();
            batchUpdateList.cache = cache;
            this.updates.put(cache, batchUpdateList);
        }
        return batchUpdateList;
    }

    private void addToDRSBuffer(BatchUpdateList batchUpdateList) {
        if (batchUpdateList != null) {
            BatchUpdateList batchUpdateList2 = (BatchUpdateList)this.drsBuffer.get(batchUpdateList.cache);
            if (batchUpdateList2 != null) {
                Cache cache = batchUpdateList.cache;
                BatchUpdateList batchUpdateList3 = this.mergeLists(batchUpdateList2, batchUpdateList);
                int n = cache.getNumberCacheEntries() / 20;
                int n2 = batchUpdateList3.aliasEntryEvents.size() + batchUpdateList3.invalidateByIdEvents.size() + batchUpdateList3.invalidateByTemplateEvents.size() + batchUpdateList3.pushCacheEntryEvents.size();
                if (batchUpdateList3.congestionCount++ > this.drsCongestionThreshold && n2 > n) {
                    Tr.event((TraceComponent)tc, (String)("Disabling replication due to DRS congestion for cache instance: " + batchUpdateList3.cache.getCacheName() + ", invalidatedByIdEvents:" + batchUpdateList3.invalidateByIdEvents.size() + " invalidateByTemplateEvents:" + batchUpdateList3.invalidateByTemplateEvents.size() + " pushCacheEntryEvents:" + batchUpdateList3.pushCacheEntryEvents.size() + " aliasEntryEvents:" + batchUpdateList3.aliasEntryEvents.size()));
                    batchUpdateList3.cache.setDRSDisabled(true);
                    this.drsBuffer.remove(batchUpdateList3.cache);
                } else {
                    this.drsBuffer.put(batchUpdateList3.cache, batchUpdateList3);
                }
            } else {
                this.drsBuffer.put(batchUpdateList.cache, batchUpdateList);
            }
        }
    }

    private BatchUpdateList mergeLists(BatchUpdateList batchUpdateList, BatchUpdateList batchUpdateList2) {
        CacheEntry cacheEntry;
        Iterator iterator;
        CacheEntry cacheEntry2;
        BatchUpdateList batchUpdateList3 = new BatchUpdateList();
        batchUpdateList3.cache = batchUpdateList.cache;
        batchUpdateList3.congestionCount = batchUpdateList.congestionCount;
        if (batchUpdateList.invalidateByIdEvents.size() > 0) {
            batchUpdateList3.invalidateByIdEvents.putAll(batchUpdateList.invalidateByIdEvents);
        }
        if (batchUpdateList2.invalidateByIdEvents.size() > 0) {
            batchUpdateList3.invalidateByIdEvents.putAll(batchUpdateList2.invalidateByIdEvents);
        }
        batchUpdateList.invalidateByIdEvents.clear();
        if (batchUpdateList.invalidateByTemplateEvents.size() > 0) {
            batchUpdateList3.invalidateByTemplateEvents.putAll(batchUpdateList.invalidateByTemplateEvents);
        }
        if (batchUpdateList2.invalidateByTemplateEvents.size() > 0) {
            batchUpdateList3.invalidateByTemplateEvents.putAll(batchUpdateList2.invalidateByTemplateEvents);
        }
        batchUpdateList.invalidateByTemplateEvents.clear();
        Iterator iterator2 = batchUpdateList2.pushCacheEntryEvents.iterator();
        while (iterator2.hasNext()) {
            cacheEntry2 = (CacheEntry)iterator2.next();
            iterator = batchUpdateList.pushCacheEntryEvents.iterator();
            while (iterator.hasNext()) {
                cacheEntry = (CacheEntry)iterator.next();
                if (cacheEntry == null || !cacheEntry.id.equals(cacheEntry2.id)) continue;
                batchUpdateList.pushCacheEntryEvents.remove(batchUpdateList.pushCacheEntryEvents.indexOf(cacheEntry2));
            }
        }
        batchUpdateList3.pushCacheEntryEvents.addAll(batchUpdateList.pushCacheEntryEvents);
        batchUpdateList3.pushCacheEntryEvents.addAll(batchUpdateList2.pushCacheEntryEvents);
        batchUpdateList.pushCacheEntryEvents.clear();
        iterator2 = batchUpdateList2.aliasEntryEvents.iterator();
        while (iterator2.hasNext()) {
            cacheEntry2 = (AliasEntry)iterator2.next();
            iterator = batchUpdateList.aliasEntryEvents.iterator();
            while (iterator.hasNext()) {
                cacheEntry = (AliasEntry)iterator.next();
                if (cacheEntry == null || !((AliasEntry)cacheEntry).id.equals(((AliasEntry)cacheEntry2).id)) continue;
                batchUpdateList.aliasEntryEvents.remove(batchUpdateList.aliasEntryEvents.indexOf(cacheEntry2));
            }
        }
        batchUpdateList3.aliasEntryEvents.addAll(batchUpdateList.aliasEntryEvents);
        batchUpdateList3.aliasEntryEvents.addAll(batchUpdateList2.aliasEntryEvents);
        batchUpdateList.aliasEntryEvents.clear();
        return batchUpdateList3;
    }

    static class BatchUpdateList {
        public Cache cache;
        public int congestionCount = 0;
        public HashMap invalidateByIdEvents = new HashMap();
        public HashMap invalidateByTemplateEvents = new HashMap();
        public ArrayList pushCacheEntryEvents = new ArrayList();
        public ArrayList pushECFEvents = new ArrayList();
        public ArrayList aliasEntryEvents = new ArrayList();

        BatchUpdateList() {
        }
    }
}

