/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextManager;
import com.ibm.ws.dwlm.client.URIMatcher;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import java.net.URL;
import java.util.LinkedList;

public class VHostMatcher {
    protected static final TraceComponent tc = Tr.register((Class)VHostMatcher.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected static final VHost[] EMPTY_VH_ARRAY = new VHost[0];
    protected static VHostMatcher debugVHostMatcher = null;
    protected final LinkedList vhostList = new LinkedList();
    protected VHost[] vhostArray = EMPTY_VH_ARRAY;

    public URIMatcher getURIMatcher(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURIMatcher", (Object)new Object[]{string, new Integer(n)});
        }
        for (int i = 0; i < this.vhostArray.length; ++i) {
            VHost vHost = this.vhostArray[i];
            if (!vHost.equals(string, n)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURIMatcher", (Object)"already exists");
            }
            return vHost.uriMatcher;
        }
        VHost vHost = new VHost(string, n);
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"prepend");
            }
            this.vhostList.add(0, vHost);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"append");
            }
            this.vhostList.add(vHost);
        }
        this.vhostArray = this.vhostList.toArray(EMPTY_VH_ARRAY);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getURIMatcher", (Object)"created");
        }
        return vHost.uriMatcher;
    }

    public Object match(String string, int n, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"match", (Object)new Object[]{string, new Integer(n), string2});
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(string, n, string2);
        for (int i = 0; i < this.vhostArray.length; ++i) {
            Object object = this.vhostArray[i].match(string, n, string2, routingDebugRequestContext);
            if (object == null) continue;
            if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                routingDebugRequestContext.getMessage().append("host=" + string).append(" port=" + n).append(" uri=" + string2).append("\n");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"match", (Object)object);
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"match", null);
        }
        return null;
    }

    protected URIMatcher createURIMatcher(String string) {
        return new URIMatcher(string);
    }

    public static void setDebugURL(String string) throws Exception {
        debugVHostMatcher = new VHostMatcher();
        URL uRL = new URL(string);
        URIMatcher uRIMatcher = debugVHostMatcher.getURIMatcher(uRL.getHost(), uRL.getPort());
        uRIMatcher.put(uRL.getPath(), Boolean.TRUE);
    }

    public static void resetDebugVHostMatcher() {
        debugVHostMatcher = null;
    }

    protected class VHost {
        public final String host;
        public final int port;
        public final URIMatcher uriMatcher;

        public VHost(String string, int n) {
            this.host = string;
            this.port = n;
            this.uriMatcher = VHostMatcher.this.createURIMatcher(string + ":" + n);
        }

        public Object match(String string, int n, String string2) {
            boolean bl;
            boolean bl2 = bl = !(this.host != null && !this.host.equalsIgnoreCase(string) || this.port != -1 && this.port != n);
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + ":" + n + " does not match " + this));
                }
                return null;
            }
            Object object = this.uriMatcher.match(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + ":" + n + "/" + string2 + " match result is " + object));
            }
            return object;
        }

        public Object match(String string, int n, String string2, RoutingDebugRequestContext routingDebugRequestContext) {
            boolean bl;
            boolean bl2 = bl = !(this.host != null && !this.host.equalsIgnoreCase(string) || this.port != -1 && this.port != n);
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + ":" + n + " does not match " + this));
                }
                if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                    routingDebugRequestContext.getMessage().append(string + ":" + n + " does not match ").append(this.toString()).append("\n");
                }
                return null;
            }
            Object object = this.uriMatcher.match(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + ":" + n + "/" + string2 + " match result is " + object));
            }
            if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                routingDebugRequestContext.getMessage().append(string + ":" + n + "/" + string2 + " match result is ").append(object.toString().substring(0, object.toString().indexOf(60))).append("\n");
            }
            return object;
        }

        public boolean equals(String string, int n) {
            boolean bl = (this.host == null && string == null || this.host != null && this.host.equalsIgnoreCase(string)) && this.port == n;
            return bl;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

