/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.TargetClusterImpl;
import com.ibm.ws.dwlm.client.TargetSelectorImpl;
import com.ibm.ws.dwlm.client.TargetServerImpl;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.dwlm.client.Resumer;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetSelectorModule;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.dwlm.client.TargetServerApplication;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TargetServerApplicationImpl
implements TargetServerApplication,
TargetServer {
    protected static final TraceComponent tc = Tr.register((Class)TargetServerApplicationImpl.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected static final Waiter[] NO_WAITERS = new Waiter[0];
    protected static final TargetCluster[] NO_CLUSTERS = new TargetCluster[0];
    protected final HashSet memberClusters = new HashSet();
    protected final Set quiesceClusters = new HashSet();
    protected TargetCluster[] clusters = NO_CLUSTERS;
    public final String name;
    public final TargetServerImpl server;
    public ODCNode odcNode;
    public final ODCTree odcTree;
    protected final TargetSelectorImpl selector;
    protected final List waiters = new ArrayList();
    protected boolean quiescing = false;
    protected int outstandingRequests = 0;

    public TargetServerApplicationImpl(TargetServerImpl targetServerImpl, ODCNode oDCNode, TargetSelectorImpl targetSelectorImpl) {
        this.server = targetServerImpl;
        this.odcNode = oDCNode;
        this.selector = targetSelectorImpl;
        this.odcTree = oDCNode.getTree();
        this.name = targetServerImpl.getName() + "/" + oDCNode.getName();
    }

    public TargetServer getTargetServer() {
        return this.server;
    }

    public String getApplicationName() {
        return this.odcNode.getName();
    }

    public boolean isQuiescing() {
        return this.quiescing;
    }

    protected synchronized Waiter[] endQuiescingGetWaiters() {
        this.quiescing = false;
        Waiter[] waiterArray = this.waiters.toArray(NO_WAITERS);
        this.outstandingRequests += waiterArray.length;
        this.waiters.clear();
        return waiterArray;
    }

    public synchronized boolean beginRequest(Object object, Resumer resumer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beginRequest", (Object)this);
        }
        if (this.quiescing) {
            this.waiters.add(new Waiter(resumer, object));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"beginRequest", (Object)"waiting");
            }
            return false;
        }
        ++this.outstandingRequests;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("beginRequest: outstandingRequests=" + this.outstandingRequests));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beginRequest", (Object)"done");
        }
        return true;
    }

    protected synchronized boolean decrementCounter() {
        --this.outstandingRequests;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("decrementCounter: outstandingRequests=" + this.outstandingRequests));
        }
        if (this.outstandingRequests < 0) {
            throw new RuntimeException("outstandingRequests < 0: " + this.outstandingRequests);
        }
        return this.outstandingRequests == 0;
    }

    public String toString() {
        return this.name + ":" + this.hashCode();
    }

    public void beginQuiescing() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beginQuiescing ", (Object)this);
        }
        this.quiescing = true;
        this.stopRouting();
        if (this.outstandingRequests == 0) {
            this.completedMyQuiesce();
        }
    }

    public void endQuiescing() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endQuiescing", (Object)this.name);
        }
        this.quiescing = false;
        this.resumeRouting();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endQuiescing", (Object)this.name);
        }
    }

    public synchronized boolean beginRequest(Object object) throws Exception {
        if (this.quiescing) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"quiescing; defer request");
            }
            return false;
        }
        this.incrementCounter();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("beginRequest: outstandingRequests=" + this.outstandingRequests));
        }
        return true;
    }

    public void endRequest(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endRequest", (Object)this);
        }
        boolean bl = this.decrementCounter();
        if (this.quiescing && bl) {
            this.completedMyQuiesce();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endRequest", (Object)this);
        }
    }

    public synchronized int incrementCounter() {
        ++this.outstandingRequests;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("incrementCounter: outstandingRequests=" + this.outstandingRequests));
        }
        return this.outstandingRequests;
    }

    protected void completedMyQuiesce() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completedMyQuiesce", (Object)this);
        }
        this.routingEdgeChange(false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completedMyQuiesce", (Object)this);
        }
    }

    protected void resumeRouting() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resumeRouting", (Object)this);
        }
        this.routingEdgeChange(true);
        Iterator iterator = this.quiesceClusters.iterator();
        while (iterator.hasNext()) {
            TargetClusterImpl targetClusterImpl = (TargetClusterImpl)iterator.next();
            targetClusterImpl.decrementQuiesceCount(this);
        }
        this.quiesceClusters.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resumeRouting", (Object)this);
        }
    }

    protected void stopRouting() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopRouting", (Object)this);
        }
        for (int i = 0; i < this.clusters.length; ++i) {
            TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.clusters[i];
            this.quiesceClusters.add(targetClusterImpl);
            targetClusterImpl.incrementQuiesceCount(this);
            this.selector.removeServerFromCluster(this, targetClusterImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopRouting", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void routingEdgeChange(boolean bl) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"routingEdgeChange", (Object)new Object[]{this, new Boolean(bl)});
        }
        if ((oDCNode = TargetTree.getMyProxyContainer()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"adding proxyContainer-to-serverApplication edge");
            }
            ODCTree oDCTree = this.odcTree;
            synchronized (oDCTree) {
                this.odcNode = this.odcTree.refreshNode(this.odcNode);
                if (this.odcNode != null) {
                    if (bl) {
                        this.odcNode.addNode(oDCNode);
                    } else {
                        this.odcNode.removeNode(oDCNode);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"routingEdgeChange", (Object)new Object[]{this, new Boolean(bl)});
        }
    }

    public synchronized void addCluster(TargetCluster targetCluster) {
        this.memberClusters.add(targetCluster);
        this.clusters = this.memberClusters.toArray(NO_CLUSTERS);
    }

    public synchronized void removeCluster(TargetCluster targetCluster) {
        this.memberClusters.remove(targetCluster);
        this.clusters = this.memberClusters.toArray(NO_CLUSTERS);
    }

    public TargetCluster[] getClusters() {
        return this.clusters;
    }

    public String getCloneId() {
        return this.server.getCloneId();
    }

    public int getWeight() {
        return this.server.getWeight();
    }

    public void setWeight(int n) {
        this.server.setWeight(n);
    }

    public TargetDescriptor getTargetDescriptor(String string) {
        return this.server.getTargetDescriptor(string);
    }

    public boolean isLocal() {
        return this.server.isLocal();
    }

    public boolean isAvailable() {
        return this.server.isAvailable();
    }

    public boolean isUp() {
        return this.server.isUp();
    }

    public boolean isReachable() {
        return this.server.isReachable();
    }

    public void connectSuccess() {
        this.server.connectSuccess();
    }

    public void connectFailure() {
        this.server.connectFailure();
    }

    public void destroy() {
        this.server.destroy();
    }

    public synchronized void removeFromAllClusters() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeFromAllClusters", (Object)this);
        }
        Iterator iterator = ((HashSet)this.memberClusters.clone()).iterator();
        while (iterator.hasNext()) {
            TargetCluster targetCluster = (TargetCluster)iterator.next();
            try {
                this.selector.removeServerFromCluster(this, targetCluster);
            }
            catch (Throwable throwable) {
                TrUtil.warning((Throwable)throwable, (Object)this, (String)"removeFromAllClusters", (TraceComponent)tc);
            }
        }
        this.clusters = NO_CLUSTERS;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeFromAllClusters", (Object)this);
        }
    }

    public String getName() {
        return this.server.getName();
    }

    public Object getAttachment(TargetSelectorModule targetSelectorModule) {
        return this.server.getAttachment(targetSelectorModule);
    }

    public void setAttachment(TargetSelectorModule targetSelectorModule, Object object) {
        this.server.setAttachment(targetSelectorModule, object);
    }

    protected class Waiter {
        public final Resumer resumer;
        public final Object request;

        public Waiter(Resumer resumer, Object object) {
            this.resumer = resumer;
            this.request = object;
        }

        public String toString() {
            return this.request.toString();
        }
    }
}

