/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.OutboundChannelDefinitionImpl;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.dwlm.client.TargetServerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetDescriptorCallback;
import com.ibm.wsspi.dwlm.client.TargetServerApplication;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TargetDescriptorImpl
implements TargetDescriptor,
HttpAddress {
    protected static final TraceComponent tc = Tr.register((Class)TargetDescriptorImpl.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected static String pureNonblocking = "false";
    protected static int connectTimeout;
    public final String name;
    public final String protocol;
    public final String host;
    public final Integer port;
    public final InetSocketAddress addr;
    public final TargetServerImpl server;
    public final CFEndPoint endpoint;
    public final ChannelFramework channelFramework;
    public final ODCHelper odc;
    protected final Map outboundSSLProps;
    protected final int mySeqNo;
    protected final List channelNames = new ArrayList();
    protected final ODCNode odcChain;
    protected final String odcChainName;
    protected final ODCTree odcTree;
    protected final String cellName;
    protected final String nodeName;
    protected final String serverName;
    protected static int seqNo;
    protected boolean local = false;
    protected int refCnt = 1;
    protected TargetDescriptorCallback refCntCb = null;
    protected Object refCntCbArg = null;
    protected VirtualConnectionFactory vcf = null;

    public TargetDescriptorImpl(ODCNode oDCNode, ODCNode oDCNode2, Map map, ChannelFramework channelFramework, TargetServerImpl targetServerImpl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TargetDescriptorImpl", (Object)new Object[]{oDCNode, map, channelFramework, targetServerImpl});
        }
        this.odc = ODCHelper.getInstance();
        this.odcChain = oDCNode;
        this.odcChainName = oDCNode.getLongName();
        this.odcTree = oDCNode.getTree();
        ODCNode oDCNode3 = oDCNode.getParent();
        if (oDCNode3 == null) {
            throw new ODCException(oDCNode + " has no transport");
        }
        ODCNode oDCNode4 = oDCNode3.getParent();
        if (oDCNode4 == null) {
            throw new ODCException(oDCNode3 + " has no server");
        }
        ODCNode oDCNode5 = oDCNode4.getParent();
        if (oDCNode5 == null) {
            throw new ODCException(oDCNode4 + " has no node");
        }
        ODCNode oDCNode6 = oDCNode5.getParent();
        if (oDCNode6 == null) {
            throw new ODCException(oDCNode5 + " has no cell");
        }
        this.cellName = oDCNode6.getName();
        this.nodeName = oDCNode5.getName();
        this.serverName = oDCNode4.getName();
        this.mySeqNo = TargetDescriptorImpl.getSeqNo();
        this.name = oDCNode.getLongName() + "_seqno=" + this.mySeqNo;
        this.protocol = (String)oDCNode2.getProperty(this.odc.transportProtocol);
        this.host = (String)oDCNode2.getProperty(this.odc.transportHost);
        this.port = new Integer(oDCNode2.getIntProperty(this.odc.transportPort));
        this.outboundSSLProps = map;
        this.channelFramework = channelFramework;
        this.server = targetServerImpl;
        this.addr = new InetSocketAddress(this.host, (int)this.port);
        this.endpoint = (CFEndPoint)oDCNode.getProperty(this.odc.channelChainCFEndpoint);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TargetDescriptorImpl");
        }
    }

    protected VirtualConnectionFactory getVCF(int n, Map hashMap, ChannelFramework channelFramework) throws Exception {
        ODCNode[] oDCNodeArray = this.odcChain.getNodes(this.odc.channel);
        String[] stringArray = new String[oDCNodeArray.length];
        OutboundChannelDefinition[] outboundChannelDefinitionArray = new OutboundChannelDefinition[oDCNodeArray.length];
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            HashMap<String, String> hashMap2;
            ODCNode oDCNode = oDCNodeArray[i];
            String string = oDCNode.getPath() + "_seqno=" + n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("channelName=" + string));
            }
            stringArray[i] = string;
            String string2 = (String)oDCNode.getProperty(this.odc.channelFactoryClass);
            Class<?> clazz = Class.forName(string2);
            if (oDCNode.getName().equals("ssl")) {
                hashMap2 = hashMap;
                if (hashMap2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"null outboundSSLProps");
                    }
                    hashMap2 = new HashMap();
                }
            } else {
                hashMap2 = oDCNode.getProperties();
                hashMap2.remove(this.odc.channelFactoryClass.getName());
            }
            hashMap2 = new HashMap<String, String>(hashMap2);
            if (oDCNode.getName().equals("tcp")) {
                hashMap2.put("pureNonblocking", pureNonblocking);
            }
            outboundChannelDefinitionArray[i] = new OutboundChannelDefinitionImpl(clazz, null, hashMap2);
            channelFramework.addChannel(string, clazz, hashMap2);
            this.channelNames.add(string);
        }
        channelFramework.addChain(this.name, FlowType.OUTBOUND, stringArray);
        return channelFramework.getOutboundVCFactory(this.name);
    }

    protected VirtualConnectionFactory getVCF(CFEndPoint cFEndPoint, ChannelFramework channelFramework) throws Exception {
        WSChainData wSChainData = cFEndPoint.createOutboundChain();
        ChannelData[] channelDataArray = wSChainData.getChannelList();
        for (int i = 0; i < channelDataArray.length; ++i) {
            ChannelData channelData;
            ChannelData channelData2;
            Class clazz = channelDataArray[i].getFactoryType();
            String string = channelDataArray[i].getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("channelName=" + string));
            }
            if ((channelData2 = channelFramework.getChannel("DefaultOutboundChannelForChannel_" + clazz.getName())) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"updating global properties");
                }
                channelFramework.updateAllChannelProperties(string, channelData2.getPropertyBag());
            }
            if ((channelData = channelFramework.getChannel("DefaultOutboundChannelForChain_" + cFEndPoint.getName() + "_ChannelType_" + clazz.getName())) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updating chain specific properties");
            }
            channelFramework.updateAllChannelProperties(string, channelData2.getPropertyBag());
        }
        this.local = cFEndPoint.isLocal();
        ((ChannelFrameworkService)channelFramework).prepareEndPoint(cFEndPoint);
        if (cFEndPoint.isSSLEnabled()) {
            return cFEndPoint.getOutboundVCFactory(this.outboundSSLProps, true);
        }
        return cFEndPoint.getOutboundVCFactory();
    }

    protected void destroy() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (this.vcf != null) {
            try {
                this.vcf.destroy();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"103");
            }
            try {
                this.channelFramework.destroyChain(this.name);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"111");
            }
            try {
                this.channelFramework.removeChain(this.name);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"111");
            }
            this.vcf = null;
        }
        while ((n = this.channelNames.size()) > 0) {
            try {
                this.channelFramework.removeChannel((String)this.channelNames.remove(n - 1));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"119");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public boolean isLocal() {
        return this.local;
    }

    public synchronized void obtainRefCount() {
        this.validate();
        ++this.refCnt;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("refcount=" + this.refCnt + " for " + this));
        }
    }

    public synchronized boolean releaseRefCount() {
        this.validate();
        --this.refCnt;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("refcount=" + this.refCnt + " for " + this));
        }
        if (this.refCnt == 0) {
            if (this.refCntCb != null) {
                this.refCntCb.targetDescriptorDestroy(this.refCntCbArg);
            }
            this.destroy();
            return true;
        }
        return false;
    }

    public void setRefCountCallback(TargetDescriptorCallback targetDescriptorCallback, Object object) {
        this.validate();
        if (this.refCntCb != null) {
            throw new RuntimeException("call back already set");
        }
        this.refCntCb = targetDescriptorCallback;
        this.refCntCbArg = object;
    }

    public String getCellName() {
        this.validate();
        return this.cellName;
    }

    public String getNodeName() {
        this.validate();
        return this.nodeName;
    }

    public String getServerName() {
        this.validate();
        return this.serverName;
    }

    public ODCNode getODCChannelChain() {
        this.validate();
        return this.odcTree.refreshNode(this.odcChain);
    }

    public CFEndPoint getCFEndPoint() {
        this.validate();
        this.getVirtualConnectionFactory();
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualConnectionFactory getVirtualConnectionFactory() {
        this.validate();
        if (this.vcf == null) {
            TargetDescriptorImpl targetDescriptorImpl = this;
            synchronized (targetDescriptorImpl) {
                if (this.vcf == null) {
                    try {
                        this.vcf = this.endpoint == null ? this.getVCF(this.mySeqNo, this.outboundSSLProps, this.channelFramework) : this.getVCF(this.endpoint, this.channelFramework);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        }
        return this.vcf;
    }

    public TCPConnectRequestContext getConnectContext() {
        this.validate();
        return this;
    }

    public String getHostname() {
        this.validate();
        return this.host;
    }

    public boolean isForwardProxy() {
        this.validate();
        return false;
    }

    public InetSocketAddress getLocalAddress() {
        this.validate();
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        this.validate();
        return this.addr;
    }

    public int getConnectTimeout() {
        this.validate();
        return connectTimeout;
    }

    public void connectCallback(Exception exception) {
        if (exception == null) {
            this.server.connectSuccess();
        } else {
            this.server.connectFailure();
        }
    }

    public TargetServerApplication getTargetServerApplication(String string) {
        return this.server.getServerApplication(string);
    }

    public int hashCode() {
        return this.protocol.hashCode() + this.host.hashCode() + this.port.hashCode();
    }

    public boolean equals(Object object) {
        TargetDescriptorImpl targetDescriptorImpl = (TargetDescriptorImpl)object;
        return this.protocol.equals(targetDescriptorImpl.protocol) & this.host.equals(targetDescriptorImpl.host) & this.port.equals(targetDescriptorImpl.port);
    }

    public String toString() {
        return this.protocol + "://" + this.host + ":" + this.port + " (" + this.name + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTree() throws Exception {
        ODCTree oDCTree;
        StringBuffer stringBuffer = new StringBuffer();
        ODCTree oDCTree2 = oDCTree = ODCHelper.getInstance().mgr.findTree("target");
        synchronized (oDCTree2) {
            this.getTree(oDCTree.getRoot(), 0, stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected void getTree(ODCNode oDCNode, int n, StringBuffer stringBuffer) throws Exception {
        this.indent(n, stringBuffer).append(oDCNode.getLongName()).append(" ").append(oDCNode.getProperties().toString()).append("\n");
        ODCNode[] oDCNodeArray = oDCNode.getChildren();
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            this.getTree(oDCNodeArray[i], n + 1, stringBuffer);
        }
    }

    protected static synchronized int getSeqNo() {
        return seqNo++;
    }

    protected StringBuffer indent(int n, StringBuffer stringBuffer) {
        while (n-- > 0) {
            stringBuffer.append("  ");
        }
        return stringBuffer;
    }

    protected void validate() {
        if (this.refCnt <= 0) {
            throw new RuntimeException(this + " has already been destroyed");
        }
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        if (this.server.isAvailable()) {
            stringBuffer.append("Available Server: ").append(this.serverName).append("\n");
            stringBuffer.append("Server Weight   : ").append(this.server.getWeight()).append("\n");
            stringBuffer.append("Protocol        : ").append(this.protocol).append("\n");
            stringBuffer.append("FlowType        : ").append(this.vcf.getType().getOrdinal() == 0 ? "InBound" : "OutBound").append("\n");
        }
        return stringBuffer.toString();
    }

    static {
        try {
            Class.forName("com.ibm.ws.util.XDConstants");
            pureNonblocking = "true";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pureNonblocking = System.getProperty("com.ibm.ws.tcp.channel.pureNonblocking", pureNonblocking);
        connectTimeout = Integer.parseInt(System.getProperty("com.ibm.ws.tcp.channel.connectTimeout", "10000"));
        seqNo = 0;
    }
}

