/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.PartitionIDData;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.http.channel.HttpRequestMessage;

public class HttpSessionAffinityModule
extends HttpTargetSelectorModule {
    private static final TraceComponent tc = Tr.register((Class)HttpSessionAffinityModule.class, null, null);
    public static final String SSLJSESSIONID = "SSLJSESSION";
    public static final String JSESSIONID = "JSESSIONID";
    private static String[] sessionCookies = new String[]{"SSLJSESSION", "JSESSIONID"};
    private static PartitionIDData partitionIDData = PartitionIDData.EMPTY_PARTITION_ID_DATA;

    public String getName() {
        return "HttpSessionAffinity";
    }

    public TargetServer select(TargetCluster targetCluster, HttpRequestMessage httpRequestMessage) throws Exception {
        String string;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"select", (Object)new Object[]{targetCluster, httpRequestMessage});
        }
        String string2 = null;
        for (n2 = 0; n2 < sessionCookies.length; ++n2) {
            byte[] byArray = httpRequestMessage.getCookieValue(sessionCookies[n2]);
            if (byArray == null) continue;
            string2 = new String(byArray);
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("cookieName=" + sessionCookies[n2] + ", sid=" + string2));
            break;
        }
        if (string2 == null && (n = (string = httpRequestMessage.getRequestURI()).indexOf("jsessionid")) >= 0 && string.length() > (n += 11)) {
            string2 = string.substring(n);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URL encoding=" + string2));
            }
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"no session affinity");
            }
            return null;
        }
        n2 = string2.indexOf(58);
        if (n2 < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)("no colon in session ID: " + string2));
            }
            return null;
        }
        int n3 = string2.length();
        ++n2;
        while (n2 < n3) {
            int n4;
            TargetServer[] targetServerArray;
            TargetServer targetServer;
            String string3;
            int n5 = string2.indexOf(58, n2);
            if (n5 < 0) {
                string3 = string2.substring(n2);
                n2 = n3;
            } else {
                string3 = string2.substring(n2, n5 - 1);
                n2 = n5 + 1;
            }
            String string4 = (String)partitionIDData.getPartition2CloneIdMap().get(string3);
            if (string4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("partition id is: " + string3));
                }
                string3 = string4;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clone id is: " + string3));
            }
            if ((targetServer = targetCluster.findServerByCloneId(string3)) == null) continue;
            if (targetServer.isAvailable()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)targetServer);
                }
                return targetServer;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("breaking session affinity for " + string3 + " to " + targetServer));
            }
            if ((targetServerArray = targetCluster.getServers()).length == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)"no servers in cluster");
                }
                return null;
            }
            int n6 = n4 = Math.abs(string3.hashCode()) % targetServerArray.length;
            do {
                if ((targetServer = targetServerArray[n6++]).isAvailable()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"select", (Object)targetServer);
                    }
                    return targetServer;
                }
                if (n6 < targetServerArray.length) continue;
                n6 = 0;
            } while (n6 != n4);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"no failover session affinity");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"select", (Object)"no server with clone ID found");
        }
        return null;
    }

    public static String[] getSessionCookies() {
        return sessionCookies;
    }

    public static void setSessionCookies(String[] stringArray) {
        sessionCookies = stringArray;
    }

    public static void setPartitionIDData(PartitionIDData partitionIDData) {
        HttpSessionAffinityModule.partitionIDData = partitionIDData;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Partition Data set to: ", (Object)partitionIDData);
        }
    }

    public static PartitionIDData getPartitionIDData() {
        return partitionIDData;
    }
}

