/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStore;
import com.ibm.ws.security.orbssl.WSX509KeyManager;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.ssl.channel.impl.SSLChannel;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class WSSSLChannel
extends SSLChannel {
    private static final TraceComponent tc = Tr.register((Class)WSSSLChannel.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.WSSSLChannel";

    public WSSSLChannel(ChannelData channelData) {
        super(channelData);
        if (channelData.isInbound()) {
            this.delayInitialization = true;
        }
    }

    public void init() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        Map map = null;
        try {
            map = this.sslConfig.getProperties();
        }
        catch (NullPointerException nullPointerException) {
            throw new ChannelException((Throwable)nullPointerException);
        }
        if (map == null) {
            throw new ChannelException("SSL channel are null");
        }
        String string = null;
        try {
            string = (String)map.get("alias");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found alias in SSL properties, " + string));
            }
        }
        catch (ClassCastException classCastException) {
            throw new ChannelException((Throwable)classCastException);
        }
        if (string != null) {
            ChannelFramework channelFramework = this.sslConfig.getChannelFramework();
            SecurityService securityService = (SecurityService)channelFramework.lookupService(SecurityService.class);
            if (securityService != null) {
                Object object;
                Properties properties;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found security service, extracting security properties");
                }
                if ((properties = securityService.getSecureSocketLayer(string)) == null) {
                    String string2 = "Alias not found in security service, " + string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)string2);
                    }
                    throw new ChannelException(string2);
                }
                if (properties.containsKey("com.ibm.ssl.sslType")) {
                    object = (String)properties.get("com.ibm.ssl.sslType");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SSLConfig type: " + (String)object));
                    }
                    if (null != object && ((String)object).equals(SSLType.SSSL_LITERAL.toString())) {
                        throw new ChannelException("Invalid SSLConfig type: " + (String)object);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"com.ibm.ssl.sslType property not found by the security service");
                }
                object = properties.keys();
                Object object2 = null;
                Object object3 = null;
                while (object.hasMoreElements()) {
                    object2 = object.nextElement();
                    if (object2 == null || (object3 = properties.get(object2)) == null) continue;
                    if (!map.containsKey(object2)) {
                        map.put(object2, object3);
                        if (!tc.isDebugEnabled()) continue;
                        if (object3 instanceof String && (object2.equals("com.ibm.ssl.trustStorePassword") || object2.equals("com.ibm.ssl.keyStorePassword") || object2.equals("com.ibm.ssl.tokenPassword"))) {
                            Tr.debug((TraceComponent)tc, (String)("Put property key: " + object2 + "  value: *******"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Put property key: " + object2 + "  value: " + object3));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Property key ignored: " + object2 + "  value: " + object3));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to locate security service.");
            }
        }
        this.sslConfig.setProperties(map);
        super.init();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    protected void initSSLContext() throws Exception {
        int n;
        char[] cArray;
        TrustManager[] trustManagerArray;
        String string;
        String string2;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initSSLContext");
            }
            string2 = this.sslConfig.getKeyStoreClientAlias();
            string = this.sslConfig.getKeyStoreServerAlias();
            trustManagerArray = null;
            if (this.trustManagerFactory != null) {
                trustManagerArray = this.trustManagerFactory.getTrustManagers();
            }
            cArray = null;
            if (this.sslConfig.getKeyStorePassword() != null) {
                cArray = this.sslConfig.getKeyStorePassword().toCharArray();
            }
            n = -1;
            if (this.sslConfig.getTokenSlot() != null) {
                try {
                    n = Integer.valueOf(this.sslConfig.getTokenSlot());
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)("Value of tokenSlot is invalid, using default of " + n));
                }
            }
        }
        WSX509KeyManager wSX509KeyManager = new WSX509KeyManager(this.keyStore, cArray, this.keyManagerFactory);
        if (this.sslConfig.isInbound()) {
            if (wSX509KeyManager == null || wSX509KeyManager.getX509KeyManager() == null || string == null && string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No alias used since either aliases not set or issues with wsKeyManager.");
                }
                KeyManager[] keyManagerArray = this.keyManagerFactory != null ? this.keyManagerFactory.getKeyManagers() : null;
                this.sslContext.init(keyManagerArray, trustManagerArray, null);
            } else {
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting client alias");
                    }
                    wSX509KeyManager.setClientAlias(string2, n);
                }
                if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting server alias");
                    }
                    wSX509KeyManager.setServerAlias(string, n);
                }
                KeyManager[] keyManagerArray = new KeyManager[]{wSX509KeyManager};
                this.sslContext.init(keyManagerArray, trustManagerArray, null);
            }
        } else if (wSX509KeyManager == null || wSX509KeyManager.getX509KeyManager() == null || string2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No alias used since either alias not set or issues with wsKeyManager.");
            }
            KeyManager[] keyManagerArray = this.keyManagerFactory != null ? this.keyManagerFactory.getKeyManagers() : null;
            this.sslContext.init(keyManagerArray, trustManagerArray, null);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting client alias");
            }
            wSX509KeyManager.setClientAlias(string2, n);
            KeyManager[] keyManagerArray = new KeyManager[]{wSX509KeyManager};
            this.sslContext.init(keyManagerArray, trustManagerArray, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initSSLContext");
        }
    }

    protected boolean isZOS() {
        boolean bl = false;
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper != null) {
            bl = platformHelper.isZOS();
        }
        return bl;
    }

    protected void enableHardwareProvider() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enableHardwareProvider");
        }
        try {
            if (!this.XD) {
                String string = this.sslConfig.getTokenLibraryFile();
                if (this.sslConfig.getTokenSlot() != null) {
                    string = string + ":" + this.sslConfig.getTokenSlot();
                }
                WSPKCSInKeyStore.initializePKCS11ImplProvider((String)string, (String)this.sslConfig.getTokenPassword());
            } else {
                Provider provider = Security.getProvider("IBMPKCS11Impl");
                if (provider == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding crypto provider to security.");
                    }
                    Preferences preferences = Preferences.userNodeForPackage(IBMPKCS11Impl.class);
                    preferences.put("IBMPKCSImpl DLL", this.sslConfig.getTokenLibraryFile() + ":" + this.sslConfig.getTokenSlot());
                    preferences.put("IBMPKCSImpl password", this.sslConfig.getTokenPassword());
                    AddHardwareProviderAction addHardwareProviderAction = new AddHardwareProviderAction();
                    AccessController.doPrivileged(addHardwareProviderAction);
                    preferences.remove("IBMPKCSImpl DLL");
                    preferences.remove("IBMPKCSImpl password");
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught while enabling hardware provider: " + exception));
            }
            FFDCFilter.processException((Throwable)exception, (String)CLASS_NAME, (String)"264", (Object)exception);
            throw new ChannelException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableHardwareProvider");
        }
    }

    class AddHardwareProviderAction
    implements PrivilegedAction {
        public Object run() {
            Security.addProvider((Provider)new IBMPKCS11Impl());
            return null;
        }
    }
}

